/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import java.util.Objects;
import org.kohsuke.github.GHCommitState;

public class GitHubNotificationRequest {
    private final String context;
    private final String url;
    private final String message;
    private final GHCommitState state;
    private final boolean ignoreError;

    private GitHubNotificationRequest(String context, String url, String message, GHCommitState state, boolean ignoreError) {
        this.context = context;
        this.url = url;
        this.message = message;
        this.state = state;
        this.ignoreError = ignoreError;
    }

    public static GitHubNotificationRequest build(String context, String url, String message, GHCommitState state, boolean ignoreError) {
        return new GitHubNotificationRequest(context, url, message, state, ignoreError);
    }

    public String getContext() {
        return this.context;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMessage() {
        return this.message;
    }

    public GHCommitState getState() {
        return this.state;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public String toString() {
        return "GitHubNotificationRequest{context='" + this.context + "', url='" + this.url + "', message='" + this.message + "', state=" + this.state + ", ignoreError=" + this.ignoreError + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitHubNotificationRequest that = (GitHubNotificationRequest)o;
        if (this.ignoreError != that.ignoreError) {
            return false;
        }
        if (!Objects.equals(this.context, that.context)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.ignoreError ? 1 : 0);
        return result;
    }
}

