/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.okhttp.api.JenkinsOkHttpClient;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.util.SystemProperties;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.github_branch_source.ApiRateLimitChecker;
import org.jenkinsci.plugins.github_branch_source.GitHubAppCredentials;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.jenkinsci.plugins.github_branch_source.GitHubConsoleNote;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMProbe;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.InvalidPrivateKeyException;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitChecker;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.authorization.ImmutableAuthorizationProvider;
import org.kohsuke.github.extras.okhttp3.OkHttpConnector;

@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
public class Connector {
    private static final Logger LOGGER = Logger.getLogger(Connector.class.getName());
    private static final Map<ConnectionId, GitHubConnection> connections = new ConcurrentHashMap<ConnectionId, GitHubConnection>();
    private static final Map<GitHub, ConnectionId> reverseLookup = new ConcurrentHashMap<GitHub, ConnectionId>();
    private static final Map<TaskListener, Map<GitHub, Void>> checked = new WeakHashMap<TaskListener, Map<GitHub, Void>>();
    private static final long API_URL_REVALIDATE_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final Random ENTROPY = new Random();
    private static final String SALT = Long.toHexString(ENTROPY.nextLong());
    private static final OkHttpClient baseClient = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).build();
    public static final RateLimitHandler CUSTOMIZED = new RateLimitHandler(){

        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            try {
                long limit = Long.parseLong(uc.getHeaderField("X-RateLimit-Limit"));
                long remaining = Long.parseLong(uc.getHeaderField("X-RateLimit-Remaining"));
                long reset = Long.parseLong(uc.getHeaderField("X-RateLimit-Reset"));
                throw new RateLimitExceededException("GitHub API rate limit exceeded", limit, remaining, reset);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe);
            }
        }
    };

    private Connector() {
        throw new IllegalAccessError("Utility class");
    }

    @Deprecated
    @NonNull
    public static ListBoxModel listScanCredentials(@CheckForNull SCMSourceOwner context, String apiUri) {
        return Connector.listScanCredentials((Item)context, apiUri);
    }

    @NonNull
    public static ListBoxModel listScanCredentials(@CheckForNull Item context, String apiUri) {
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, StandardUsernameCredentials.class, Connector.githubDomainRequirements(apiUri), Connector.githubScanCredentialsMatcher());
    }

    @Deprecated
    public static FormValidation checkScanCredentials(@CheckForNull SCMSourceOwner context, String apiUri, String scanCredentialsId) {
        return Connector.checkScanCredentials((Item)context, apiUri, scanCredentialsId);
    }

    @Deprecated
    public static FormValidation checkScanCredentials(@CheckForNull Item context, String apiUri, String scanCredentialsId) {
        return Connector.checkScanCredentials(context, apiUri, scanCredentialsId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FormValidation checkScanCredentials(@CheckForNull Item context, String apiUri, String scanCredentialsId, @CheckForNull String repoOwner) {
        if (context == null) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) return FormValidation.ok();
        }
        if (context != null && !context.hasPermission(Item.EXTENDED_READ)) {
            return FormValidation.ok();
        }
        if (scanCredentialsId.isEmpty()) return FormValidation.warning((String)"Credentials are recommended");
        ListBoxModel options = Connector.listScanCredentials(context, apiUri);
        boolean found = false;
        for (ListBoxModel.Option b : options) {
            if (!scanCredentialsId.equals(b.value)) continue;
            found = true;
            break;
        }
        if (!found) {
            return FormValidation.error((String)"Credentials not found");
        }
        if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
            return FormValidation.ok((String)"Credentials found");
        }
        StandardCredentials credentials = Connector.lookupScanCredentials(context, StringUtils.defaultIfEmpty((String)apiUri, (String)"https://api.github.com"), scanCredentialsId, repoOwner);
        if (credentials == null) {
            return FormValidation.error((String)"Credentials not found");
        }
        try {
            GitHub connector = Connector.connect(apiUri, credentials);
            try {
                boolean githubAppAuthentication = credentials instanceof GitHubAppCredentials;
                if (githubAppAuthentication) {
                    int remaining = connector.getRateLimit().getRemaining();
                    FormValidation formValidation = FormValidation.ok((String)"GHApp verified, remaining rate limit: %d", (Object[])new Object[]{remaining});
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.ok((String)"User %s", (Object[])new Object[]{connector.getMyself().getLogin()});
                return formValidation;
            }
            catch (Exception e) {
                FormValidation formValidation2 = FormValidation.error((String)"Invalid credentials: %s", (Object[])new Object[]{e.getMessage()});
                return formValidation2;
            }
            finally {
                Connector.release(connector);
            }
        }
        catch (IllegalArgumentException | InvalidPrivateKeyException e2) {
            String msg = "Exception validating credentials " + CredentialsNameProvider.name((Credentials)credentials);
            LOGGER.log(Level.WARNING, msg, e2);
            return FormValidation.error((Throwable)e2, (String)msg);
        }
        catch (IOException e3) {
            LOGGER.log(Level.WARNING, "Exception validating credentials {0} on {1}", new Object[]{CredentialsNameProvider.name((Credentials)credentials), apiUri});
            return FormValidation.error((String)"Exception validating credentials");
        }
    }

    @Deprecated
    @CheckForNull
    public static StandardCredentials lookupScanCredentials(@CheckForNull SCMSourceOwner context, @CheckForNull String apiUri, @CheckForNull String scanCredentialsId) {
        return Connector.lookupScanCredentials((Item)context, apiUri, scanCredentialsId);
    }

    @Deprecated
    @CheckForNull
    public static StandardCredentials lookupScanCredentials(@CheckForNull Item context, @CheckForNull String apiUri, @CheckForNull String scanCredentialsId) {
        return Connector.lookupScanCredentials(context, apiUri, scanCredentialsId, null);
    }

    @CheckForNull
    public static StandardCredentials lookupScanCredentials(@CheckForNull Item context, @CheckForNull String apiUri, @CheckForNull String scanCredentialsId, @CheckForNull String repoOwner) {
        if (Util.fixEmpty((String)scanCredentialsId) == null) {
            return null;
        }
        StandardCredentials c = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), Connector.githubDomainRequirements(apiUri)), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)scanCredentialsId), Connector.githubScanCredentialsMatcher()}));
        if (c instanceof GitHubAppCredentials && repoOwner != null) {
            return ((GitHubAppCredentials)c).withOwner(repoOwner);
        }
        return c;
    }

    @NonNull
    public static ListBoxModel listCheckoutCredentials(@CheckForNull SCMSourceOwner context, String apiUri) {
        return Connector.listCheckoutCredentials((Item)context, apiUri);
    }

    @NonNull
    public static ListBoxModel listCheckoutCredentials(@CheckForNull Item context, String apiUri) {
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        result.add("- same as scan credentials -", "SAME");
        result.add("- anonymous -", "ANONYMOUS");
        return result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, StandardUsernameCredentials.class, Connector.githubDomainRequirements(apiUri), GitClient.CREDENTIALS_MATCHER);
    }

    @NonNull
    public static GitHub connect(@CheckForNull String apiUri, @CheckForNull StandardCredentials credentials) throws IOException {
        GitHubAppCredentials gitHubAppCredentials;
        String authHash;
        String hash;
        String password;
        String username;
        String apiUrl = (apiUri = Util.fixEmptyAndTrim((String)apiUri)) != null ? apiUri : "https://api.github.com";
        Jenkins jenkins = Jenkins.get();
        if (credentials == null) {
            username = null;
            password = null;
            hash = "anonymous";
            authHash = "anonymous";
            gitHubAppCredentials = null;
        } else if (credentials instanceof GitHubAppCredentials) {
            password = null;
            gitHubAppCredentials = (GitHubAppCredentials)credentials;
            hash = Util.getDigestOf((String)(gitHubAppCredentials.getAppID() + gitHubAppCredentials.getOwner() + gitHubAppCredentials.getPrivateKey().getPlainText() + SALT));
            authHash = Util.getDigestOf((String)(gitHubAppCredentials.getAppID() + "::" + gitHubAppCredentials.getOwner() + "::" + gitHubAppCredentials.getPrivateKey().getPlainText() + "::" + jenkins.getLegacyInstanceId()));
            username = gitHubAppCredentials.getUsername();
        } else if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)credentials;
            username = c.getUsername();
            password = c.getPassword().getPlainText();
            hash = Util.getDigestOf((String)(password + SALT));
            authHash = Util.getDigestOf((String)(password + "::" + jenkins.getLegacyInstanceId()));
            gitHubAppCredentials = null;
        } else {
            throw new IOException("Unsupported credential type: " + credentials.getClass().getName());
        }
        ConnectionId connectionId = new ConnectionId(apiUrl, hash);
        GitHubConnection record = GitHubConnection.lookup(connectionId, () -> {
            try {
                Cache cache = Connector.getCache(jenkins, apiUrl, authHash, username);
                GitHubBuilder gb = Connector.createGitHubBuilder(apiUrl, cache);
                if (gitHubAppCredentials != null) {
                    gb.withAuthorizationProvider(gitHubAppCredentials.getAuthorizationProvider());
                } else if (username != null && password != null) {
                    gb.withAuthorizationProvider(ImmutableAuthorizationProvider.fromLoginAndPassword((String)username, (String)password));
                }
                return new GitHubConnection(gb.build(), cache, credentials instanceof GitHubAppCredentials);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        record.verifyConnection();
        return record.getGitHub();
    }

    static GitHubBuilder createGitHubBuilder(@NonNull String apiUrl) throws IOException {
        return Connector.createGitHubBuilder(apiUrl, null);
    }

    @NonNull
    private static GitHubBuilder createGitHubBuilder(@NonNull String apiUrl, @CheckForNull Cache cache) throws IOException {
        GitHubBuilder gb = new GitHubBuilder();
        gb.withEndpoint(apiUrl);
        gb.withRateLimitChecker((RateLimitChecker)new ApiRateLimitChecker.RateLimitCheckerAdapter());
        gb.withRateLimitHandler(CUSTOMIZED);
        OkHttpClient.Builder clientBuilder = baseClient.newBuilder();
        if (cache != null) {
            clientBuilder.cache(cache);
        }
        gb.withConnector((HttpConnector)new OkHttpConnector(clientBuilder.build()));
        return gb;
    }

    @CheckForNull
    private static Cache getCache(@NonNull Jenkins jenkins, @NonNull String apiUrl, @NonNull String authHash, @CheckForNull String username) {
        Cache cache = null;
        int cacheSize = GitHubSCMSource.getCacheSize();
        if (cacheSize > 0) {
            String cacheRootDir = SystemProperties.getString((String)(GitHubSCMSource.class.getName() + ".cacheRootDir"));
            File cacheBase = cacheRootDir != null ? new File(cacheRootDir) : new File(jenkins.getRootDir(), GitHubSCMProbe.class.getName() + ".cache");
            File cacheDir = null;
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                sha256.update(apiUrl.getBytes(StandardCharsets.UTF_8));
                sha256.update("::".getBytes(StandardCharsets.UTF_8));
                if (username != null) {
                    sha256.update(username.getBytes(StandardCharsets.UTF_8));
                }
                sha256.update("::".getBytes(StandardCharsets.UTF_8));
                sha256.update(authHash.getBytes(StandardCharsets.UTF_8));
                cacheDir = new File(cacheBase, Base64.getUrlEncoder().withoutPadding().encodeToString(sha256.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (cacheDir != null) {
                cache = new Cache(cacheDir, (long)cacheSize * 1024L * 1024L);
            }
        }
        return cache;
    }

    public static void release(@CheckForNull GitHub hub) {
        if (hub == null) {
            return;
        }
        ConnectionId connectionId = reverseLookup.get(hub);
        if (connectionId == null) {
            return;
        }
        GitHubConnection record = connections.get(connectionId);
        if (record != null) {
            try {
                record.release();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "There is a mismatch in connect and release calls.", e);
            }
        }
    }

    private static CredentialsMatcher githubScanCredentialsMatcher() {
        return CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});
    }

    static List<DomainRequirement> githubDomainRequirements(String apiUri) {
        return URIRequirementBuilder.fromUri((String)StringUtils.defaultIfEmpty((String)apiUri, (String)"https://api.github.com")).build();
    }

    static boolean isCredentialValid(GitHub gitHub) {
        if (gitHub.isAnonymous()) {
            return true;
        }
        try {
            GitHubConfiguration gitHubConfiguration = GitHubConfiguration.get();
            if (gitHubConfiguration != null && gitHubConfiguration.getApiRateLimitChecker() == ApiRateLimitChecker.NoThrottle) {
                gitHub.getMeta();
            } else {
                gitHub.getRateLimit();
            }
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Exception validating credentials on " + gitHub.getApiUrl(), e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkConnectionValidity(String apiUri, @NonNull TaskListener listener, StandardCredentials credentials, GitHub github) throws IOException {
        Map<TaskListener, Map<GitHub, Void>> map = checked;
        synchronized (map) {
            Map<GitHub, Void> hubs = checked.get(listener);
            if (hubs != null && hubs.containsKey(github)) {
                return;
            }
            if (hubs == null) {
                hubs = new WeakHashMap<GitHub, Void>();
                checked.put(listener, hubs);
            }
            hubs.put(github, null);
        }
        if (credentials != null && !Connector.isCredentialValid(github)) {
            String message = String.format("Invalid scan credentials %s to connect to %s, skipping", CredentialsNameProvider.name((Credentials)credentials), apiUri == null ? "https://api.github.com" : apiUri);
            throw new AbortException(message);
        }
        if (!github.isAnonymous()) {
            assert (credentials != null);
            listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("Connecting to %s using %s", apiUri == null ? "https://api.github.com" : apiUri, CredentialsNameProvider.name((Credentials)credentials))));
        } else {
            listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("Connecting to %s with no credentials, anonymous access", apiUri == null ? "https://api.github.com" : apiUri)));
        }
    }

    static void configureLocalRateLimitChecker(@NonNull TaskListener listener, GitHub github) throws IOException, InterruptedException {
        ApiRateLimitChecker.configureThreadLocalChecker(listener, github);
    }

    private static class ConnectionId {
        private final String apiUrl;
        private final String credentialsHash;

        ConnectionId(String apiUrl, String credentialsHash) {
            this.apiUrl = apiUrl;
            this.credentialsHash = credentialsHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionId that = (ConnectionId)o;
            if (!Objects.equals(this.apiUrl, that.apiUrl)) {
                return false;
            }
            return StringUtils.equals((String)this.credentialsHash, (String)that.credentialsHash);
        }

        public int hashCode() {
            return this.apiUrl != null ? this.apiUrl.hashCode() : 0;
        }

        public String toString() {
            return "ConnectionId{apiUrl='" + this.apiUrl + "', credentialsHash=" + this.credentialsHash + "}";
        }
    }

    static class GitHubConnection {
        @NonNull
        private final GitHub gitHub;
        @CheckForNull
        private final Cache cache;
        private final boolean cleanupCacheFolder;
        private final AtomicInteger usageCount = new AtomicInteger(1);
        private final AtomicLong lastUsed = new AtomicLong(System.currentTimeMillis());
        private long lastVerified = Long.MIN_VALUE;

        private GitHubConnection(GitHub gitHub, Cache cache, boolean cleanupCacheFolder) {
            this.gitHub = gitHub;
            this.cache = cache;
            this.cleanupCacheFolder = cleanupCacheFolder;
        }

        public GitHub getGitHub() {
            return this.gitHub;
        }

        @NonNull
        private static GitHubConnection lookup(@NonNull ConnectionId connectionId, @NonNull Supplier<GitHubConnection> generator) {
            GitHubConnection record = connections.compute(connectionId, (id, connection) -> {
                if (connection == null) {
                    connection = (GitHubConnection)generator.get();
                    reverseLookup.put(connection.gitHub, (ConnectionId)id);
                } else {
                    connection.usageCount.incrementAndGet();
                    connection.lastUsed.set(System.currentTimeMillis());
                }
                return connection;
            });
            return record;
        }

        private void release() throws IOException {
            long count = this.usageCount.decrementAndGet();
            if (count < 0L) {
                this.usageCount.incrementAndGet();
                throw new IOException("Tried to release a GitHubConnection that should have no references.");
            }
            this.lastUsed.compareAndSet(this.lastUsed.get(), System.currentTimeMillis());
        }

        private static void removeAllUnused(long threshold) throws IOException {
            for (ConnectionId connectionId : connections.keySet()) {
                connections.computeIfPresent(connectionId, (id, record) -> {
                    long lastUse = record.lastUsed.get();
                    if (record.usageCount.get() == 0 && lastUse < threshold) {
                        try {
                            if (record.cache != null && record.cleanupCacheFolder) {
                                record.cache.delete();
                                record.cache.close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Exception removing cache directory for unused connection: " + id, e);
                        }
                        reverseLookup.remove(record.gitHub);
                        record = null;
                    }
                    return record;
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verifyConnection() throws IOException {
            GitHubConnection gitHubConnection = this;
            synchronized (gitHubConnection) {
                if (this.lastVerified > System.currentTimeMillis() - API_URL_REVALIDATE_MILLIS) {
                    return;
                }
                ApiRateLimitChecker.verifyConnection(this.gitHub);
                this.lastVerified = System.currentTimeMillis();
            }
        }
    }

    @Extension
    public static class UnusedConnectionDestroyer
    extends PeriodicWork {
        public long getRecurrencePeriod() {
            return TimeUnit.MINUTES.toMillis(5L);
        }

        protected void doRun() throws Exception {
            long unusedThreshold = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(30L);
            GitHubConnection.removeAllUnused(unusedThreshold);
        }
    }
}

