/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.MarkupText;
import hudson.Plugin;
import hudson.Util;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.GitSCM;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.math.NumberUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.AuthenticationException;

public class GitChangeSet
extends ChangeLogSet.Entry {
    private static final String PREFIX_AUTHOR = "author ";
    private static final String PREFIX_COMMITTER = "committer ";
    private static final String IDENTITY = "([^<]*)<(.*)> (.*)";
    private static final Pattern FILE_LOG_ENTRY = Pattern.compile("^:[0-9]{6} [0-9]{6} ([0-9a-f]{40}) ([0-9a-f]{40}) ([ACDMRTUX])(?>[0-9]+)?\t(.*)$");
    private static final Pattern AUTHOR_ENTRY = Pattern.compile("^author ([^<]*)<(.*)> (.*)$");
    private static final Pattern COMMITTER_ENTRY = Pattern.compile("^committer ([^<]*)<(.*)> (.*)$");
    private static final Pattern RENAME_SPLIT = Pattern.compile("^(.*?)\t(.*)$");
    private static final String NULL_HASH = "0000000000000000000000000000000000000000";
    private static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String ISO_8601_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ssX";
    static final int TRUNCATE_LIMIT = 72;
    private final DateTimeFormatter[] dateFormatters;
    public static final Logger LOGGER = Logger.getLogger(GitChangeSet.class.getName());
    private String committer;
    private String committerEmail;
    private String committerTime;
    private String author;
    private String authorEmail;
    private String authorTime;
    private String comment;
    private String title;
    private String id;
    private String parentCommit;
    private Collection<Path> paths = new HashSet<Path>();
    private boolean authorOrCommitter;
    private boolean showEntireCommitSummaryInChanges;

    public GitChangeSet(List<String> lines, boolean authorOrCommitter) {
        this(lines, authorOrCommitter, GitChangeSet.isShowEntireCommitSummaryInChanges());
    }

    private DateTimeFormatterBuilder addZoneOffset(DateTimeFormatterBuilder builder) {
        builder.optionalStart().appendOffset("+HH:MM", "+00:00").optionalEnd();
        builder.optionalStart().appendOffset("+HHMM", "+0000").optionalEnd();
        builder.optionalStart().appendOffset("+HH", "Z").optionalEnd();
        return builder;
    }

    public GitChangeSet(List<String> lines, boolean authorOrCommitter, boolean retainFullCommitSummary) {
        this.authorOrCommitter = authorOrCommitter;
        this.showEntireCommitSummaryInChanges = retainFullCommitSummary;
        if (lines.size() > 0) {
            this.parseCommit(lines);
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ISO_LOCAL_DATE);
        builder.appendLiteral(' ');
        builder.append(DateTimeFormatter.ISO_LOCAL_TIME);
        builder.optionalStart().appendLiteral(' ').optionalEnd();
        this.addZoneOffset(builder);
        DateTimeFormatter gitDateFormatter = builder.toFormatter();
        builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        this.addZoneOffset(builder);
        DateTimeFormatter nearlyISOFormatter = builder.toFormatter();
        this.dateFormatters = new DateTimeFormatter[3];
        this.dateFormatters[0] = gitDateFormatter;
        this.dateFormatters[1] = nearlyISOFormatter;
        this.dateFormatters[2] = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    }

    static boolean isShowEntireCommitSummaryInChanges() {
        try {
            return new GitSCM.DescriptorImpl().isShowEntireCommitSummaryInChanges();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void parseCommit(List<String> lines) {
        StringBuilder message = new StringBuilder();
        for (String line : lines) {
            String mode;
            Matcher fileMatcher;
            String[] split;
            if (line.length() < 1) continue;
            if (line.startsWith("commit ")) {
                split = line.split(" ");
                if (split.length > 1) {
                    this.id = split[1];
                    continue;
                }
                throw new IllegalArgumentException("Commit has no ID" + String.valueOf(lines));
            }
            if (line.startsWith("tree ")) continue;
            if (line.startsWith("parent ")) {
                split = line.split(" ");
                if (split.length <= 1) continue;
                this.parentCommit = split[1];
                continue;
            }
            if (line.startsWith(PREFIX_COMMITTER)) {
                Matcher committerMatcher = COMMITTER_ENTRY.matcher(line);
                if (!committerMatcher.matches() || committerMatcher.groupCount() < 3) continue;
                this.committer = committerMatcher.group(1).trim();
                this.committerEmail = committerMatcher.group(2);
                this.committerTime = this.isoDateFormat(committerMatcher.group(3));
                continue;
            }
            if (line.startsWith(PREFIX_AUTHOR)) {
                Matcher authorMatcher = AUTHOR_ENTRY.matcher(line);
                if (!authorMatcher.matches() || authorMatcher.groupCount() < 3) continue;
                this.author = authorMatcher.group(1).trim();
                this.authorEmail = authorMatcher.group(2);
                this.authorTime = this.isoDateFormat(authorMatcher.group(3));
                continue;
            }
            if (line.startsWith("    ")) {
                message.append(line.substring(4)).append('\n');
                continue;
            }
            if (':' != line.charAt(0) || !(fileMatcher = FILE_LOG_ENTRY.matcher(line)).matches() || fileMatcher.groupCount() < 4 || (mode = fileMatcher.group(3)).length() != 1) continue;
            String src = null;
            String dst = null;
            String path = fileMatcher.group(4);
            char editMode = mode.charAt(0);
            if (editMode == 'M' || editMode == 'A' || editMode == 'D' || editMode == 'R' || editMode == 'C') {
                src = this.parseHash(fileMatcher.group(1));
                dst = this.parseHash(fileMatcher.group(2));
            }
            if (editMode == 'R') {
                Matcher renameSplitMatcher = RENAME_SPLIT.matcher(path);
                if (!renameSplitMatcher.matches() || renameSplitMatcher.groupCount() < 2) continue;
                String oldPath = renameSplitMatcher.group(1);
                String newPath = renameSplitMatcher.group(2);
                this.paths.add(new Path(src, dst, 'D', oldPath, this));
                this.paths.add(new Path(src, dst, 'A', newPath, this));
                continue;
            }
            if (editMode == 'C') {
                Matcher copySplitMatcher = RENAME_SPLIT.matcher(path);
                if (!copySplitMatcher.matches() || copySplitMatcher.groupCount() < 2) continue;
                String newPath = copySplitMatcher.group(2);
                this.paths.add(new Path(src, dst, 'A', newPath, this));
                continue;
            }
            this.paths.add(new Path(src, dst, editMode, path, this));
        }
        this.comment = message.toString();
        int endOfFirstLine = this.comment.indexOf(10);
        this.title = endOfFirstLine == -1 ? this.comment.trim() : this.comment.substring(0, endOfFirstLine).trim();
        if (!this.showEntireCommitSummaryInChanges) {
            this.title = GitChangeSet.splitString(this.title, 72);
        }
    }

    static String splitString(String msg, int lineSize) {
        if (msg == null) {
            return "";
        }
        if (msg.matches(".*[\r\n].*")) {
            String[] msgArray = msg.split("[\r\n]");
            msg = msgArray[0];
        }
        if (msg.length() <= lineSize || !msg.contains(" ")) {
            return msg;
        }
        int lastSpace = msg.lastIndexOf(32, lineSize);
        if (lastSpace == -1) {
            lastSpace = msg.indexOf(32);
        }
        return lastSpace == -1 ? msg : msg.substring(0, lastSpace);
    }

    private String isoDateFormat(String s) {
        String date = s;
        String timezone = "Z";
        int spaceIndex = s.indexOf(32);
        if (spaceIndex > 0) {
            date = s.substring(0, spaceIndex);
            timezone = s.substring(spaceIndex + 1);
        }
        if (NumberUtils.isDigits((String)date)) {
            long time = Long.parseLong(date);
            SimpleDateFormat formatter = new SimpleDateFormat(ISO_8601);
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            return formatter.format(new Date(time * 1000L)) + timezone;
        }
        return s;
    }

    private String parseHash(String hash) {
        return NULL_HASH.equals(hash) ? null : hash;
    }

    @Exported
    public String getDate() {
        return this.authorOrCommitter ? this.authorTime : this.committerTime;
    }

    @Exported
    public String getAuthorEmail() {
        return this.authorOrCommitter ? this.authorEmail : this.committerEmail;
    }

    public long getTimestamp() {
        String date = this.getDate();
        if (date == null) {
            LOGGER.log(Level.WARNING, "Failed to parse null date");
            return -1L;
        }
        if (date.isEmpty()) {
            LOGGER.log(Level.WARNING, "Failed to parse empty date");
            return -1L;
        }
        for (DateTimeFormatter dateFormatter : this.dateFormatters) {
            try {
                ZonedDateTime dateTime = ZonedDateTime.parse(date, dateFormatter);
                return dateTime.toEpochSecond() * 1000L;
            }
            catch (IllegalArgumentException | DateTimeParseException runtimeException) {
            }
        }
        try {
            LOGGER.log(Level.FINE, "Parsing {0} with SimpleDateFormat because other parsers failed", date);
            return new SimpleDateFormat(ISO_8601_WITH_TZ).parse(date).getTime();
        }
        catch (IllegalArgumentException | ParseException e) {
            return -1L;
        }
    }

    public String getCommitId() {
        return this.id;
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    @CheckForNull
    public String getParentCommit() {
        return this.parentCommit;
    }

    public Collection<String> getAffectedPaths() {
        HashSet<String> affectedPaths = new HashSet<String>(this.paths.size());
        for (Path file : this.paths) {
            affectedPaths.add(file.getPath());
        }
        return affectedPaths;
    }

    @Exported
    public Collection<Path> getPaths() {
        return this.paths;
    }

    public Collection<Path> getAffectedFiles() {
        return this.paths;
    }

    @Deprecated
    public User findOrCreateUser(String csAuthor, String csAuthorEmail, boolean createAccountBasedOnEmail) {
        return this.findOrCreateUser(csAuthor, csAuthorEmail, createAccountBasedOnEmail, false);
    }

    private User getUser(String idOrFullName, Boolean create) {
        try {
            return User.get((String)idOrFullName, (boolean)create, Collections.emptyMap());
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof AuthenticationException) {
                throw (AuthenticationException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    public User findOrCreateUser(String csAuthor, String csAuthorEmail, boolean createAccountBasedOnEmail, boolean useExistingAccountWithSameEmail) {
        if (csAuthor == null) {
            return User.getUnknown();
        }
        if (createAccountBasedOnEmail) {
            if (csAuthorEmail == null || csAuthorEmail.isEmpty()) {
                return User.getUnknown();
            }
            try {
                user = this.getUser(csAuthorEmail, false);
            }
            catch (AuthenticationException authException) {
                return User.getUnknown();
            }
            if (user == null) {
                try {
                    user = this.getUser(csAuthorEmail, useExistingAccountWithSameEmail == false);
                    setUserDetails = true;
                    if (user == null && useExistingAccountWithSameEmail && this.hasMailerPlugin()) {
                        for (User existingUser : User.getAll()) {
                            if (!csAuthorEmail.equalsIgnoreCase(this.getMail(existingUser))) continue;
                            user = existingUser;
                            setUserDetails = false;
                            break;
                        }
                    }
                    if (user == null) {
                        user = this.getUser(csAuthorEmail, true);
                    }
                    if (user == null || !setUserDetails) ** GOTO lbl51
                    user.setFullName(csAuthor);
                    if (this.hasMailerPlugin()) {
                        this.setMail(user, csAuthorEmail);
                    }
                    user.save();
                }
                catch (AuthenticationException authException) {
                    return User.getUnknown();
                }
                catch (IOException authException) {}
            }
        } else {
            if (csAuthor.isEmpty()) {
                return User.getUnknown();
            }
            try {
                user = this.getUser(csAuthor, false);
            }
            catch (AuthenticationException authException) {
                return User.getUnknown();
            }
            if (user == null) {
                if (csAuthorEmail == null || csAuthorEmail.isEmpty()) {
                    return User.getUnknown();
                }
                emailParts = csAuthorEmail.split("@");
                if (emailParts.length > 0) {
                    try {
                        user = this.getUser(emailParts[0], true);
                    }
                    catch (AuthenticationException authException) {
                        return User.getUnknown();
                    }
                } else {
                    return User.getUnknown();
                }
            }
        }
lbl51:
        // 6 sources

        if (Util.fixEmpty((String)csAuthorEmail) != null && this.hasMailerPlugin() && !this.hasMail(user)) {
            try {
                this.setMail(user, csAuthorEmail);
            }
            catch (IOException var6_12) {
                // empty catch block
            }
        }
        return user;
    }

    private String getMail(User user) {
        Mailer.UserProperty property = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        if (property == null) {
            return null;
        }
        if (!property.hasExplicitlyConfiguredAddress()) {
            return null;
        }
        return property.getExplicitlyConfiguredAddress();
    }

    private void setMail(User user, String csAuthorEmail) throws IOException {
        user.addProperty((UserProperty)new Mailer.UserProperty(csAuthorEmail));
    }

    private boolean hasMail(User user) {
        String email = this.getMail(user);
        return email != null;
    }

    private boolean hasMailerPlugin() {
        Plugin p = Jenkins.get().getPlugin("mailer");
        if (p != null) {
            return p.getWrapper().isActive();
        }
        return false;
    }

    private boolean isCreateAccountBasedOnEmail() {
        GitSCM.DescriptorImpl descriptor = this.getGitSCMDescriptor();
        return descriptor.isCreateAccountBasedOnEmail();
    }

    private boolean isUseExistingAccountWithSameEmail() {
        GitSCM.DescriptorImpl descriptor = this.getGitSCMDescriptor();
        if (descriptor == null) {
            return false;
        }
        return descriptor.isUseExistingAccountWithSameEmail();
    }

    private GitSCM.DescriptorImpl getGitSCMDescriptor() {
        return (GitSCM.DescriptorImpl)Jenkins.get().getDescriptor(GitSCM.class);
    }

    @Exported
    public User getAuthor() {
        String csAuthorEmail;
        String csAuthor;
        if (this.authorOrCommitter) {
            csAuthor = this.author;
            csAuthorEmail = this.authorEmail;
        } else {
            csAuthor = this.committer;
            csAuthorEmail = this.committerEmail;
        }
        return this.findOrCreateUser(csAuthor, csAuthorEmail, this.isCreateAccountBasedOnEmail(), this.isUseExistingAccountWithSameEmail());
    }

    public String getAuthorName() {
        String csAuthor = this.authorOrCommitter ? this.author : this.committer;
        return csAuthor;
    }

    @Exported
    public String getMsg() {
        return this.title;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    public String getRevision() {
        return this.id;
    }

    @Exported
    public String getComment() {
        return this.comment;
    }

    public String getCommentAnnotated() {
        MarkupText markup = new MarkupText(this.getComment());
        for (ChangeLogAnnotator a : ChangeLogAnnotator.all()) {
            a.annotate(this.getParent().getRun(), (ChangeLogSet.Entry)this, markup);
        }
        return markup.toString(false);
    }

    public String getBranch() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GitChangeSet that = (GitChangeSet)((Object)o);
        return this.id != null && this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    @ExportedBean(defaultVisibility=999)
    public static class Path
    implements ChangeLogSet.AffectedFile {
        private String src;
        private String dst;
        private char action;
        private String path;
        private GitChangeSet changeSet;

        private Path(String source, String destination, char action, String filePath, GitChangeSet changeSet) {
            this.src = source;
            this.dst = destination;
            this.action = action;
            this.path = filePath;
            this.changeSet = changeSet;
        }

        public String getSrc() {
            return this.src;
        }

        public String getDst() {
            return this.dst;
        }

        @Exported(name="file")
        public String getPath() {
            return this.path;
        }

        public GitChangeSet getChangeSet() {
            return this.changeSet;
        }

        @Exported
        public EditType getEditType() {
            switch (this.action) {
                case 'A': {
                    return EditType.ADD;
                }
                case 'D': {
                    return EditType.DELETE;
                }
            }
            return EditType.EDIT;
        }
    }
}

