/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.extensions.impl.CheckoutOption;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.plugins.git.extensions.impl.UserIdentity;
import io.jenkins.plugins.casc.misc.RoundTripAbstractTest;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.traits.AuthorInChangelogTrait;
import jenkins.plugins.git.traits.CheckoutOptionTrait;
import jenkins.plugins.git.traits.CleanAfterCheckoutTrait;
import jenkins.plugins.git.traits.CleanBeforeCheckoutTrait;
import jenkins.plugins.git.traits.CloneOptionTrait;
import jenkins.plugins.git.traits.DiscoverOtherRefsTrait;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitLFSPullTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.LocalBranchTrait;
import jenkins.plugins.git.traits.PruneStaleBranchTrait;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.plugins.git.traits.SubmoduleOptionTrait;
import jenkins.plugins.git.traits.UserIdentityTrait;
import jenkins.plugins.git.traits.WipeWorkspaceTrait;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.trait.RegexSCMHeadFilterTrait;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.jenkinsci.plugins.workflow.libs.GlobalLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMSourceRetriever;
import org.junit.Assert;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public class GlobalLibraryWithModernJCasCCompatibilityTest
extends RoundTripAbstractTest {
    protected void assertConfiguredAsExpected(RestartableJenkinsRule restartableJenkinsRule, String s) {
        LibraryConfiguration library = (LibraryConfiguration)GlobalLibraries.get().getLibraries().get(0);
        Assert.assertEquals((Object)"My Git Lib", (Object)library.getName());
        Assert.assertEquals((Object)"1.2.3", (Object)library.getDefaultVersion());
        Assert.assertTrue((boolean)library.isImplicit());
        LibraryRetriever retriever = library.getRetriever();
        MatcherAssert.assertThat((Object)retriever, (Matcher)IsInstanceOf.instanceOf(SCMSourceRetriever.class));
        SCMSource scm = ((SCMSourceRetriever)retriever).getScm();
        MatcherAssert.assertThat((Object)scm, (Matcher)IsInstanceOf.instanceOf(GitSCMSource.class));
        GitSCMSource gitSCMSource = (GitSCMSource)scm;
        Assert.assertEquals((Object)"acmeuser-cred-Id", (Object)gitSCMSource.getCredentialsId());
        Assert.assertEquals((Object)"https://git.acmecorp/myGitLib.git", (Object)gitSCMSource.getRemote());
        MatcherAssert.assertThat((Object)gitSCMSource.getTraits(), (Matcher)IsCollectionWithSize.hasSize((int)20));
        MatcherAssert.assertThat((Object)gitSCMSource.getTraits(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{new SimpleNameMatcher("BranchDiscoveryTrait")}), AllOf.allOf((Matcher[])new Matcher[]{new SimpleNameMatcher("TagDiscoveryTrait")}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LocalBranchTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CleanAfterCheckoutTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CleanBeforeCheckoutTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitLFSPullTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(IgnoreOnPushNotificationTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(PruneStaleBranchTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(AuthorInChangelogTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(WipeWorkspaceTrait.class)}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(DiscoverOtherRefsTrait.class), HasPropertyWithValue.hasProperty((String)"nameMapping", (Matcher)IsEqual.equalTo((Object)"mapping")), HasPropertyWithValue.hasProperty((String)"ref", (Matcher)IsEqual.equalTo((Object)"other/refs"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(RegexSCMHeadFilterTrait.class), HasPropertyWithValue.hasProperty((String)"regex", (Matcher)IsEqual.equalTo((Object)".*acme*"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(WildcardSCMHeadFilterTrait.class), HasPropertyWithValue.hasProperty((String)"excludes", (Matcher)IsEqual.equalTo((Object)"excluded")), HasPropertyWithValue.hasProperty((String)"includes", (Matcher)IsEqual.equalTo((Object)"master"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(RemoteNameSCMSourceTrait.class), HasPropertyWithValue.hasProperty((String)"remoteName", (Matcher)IsEqual.equalTo((Object)"other_remote"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CheckoutOptionTrait.class), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)IsInstanceOf.instanceOf(CheckoutOption.class)), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"timeout", (Matcher)IsEqual.equalTo((Object)1)))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CloneOptionTrait.class), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)IsInstanceOf.instanceOf(CloneOption.class)), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"depth", (Matcher)IsEqual.equalTo((Object)2))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"honorRefspec", (Matcher)IsEqual.equalTo((Object)true))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"noTags", (Matcher)IsEqual.equalTo((Object)false))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"reference", (Matcher)IsEqual.equalTo((Object)"/my/path/2"))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"shallow", (Matcher)IsEqual.equalTo((Object)true))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"timeout", (Matcher)IsEqual.equalTo((Object)2)))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(SubmoduleOptionTrait.class), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)IsInstanceOf.instanceOf(SubmoduleOption.class)), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"disableSubmodules", (Matcher)IsEqual.equalTo((Object)true))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"parentCredentials", (Matcher)IsEqual.equalTo((Object)true))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"recursiveSubmodules", (Matcher)IsEqual.equalTo((Object)true))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"reference", (Matcher)IsEqual.equalTo((Object)"/my/path/3"))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"timeout", (Matcher)IsEqual.equalTo((Object)3))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"trackingSubmodules", (Matcher)IsEqual.equalTo((Object)true)))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(GitBrowserSCMSourceTrait.class), HasPropertyWithValue.hasProperty((String)"browser", (Matcher)IsInstanceOf.instanceOf(BitbucketWeb.class)), HasPropertyWithValue.hasProperty((String)"browser", (Matcher)HasPropertyWithValue.hasProperty((String)"repoUrl", (Matcher)IsEqual.equalTo((Object)"bitbucketweb.url")))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(UserIdentityTrait.class), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)IsInstanceOf.instanceOf(UserIdentity.class)), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"name", (Matcher)IsEqual.equalTo((Object)"my_user"))), HasPropertyWithValue.hasProperty((String)"extension", (Matcher)HasPropertyWithValue.hasProperty((String)"email", (Matcher)IsEqual.equalTo((Object)"my@email.com")))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(RefSpecsSCMSourceTrait.class), HasPropertyWithValue.hasProperty((String)"templates", (Matcher)IsCollectionWithSize.hasSize((int)1)), HasPropertyWithValue.hasProperty((String)"templates", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(RefSpecsSCMSourceTrait.RefSpecTemplate.class), HasPropertyWithValue.hasProperty((String)"value", (Matcher)IsEqual.equalTo((Object)"+refs/heads/*:refs/remotes/@{remote}/*"))})}))})}));
    }

    protected String stringInLogExpected() {
        return "Setting class jenkins.plugins.git.traits.UserIdentityTrait.extension = {}";
    }

    protected String configResource() {
        return "global-with-modern-casc.yaml";
    }

    private static final class SimpleNameMatcher
    extends DiagnosingMatcher<Object> {
        private final String expectedSimpleName;

        public SimpleNameMatcher(String expectedSimpleName) {
            this.expectedSimpleName = expectedSimpleName;
        }

        protected boolean matches(Object item, Description mismatch) {
            if (item == null) {
                mismatch.appendText("null");
                return false;
            }
            if (!item.getClass().getSimpleName().equals(this.expectedSimpleName)) {
                mismatch.appendValue(item).appendText(" is a " + item.getClass().getName());
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("an instance of ").appendText(this.expectedSimpleName);
        }
    }
}

