/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.EnvVars;
import hudson.Functions;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.PruneStaleTag;
import hudson.util.LogTaskListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.TestCliGitAPIImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class PruneStaleTagTest {
    @Rule
    public TemporaryFolder fileRule = new TemporaryFolder();
    private TaskListener listener;
    private Run<?, ?> run;

    @Before
    public void setup() throws Exception {
        this.listener = new LogTaskListener(Logger.getLogger("prune tags"), Level.FINEST);
        this.run = (Run)Mockito.mock(Run.class);
        Mockito.when((Object)this.run.getEnvironment(this.listener)).thenReturn((Object)new EnvVars());
    }

    @Test
    public void verify_local_tag_is_pruned_if_different_than_on_remote() throws Exception {
        File remoteRepo = this.fileRule.newFolder("remote");
        GitClient remoteClient = this.initRepository(remoteRepo);
        String tagName = "tag";
        String tagComment = "tag comment";
        remoteClient.tag(tagName, tagComment);
        GitClient localClient = this.cloneRepository(remoteRepo);
        localClient.config(GitClient.ConfigLevel.LOCAL, "commit.gpgsign", "false");
        localClient.config(GitClient.ConfigLevel.LOCAL, "tag.gpgSign", "false");
        GitSCM scm = new GitSCM(localClient.getRemoteUrl("origin"));
        PruneStaleTag extension = new PruneStaleTag(true);
        String remoteTagHash = remoteClient.getTags().stream().filter(t -> tagName.equals(t.getName())).findFirst().get().getSHA1String();
        FileUtils.touch((File)new File(localClient.getWorkTree().getRemote(), "localTest"));
        localClient.add("localTest");
        localClient.commit("more commits");
        localClient.deleteTag(tagName);
        localClient.tag(tagName, tagComment);
        String localHashTag = localClient.getTags().stream().filter(t -> tagName.equals(t.getName())).findFirst().get().getSHA1String();
        Assert.assertNotEquals((String)"pre validation failed, local tag must not be the same than remote", (Object)remoteTagHash, (Object)localHashTag);
        extension.decorateFetchCommand(scm, this.run, localClient, this.listener, null);
        Assert.assertFalse((String)"local tag differ from remote tag and is not pruned", (boolean)localClient.tagExists(tagName));
    }

    @Test
    public void verify_do_nothing_when_remote_tag_do_not_exist_locally() throws Exception {
        File remoteRepo = this.fileRule.newFolder("remote");
        GitClient remoteClient = this.initRepository(remoteRepo);
        GitClient localClient = this.cloneRepository(remoteRepo);
        GitSCM scm = new GitSCM(localClient.getRemoteUrl("origin"));
        PruneStaleTag extension = new PruneStaleTag(true);
        String tagName = "tag";
        String tagComment = "tag comment";
        remoteClient.tag(tagName, tagComment);
        extension.decorateFetchCommand(scm, this.run, localClient, this.listener, null);
        Assert.assertFalse((String)"new tags should not be fetched", (boolean)localClient.tagExists(tagName));
    }

    @Test
    public void verify_that_local_tag_is_not_pruned_when_exist_on_remote() throws Exception {
        File remoteRepo = this.fileRule.newFolder("remote");
        GitClient remoteClient = this.initRepository(remoteRepo);
        String tagName = "tag";
        String tagComment = "tag comment";
        remoteClient.tag(tagName, tagComment);
        GitClient localClient = this.cloneRepository(remoteRepo);
        GitSCM scm = new GitSCM(localClient.getRemoteUrl("origin"));
        PruneStaleTag extension = new PruneStaleTag(true);
        extension.decorateFetchCommand(scm, this.run, localClient, this.listener, null);
        Assert.assertTrue((String)"local tags must not be pruned when exists on remote", (boolean)localClient.tagExists(tagName));
    }

    @Test
    public void verify_that_local_tag_is_pruned_when_not_exist_on_remote() throws Exception {
        File remoteRepo = this.fileRule.newFolder("remote");
        GitClient remoteClient = this.initRepository(remoteRepo);
        String tagName = "tag";
        String tagComment = "tag comment";
        remoteClient.tag(tagName, tagComment);
        GitClient localClient = this.cloneRepository(remoteRepo);
        GitSCM scm = new GitSCM(localClient.getRemoteUrl("origin"));
        PruneStaleTag extension = new PruneStaleTag(true);
        remoteClient.deleteTag(tagName);
        extension.decorateFetchCommand(scm, this.run, localClient, this.listener, null);
        Assert.assertFalse((String)"local tag has not been pruned", (boolean)localClient.tagExists(tagName));
    }

    @Test
    public void verify_fetch_do_not_prune_local_branches() throws Exception {
        File remoteRepo = this.fileRule.newFolder("remote");
        this.initRepository(remoteRepo);
        GitClient localClient = this.cloneRepository(remoteRepo);
        String branchName = "localBranch";
        localClient.branch(branchName);
        String gitURL = remoteRepo.toURI().toString();
        GitSCM scm = new GitSCM(gitURL);
        PruneStaleTag extension = new PruneStaleTag(true);
        extension.decorateFetchCommand(scm, this.run, localClient, this.listener, null);
        Assert.assertTrue((String)"Local branches must not be pruned", (boolean)localClient.getBranches().stream().anyMatch(b -> branchName.equals(b.getName())));
    }

    private GitClient newGitClient(File localRepo) {
        String gitExe = Functions.isWindows() ? "git.exe" : "git";
        TestCliGitAPIImpl localClient = new TestCliGitAPIImpl(gitExe, localRepo, this.listener, new EnvVars());
        return localClient;
    }

    private GitClient cloneRepository(File remoteRepository) throws Exception {
        File localRepo = this.fileRule.newFolder("local");
        GitClient localClient = this.newGitClient(localRepo);
        String gitURL = "file://" + remoteRepository.toURI().getPath();
        localClient.clone(gitURL, "origin", false, "+refs/heads/*:refs/remotes/origin/*");
        localClient.checkoutBranch("master", "refs/remotes/origin/master");
        return localClient;
    }

    private GitClient initRepository(File workspace) throws Exception {
        GitClient remoteClient = this.newGitClient(workspace);
        remoteClient.init();
        remoteClient.config(GitClient.ConfigLevel.LOCAL, "commit.gpgsign", "false");
        remoteClient.config(GitClient.ConfigLevel.LOCAL, "tag.gpgSign", "false");
        FileUtils.touch((File)new File(workspace, "test"));
        remoteClient.add("test");
        remoteClient.commit("initial commit");
        return remoteClient;
    }

    @Test
    public void testGetPruneTags() {
        PruneStaleTag pruneEnabled = new PruneStaleTag(true);
        MatcherAssert.assertThat((Object)pruneEnabled.getPruneTags(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetPruneTagsDisabled() {
        PruneStaleTag pruneEnabled = new PruneStaleTag(false);
        MatcherAssert.assertThat((Object)pruneEnabled.getPruneTags(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(PruneStaleTag.class).usingGetClass().verify();
    }

    @Test
    public void testHashCode() {
        PruneStaleTag enabledOne = new PruneStaleTag(true);
        PruneStaleTag enabledTwo = new PruneStaleTag(true);
        MatcherAssert.assertThat((Object)enabledOne.equals((Object)enabledTwo), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)enabledTwo.equals((Object)enabledOne), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)enabledOne.hashCode(), (Matcher)Matchers.is((Object)enabledTwo.hashCode()));
        PruneStaleTag disabledOne = new PruneStaleTag(false);
        PruneStaleTag disabledTwo = new PruneStaleTag(false);
        MatcherAssert.assertThat((Object)disabledOne.equals((Object)disabledTwo), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)disabledTwo.equals((Object)disabledOne), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)disabledOne.hashCode(), (Matcher)Matchers.is((Object)disabledTwo.hashCode()));
        MatcherAssert.assertThat((Object)enabledOne.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)disabledOne.hashCode())));
    }

    @Test
    public void testToString() {
        PruneStaleTag enabled = new PruneStaleTag(true);
        MatcherAssert.assertThat((Object)enabled.toString(), (Matcher)Matchers.is((Object)"PruneStaleTag { true }"));
    }

    @Test
    public void testToStringDisabled() {
        PruneStaleTag disabled = new PruneStaleTag(false);
        MatcherAssert.assertThat((Object)disabled.toString(), (Matcher)Matchers.is((Object)"PruneStaleTag { false }"));
    }
}

