/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionTest;
import hudson.plugins.git.extensions.impl.CloneOption;
import java.util.Set;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;

public class CloneOptionNoTagsTest
extends GitSCMExtensionTest {
    FreeStyleProject project;
    TestGitRepo repo;

    @Override
    public void before() throws Exception {
        this.repo = new TestGitRepo("repo", this.tmp.newFolder(), this.listener);
        this.project = this.setupBasicProject(this.repo);
    }

    @Override
    protected GitSCMExtension getExtension() {
        boolean shallowClone = true;
        boolean dontFetchTags = true;
        String noReference = null;
        Integer noTimeout = null;
        return new CloneOption(true, true, noReference, noTimeout);
    }

    @Test
    public void cloningShouldNotFetchTags() throws Exception {
        this.repo.commit("repo-init", this.repo.johnDoe, "repo0 initial commit");
        this.repo.tag("v0.0.1", "a tag that should never be fetched");
        Assert.assertTrue((String)"scm polling should detect a change after initial commit", (boolean)this.project.poll(this.listener).hasChanges());
        this.build(this.project, Result.SUCCESS);
        Assert.assertTrue((String)"there should no tags have been cloned from remote", (boolean)this.allTagsInProjectWorkspace().isEmpty());
    }

    @Test
    public void detectNoChangeAfterCreatingATag() throws Exception {
        this.repo.commit("repo-init", this.repo.johnDoe, "repo0 initial commit");
        Assert.assertTrue((String)"scm polling should detect a change after initial commit", (boolean)this.project.poll(this.listener).hasChanges());
        this.build(this.project, Result.SUCCESS);
        this.repo.tag("v0.0.1", "a tag that should never be fetched");
        Assert.assertFalse((String)"scm polling should not detect a change after creating a tag", (boolean)this.project.poll(this.listener).hasChanges());
        this.build(this.project, Result.SUCCESS);
        Assert.assertTrue((String)"there should no tags have been fetched from remote", (boolean)this.allTagsInProjectWorkspace().isEmpty());
    }

    private Set<String> allTagsInProjectWorkspace() throws Exception {
        GitClient git = Git.with((TaskListener)this.listener, null).in(this.project.getSomeWorkspace()).getClient();
        return git.getTagNames("*");
    }
}

