/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.github.sparsick.testcontainers.gitserver.GitServerVersions;
import com.github.sparsick.testcontainers.gitserver.http.GitHttpServerContainer;
import com.github.sparsick.testcontainers.gitserver.plain.GitServerContainer;
import com.github.sparsick.testcontainers.gitserver.plain.SshIdentity;
import hudson.ExtensionList;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.Messages;
import hudson.plugins.git.UserRemoteConfig;
import hudson.util.FormValidation;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import jenkins.branch.MultiBranchProject;
import jenkins.plugins.git.GitSCMSource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.StoredConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.RealJenkinsRule;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;

public class FIPSModeUrlCheckTest {
    @Rule
    public RealJenkinsRule rule = new RealJenkinsRule().omitPlugins(new String[]{"eddsa-api", "trilead-api", "git-tag-message"}).javaOptions(new String[]{"-Djenkins.security.FIPS140.COMPLIANCE=true"});
    @Rule
    public TemporaryFolder directory = new TemporaryFolder();

    @Test
    public void testFIPSLtsMethod() throws Throwable {
        this.rule.then(new RealJenkinsRule.Step[]{(RealJenkinsRule.Step & Serializable)r -> {
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS(null, (String)"http://github.com/cheese/wine"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS((String)"beer", (String)"http://github.com/cheese/wine"), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS(null, (String)"https://github.com/cheese/wine"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS((String)"beer", (String)"https://github.com/cheese/wine"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS(null, (String)"git@github.com:cheese/wine.git"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS((String)"beer", (String)"git@github.com:cheese/wine.git"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS(null, (String)"git://github.com/cheese/wine"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)GitSCMSource.isFIPSCompliantTLS((String)"beer", (String)"git://github.com/cheese/wine"), (Matcher)Matchers.is((Object)false));
        }});
    }

    @Test
    public void testGitSCMSourceCheck() throws Throwable {
        this.rule.then(new RealJenkinsRule.Step[]{(RealJenkinsRule.Step & Serializable)r -> {
            SystemCredentialsProvider.getInstance().getCredentials().add(new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "mycreds", null, "jenkins", "s3cr3t-that-needs-to-be-long"));
            SystemCredentialsProvider.getInstance().save();
            MultiBranchProject mbp = (MultiBranchProject)r.createProject(WorkflowMultiBranchProject.class, "mbp");
            GitSCMSource.DescriptorImpl descriptor = (GitSCMSource.DescriptorImpl)ExtensionList.lookupSingleton(GitSCMSource.DescriptorImpl.class);
            FormValidation validation = descriptor.doCheckRemote((Item)mbp, "mycreds", "http://github.com/foo/beer");
            MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.ERROR));
            MatcherAssert.assertThat((Object)validation.getMessage(), (Matcher)Matchers.containsString((String)Messages.git_fips_url_notsecured()));
            validation = descriptor.doCheckRemote((Item)mbp, "mycreds", "https://github.com/foo/vegemite");
            MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.OK));
            validation = descriptor.doCheckRemote((Item)mbp, "mycreds", "git@github.com:foo/wine.git");
            MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.OK));
            validation = descriptor.doCheckRemote((Item)mbp, null, "http://github.com/foo/cheese");
            MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.OK));
        }});
    }

    @Test
    public void testUserRemoteConfigCheck() throws Throwable {
        Assume.assumeTrue((boolean)DockerClientFactory.instance().isDockerAvailable());
        try (GitServerContainer containerUnderTest = new GitServerContainer(GitServerVersions.V2_45.getDockerImageName()).withGitRepo("someRepo");){
            containerUnderTest.withClasspathResourceMapping("ssh-keys/id_rsa.pub", "/home/git/.ssh/authorized_keys", BindMode.READ_ONLY);
            containerUnderTest.withClasspathResourceMapping("sshd_config", "/etc/ssh/sshd_config", BindMode.READ_ONLY);
            containerUnderTest.start();
            SshIdentity sshClientIdentity = new SshIdentity(this.getClass().getClassLoader().getResourceAsStream("ssh-keys/id_rsa").readAllBytes(), this.getClass().getClassLoader().getResourceAsStream("ssh-keys/id_rsa.pub").readAllBytes(), new byte[0]);
            byte[] privateKey = sshClientIdentity.getPrivateKey();
            byte[] passphrase = sshClientIdentity.getPassphrase();
            String repoUrl = StringUtils.remove((String)containerUnderTest.getGitRepoURIAsSSH().toString(), (String)"git@");
            this.rule.then(new RealJenkinsRule.Step[]{(RealJenkinsRule.Step & Serializable)r -> {
                BasicSSHUserPrivateKey sshUserPrivateKey = FIPSModeUrlCheckTest.getBasicSSHUserPrivateKey(privateKey, passphrase);
                SystemCredentialsProvider.getInstance().getCredentials().add(sshUserPrivateKey);
                SystemCredentialsProvider.getInstance().getCredentials().add(new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, "mycreds", null, "jenkins", "s3cr3t-at-least-14-chars"));
                SystemCredentialsProvider.getInstance().save();
                FreeStyleProject p = (FreeStyleProject)r.createProject(FreeStyleProject.class, "mbp");
                UserRemoteConfig.DescriptorImpl descriptor = (UserRemoteConfig.DescriptorImpl)ExtensionList.lookupSingleton(UserRemoteConfig.DescriptorImpl.class);
                FormValidation validation = descriptor.doCheckUrl((Item)p, "mycreds", "http://github.com/olamy/beer");
                MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.ERROR));
                MatcherAssert.assertThat((Object)validation.getMessage(), (Matcher)Matchers.containsString((String)Messages.git_fips_url_notsecured()));
                validation = descriptor.doCheckUrl((Item)p, null, "https://github.com/jenkinsci/git-plugin");
                MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.OK));
                Assume.assumeTrue((boolean)DockerClientFactory.instance().isDockerAvailable());
                validation = descriptor.doCheckUrl((Item)p, sshUserPrivateKey.getId(), repoUrl);
                MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.OK));
            }});
        }
        containerUnderTest = new GitHttpServerContainer(GitServerVersions.V2_45.getDockerImageName());
        try {
            containerUnderTest.start();
            String repoUri = containerUnderTest.getGitRepoURIAsHttp().toString();
            this.rule.then(new RealJenkinsRule.Step[]{(RealJenkinsRule.Step & Serializable)r -> {
                FreeStyleProject p = (FreeStyleProject)r.createProject(FreeStyleProject.class, "mbp2");
                UserRemoteConfig.DescriptorImpl descriptor = (UserRemoteConfig.DescriptorImpl)ExtensionList.lookupSingleton(UserRemoteConfig.DescriptorImpl.class);
                FormValidation validation = descriptor.doCheckUrl((Item)p, null, repoUri);
                MatcherAssert.assertThat((Object)validation.kind, (Matcher)Matchers.is((Object)FormValidation.Kind.OK));
            }});
        }
        finally {
            containerUnderTest.close();
        }
    }

    private static BasicSSHUserPrivateKey getBasicSSHUserPrivateKey(final byte[] privateKey, byte[] passphrase) {
        BasicSSHUserPrivateKey.PrivateKeySource privateKeySource = new BasicSSHUserPrivateKey.PrivateKeySource(){

            @NotNull
            public List<String> getPrivateKeys() {
                return List.of(new String(privateKey));
            }
        };
        return new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, "some-id", "git", privateKeySource, new String(passphrase), "description");
    }

    @Test
    public void gitStepTLSCheck() throws Throwable {
        Assume.assumeTrue((boolean)DockerClientFactory.instance().isDockerAvailable());
        try (GitHttpServerContainer containerUnderTest = new GitHttpServerContainer(GitServerVersions.V2_45.getDockerImageName());){
            containerUnderTest.start();
            File tmp = this.directory.newFolder();
            Git git = Git.cloneRepository().setURI(containerUnderTest.getGitRepoURIAsHttp().toString()).setDirectory(tmp).call();
            StoredConfig storedConfig = git.getRepository().getConfig();
            storedConfig.setBoolean("commit", null, "gpgsign", false);
            storedConfig.setBoolean("tag", null, "gpgSign", false);
            storedConfig.save();
            Files.writeString(new File(tmp, "foo.txt").toPath(), (CharSequence)"nothing too see here", new OpenOption[0]);
            git.add().addFilepattern("foo.txt").call();
            git.commit().setMessage("add foo").call();
            git.push().call();
            String repoUri = containerUnderTest.getGitRepoURIAsHttp().toString();
            this.rule.then(new RealJenkinsRule.Step[]{(RealJenkinsRule.Step & Serializable)r -> {
                WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class, "some project");
                p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    dir('foo') {\n        git url: 'http://foo.com/beer.git', credentialsId: 'yup'\n    }\n}\n", true));
                WorkflowRun b = (WorkflowRun)r.buildAndAssertStatus(Result.FAILURE, (Job)p);
                r.assertLogContains(Messages.git_fips_url_notsecured(), (Run)b);
                p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    dir('foo') {\n        git url: '" + repoUri + "', changelog: false\n    }\n}", true));
                r.buildAndAssertStatus(Result.SUCCESS, (Job)p);
            }});
        }
    }

    @Test
    public void checkoutStepTLSCheck() throws Throwable {
        Assume.assumeTrue((boolean)DockerClientFactory.instance().isDockerAvailable());
        try (GitHttpServerContainer containerUnderTest = new GitHttpServerContainer(GitServerVersions.V2_45.getDockerImageName());){
            containerUnderTest.start();
            File tmp = this.directory.newFolder();
            Git git = Git.cloneRepository().setURI(containerUnderTest.getGitRepoURIAsHttp().toString()).setDirectory(tmp).call();
            StoredConfig storedConfig = git.getRepository().getConfig();
            storedConfig.setBoolean("commit", null, "gpgsign", false);
            storedConfig.setBoolean("tag", null, "gpgSign", false);
            storedConfig.save();
            Files.writeString(new File(tmp, "foo.txt").toPath(), (CharSequence)"nothing too see here", new OpenOption[0]);
            git.add().addFilepattern("foo.txt").call();
            git.commit().setMessage("add foo").call();
            git.push().call();
            String repoUri = containerUnderTest.getGitRepoURIAsHttp().toString();
            this.rule.then(new RealJenkinsRule.Step[]{(RealJenkinsRule.Step & Serializable)r -> {
                WorkflowJob p = (WorkflowJob)r.createProject(WorkflowJob.class, "some project");
                p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    dir('foo') {\n        checkout scmGit(branches: [[name: 'master']],\n                        userRemoteConfigs: [[credentialsId: 'foocreds', url: 'http://github.com/foo/beer.git']])\n    }\n}\n", true));
                WorkflowRun b = (WorkflowRun)r.buildAndAssertStatus(Result.FAILURE, (Job)p);
                r.assertLogContains(Messages.git_fips_url_notsecured(), (Run)b);
                p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    dir('foo') {\n        checkout([$class: 'GitSCM',\n                  branches: [[name: '*/master']],\n                  userRemoteConfigs: [[url: '" + repoUri + "']]])\n    }\n}", true));
                r.buildAndAssertStatus(Result.SUCCESS, (Job)p);
            }});
        }
    }
}

