/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.plugins.git.BranchSpec;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class BranchSpecTest {
    @Test
    public void testMatch() {
        BranchSpec l = new BranchSpec("master");
        Assert.assertTrue((boolean)l.matches("origin/master"));
        Assert.assertFalse((boolean)l.matches("origin/something/master"));
        Assert.assertTrue((boolean)l.matches("master"));
        Assert.assertFalse((boolean)l.matches("dev"));
        BranchSpec est = new BranchSpec("origin/*/dev");
        Assert.assertFalse((boolean)est.matches("origintestdev"));
        Assert.assertTrue((boolean)est.matches("origin/test/dev"));
        Assert.assertFalse((boolean)est.matches("origin/test/release"));
        Assert.assertFalse((boolean)est.matches("origin/test/something/release"));
        BranchSpec s = new BranchSpec("origin/*");
        Assert.assertTrue((boolean)s.matches("origin/master"));
        BranchSpec m = new BranchSpec("**/magnayn/*");
        Assert.assertTrue((boolean)m.matches("origin/magnayn/b1"));
        Assert.assertTrue((boolean)m.matches("remote/origin/magnayn/b1"));
        Assert.assertTrue((boolean)m.matches("remotes/origin/magnayn/b1"));
        BranchSpec n = new BranchSpec("*/my.branch/*");
        Assert.assertTrue((boolean)n.matches("origin/my.branch/b1"));
        Assert.assertFalse((boolean)n.matches("origin/my-branch/b1"));
        Assert.assertFalse((boolean)n.matches("remote/origin/my.branch/b1"));
        Assert.assertTrue((boolean)n.matches("remotes/origin/my.branch/b1"));
        BranchSpec o = new BranchSpec("**");
        Assert.assertTrue((boolean)o.matches("origin/my.branch/b1"));
        Assert.assertTrue((boolean)o.matches("origin/my-branch/b1"));
        Assert.assertTrue((boolean)o.matches("remote/origin/my.branch/b1"));
        Assert.assertTrue((boolean)o.matches("remotes/origin/my.branch/b1"));
        BranchSpec p = new BranchSpec("*");
        Assert.assertTrue((boolean)p.matches("origin/x"));
        Assert.assertFalse((boolean)p.matches("origin/my-branch/b1"));
    }

    @Test
    public void testMatchEnv() {
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("master", "master");
        envMap.put("origin", "origin");
        envMap.put("dev", "dev");
        envMap.put("magnayn", "magnayn");
        envMap.put("mybranch", "my.branch");
        envMap.put("anyLong", "**");
        envMap.put("anyShort", "*");
        envMap.put("anyEmpty", "");
        EnvVars env = new EnvVars(envMap);
        BranchSpec l = new BranchSpec("${master}");
        Assert.assertTrue((boolean)l.matches("origin/master", env));
        Assert.assertFalse((boolean)l.matches("origin/something/master", env));
        Assert.assertTrue((boolean)l.matches("master", env));
        Assert.assertFalse((boolean)l.matches("dev", env));
        BranchSpec est = new BranchSpec("${origin}/*/${dev}");
        Assert.assertFalse((boolean)est.matches("origintestdev", env));
        Assert.assertTrue((boolean)est.matches("origin/test/dev", env));
        Assert.assertFalse((boolean)est.matches("origin/test/release", env));
        Assert.assertFalse((boolean)est.matches("origin/test/something/release", env));
        BranchSpec s = new BranchSpec("${origin}/*");
        Assert.assertTrue((boolean)s.matches("origin/master", env));
        BranchSpec m = new BranchSpec("**/${magnayn}/*");
        Assert.assertTrue((boolean)m.matches("origin/magnayn/b1", env));
        Assert.assertTrue((boolean)m.matches("remote/origin/magnayn/b1", env));
        BranchSpec n = new BranchSpec("*/${mybranch}/*");
        Assert.assertTrue((boolean)n.matches("origin/my.branch/b1", env));
        Assert.assertFalse((boolean)n.matches("origin/my-branch/b1", env));
        Assert.assertFalse((boolean)n.matches("remote/origin/my.branch/b1", env));
        BranchSpec o = new BranchSpec("${anyLong}");
        Assert.assertTrue((boolean)o.matches("origin/my.branch/b1", env));
        Assert.assertTrue((boolean)o.matches("origin/my-branch/b1", env));
        Assert.assertTrue((boolean)o.matches("remote/origin/my.branch/b1", env));
        BranchSpec p = new BranchSpec("${anyShort}");
        Assert.assertTrue((boolean)p.matches("origin/x", env));
        Assert.assertFalse((boolean)p.matches("origin/my-branch/b1", env));
        BranchSpec q = new BranchSpec("${anyEmpty}");
        Assert.assertTrue((boolean)q.matches("origin/my.branch/b1", env));
        Assert.assertTrue((boolean)q.matches("origin/my-branch/b1", env));
        Assert.assertTrue((boolean)q.matches("remote/origin/my.branch/b1", env));
    }

    @Test
    public void testEmptyName() {
        BranchSpec branchSpec = new BranchSpec("");
        Assert.assertEquals((Object)"**", (Object)branchSpec.getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullName() {
        BranchSpec branchSpec = new BranchSpec(null);
    }

    @Test
    public void testNameTrimming() {
        BranchSpec branchSpec = new BranchSpec(" master ");
        Assert.assertEquals((Object)"master", (Object)branchSpec.getName());
        branchSpec.setName(" other ");
        Assert.assertEquals((Object)"other", (Object)branchSpec.getName());
    }

    @Test
    public void testUsesRefsHeads() {
        BranchSpec m = new BranchSpec("refs/heads/j*n*");
        Assert.assertTrue((boolean)m.matches("refs/heads/jenkins"));
        Assert.assertTrue((boolean)m.matches("refs/heads/jane"));
        Assert.assertTrue((boolean)m.matches("refs/heads/jones"));
        Assert.assertFalse((boolean)m.matches("origin/jenkins"));
        Assert.assertFalse((boolean)m.matches("remote/origin/jane"));
    }

    @Test
    public void testUsesJavaPatternDirectlyIfPrefixedWithColon() {
        BranchSpec m = new BranchSpec(":^(?!(origin/prefix)).*");
        Assert.assertTrue((boolean)m.matches("origin"));
        Assert.assertTrue((boolean)m.matches("origin/master"));
        Assert.assertTrue((boolean)m.matches("origin/feature"));
        Assert.assertFalse((boolean)m.matches("origin/prefix_123"));
        Assert.assertFalse((boolean)m.matches("origin/prefix"));
        Assert.assertFalse((boolean)m.matches("origin/prefix-abc"));
    }

    @Test
    public void testUsesJavaPatternWithRepetition() {
        BranchSpec m = new BranchSpec(":origin/release-\\d{8}");
        Assert.assertTrue((boolean)m.matches("origin/release-20150101"));
        Assert.assertFalse((boolean)m.matches("origin/release-2015010"));
        Assert.assertFalse((boolean)m.matches("origin/release-201501011"));
        Assert.assertFalse((boolean)m.matches("origin/release-20150101-something"));
    }

    @Test
    public void testUsesJavaPatternToExcludeMultipleBranches() {
        BranchSpec m = new BranchSpec(":^(?!origin/master$|origin/develop$).*");
        Assert.assertTrue((boolean)m.matches("origin/branch1"));
        Assert.assertTrue((boolean)m.matches("origin/branch-2"));
        Assert.assertTrue((boolean)m.matches("origin/master123"));
        Assert.assertTrue((boolean)m.matches("origin/develop-123"));
        Assert.assertFalse((boolean)m.matches("origin/master"));
        Assert.assertFalse((boolean)m.matches("origin/develop"));
    }

    private EnvVars createEnvMap(String key, String value) {
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put(key, value);
        return new EnvVars(envMap);
    }

    @Test
    public void testUsesEnvValueWithBraces() {
        EnvVars env = this.createEnvMap("GIT_BRANCH", "origin/master");
        BranchSpec withBraces = new BranchSpec("${GIT_BRANCH}");
        Assert.assertTrue((boolean)withBraces.matches("refs/heads/origin/master", env));
        Assert.assertTrue((boolean)withBraces.matches("origin/master", env));
        Assert.assertFalse((boolean)withBraces.matches("master", env));
    }

    @Test
    public void testUsesEnvValueWithoutBraces() {
        EnvVars env = this.createEnvMap("GIT_BRANCH", "origin/master");
        BranchSpec withoutBraces = new BranchSpec("$GIT_BRANCH");
        Assert.assertTrue((boolean)withoutBraces.matches("refs/heads/origin/master", env));
        Assert.assertTrue((boolean)withoutBraces.matches("origin/master", env));
        Assert.assertFalse((boolean)withoutBraces.matches("master", env));
    }

    @Test
    public void testUsesEnvValueWithToken() {
        EnvVars env = this.createEnvMap("GIT_BRANCH", "origin/master");
        BranchSpec withToken = new BranchSpec("${GIT_BRANCH,fullName=True}");
        Assert.assertFalse((boolean)withToken.matches("refs/heads/origin/master", env));
        Assert.assertFalse((boolean)withToken.matches("origin/master", env));
        Assert.assertFalse((boolean)withToken.matches("master", env));
    }

    @Test
    public void testUsesEnvValueWithTokenFalse() {
        EnvVars env = this.createEnvMap("GIT_BRANCH", "origin/master");
        BranchSpec withTokenFalse = new BranchSpec("${GIT_BRANCH,fullName=false}");
        Assert.assertFalse((boolean)withTokenFalse.matches("refs/heads/origin/master", env));
        Assert.assertFalse((boolean)withTokenFalse.matches("origin/master", env));
        Assert.assertFalse((boolean)withTokenFalse.matches("master", env));
    }
}

