/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.util.MergeRecord;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.MergeCommand;

public class MergeWithGitSCMExtension
extends GitSCMExtension {
    @NonNull
    private final String baseName;
    @CheckForNull
    private final String baseHash;

    public MergeWithGitSCMExtension(@NonNull String baseName, @CheckForNull String baseHash) {
        this.baseName = baseName;
        this.baseHash = baseHash;
    }

    @NonNull
    public String getBaseName() {
        return this.baseName;
    }

    public String getBaseHash() {
        return this.baseHash;
    }

    @Override
    public void decorateCloneCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        cmd.shallow(false);
    }

    @Override
    public void decorateFetchCommand(GitSCM scm, GitClient git, TaskListener listener, FetchCommand cmd) throws IOException, InterruptedException, GitException {
        cmd.shallow(false);
    }

    @Override
    public Revision decorateRevisionToBuild(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, Revision marked, Revision rev) throws IOException, InterruptedException, GitException {
        ObjectId baseObjectId;
        if (StringUtils.isBlank((String)this.baseHash)) {
            try {
                baseObjectId = git.revParse("refs/" + this.baseName);
            }
            catch (GitException e) {
                listener.getLogger().printf("Unable to determine head revision of %s prior to merge with PR%n", this.baseName);
                throw e;
            }
        } else {
            baseObjectId = ObjectId.fromString((String)this.baseHash);
        }
        listener.getLogger().printf("Merging %s commit %s into PR head commit %s%n", this.baseName, baseObjectId.name(), rev.getSha1String());
        this.checkout(scm, build, git, listener, rev);
        try {
            git.setAuthor("Jenkins", "nobody@nowhere");
            git.setCommitter("Jenkins", "nobody@nowhere");
            MergeCommand cmd = git.merge().setRevisionToMerge(baseObjectId);
            for (GitSCMExtension ext : scm.getExtensions()) {
                ext.decorateMergeCommand(scm, build, git, listener, cmd);
            }
            cmd.execute();
        }
        catch (GitException x) {
            this.checkout(scm, build, git, listener, rev);
            throw x;
        }
        build.addAction((Action)new MergeRecord(this.baseName, baseObjectId.getName()));
        ObjectId mergeRev = git.revParse("HEAD");
        listener.getLogger().println("Merge succeeded, producing " + mergeRev.name());
        return new Revision(mergeRev, rev.getBranches());
    }

    private void checkout(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, Revision rev) throws InterruptedException, IOException, GitException {
        CheckoutCommand checkoutCommand = git.checkout().ref(rev.getSha1String());
        for (GitSCMExtension ext : scm.getExtensions()) {
            ext.decorateCheckoutCommand(scm, build, git, listener, checkoutCommand);
        }
        checkoutCommand.execute();
    }
}

