/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.TagSCMHead;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.gitclient.GitClient;

public abstract class GitSCMTelescope
extends SCMFileSystem.Builder {
    @CheckForNull
    public static GitSCMTelescope of(@NonNull GitSCM source) {
        for (SCMFileSystem.Builder b : ExtensionList.lookup(SCMFileSystem.Builder.class)) {
            if (b instanceof GitSCMTelescope && b.supports((SCM)source)) {
                return (GitSCMTelescope)b;
            }
            if (!(b instanceof GitSCMFileSystem.BuilderImpl)) continue;
            break;
        }
        return null;
    }

    @CheckForNull
    public static GitSCMTelescope of(@NonNull AbstractGitSCMSource source) {
        for (SCMFileSystem.Builder b : ExtensionList.lookup(SCMFileSystem.Builder.class)) {
            if (b instanceof GitSCMTelescope && b.supports((SCMSource)source)) {
                return (GitSCMTelescope)b;
            }
            if (!GitSCMFileSystem.BuilderImpl.class.equals(b.getClass())) continue;
            break;
        }
        return null;
    }

    public abstract boolean supports(@NonNull String var1);

    public abstract void validate(@NonNull String var1, @CheckForNull StandardCredentials var2) throws IOException, InterruptedException;

    public final boolean supports(@NonNull SCM source) {
        if (source instanceof GitSCM) {
            GitSCM git = (GitSCM)source;
            List<UserRemoteConfig> configs = git.getUserRemoteConfigs();
            List<BranchSpec> branches = git.getBranches();
            return configs.size() == 1 && this.supports(configs.get(0).getUrl()) && branches.size() == 1 && !branches.get(0).getName().contains("*");
        }
        return false;
    }

    public final boolean supports(@NonNull SCMSource source) {
        return source instanceof AbstractGitSCMSource && source.getOwner() != null && this.supports(((AbstractGitSCMSource)source).getRemote());
    }

    public final SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        SCMSourceOwner owner = source.getOwner();
        if (source instanceof AbstractGitSCMSource && owner != null && this.supports(((AbstractGitSCMSource)source).getRemote())) {
            AbstractGitSCMSource git = (AbstractGitSCMSource)source;
            String remote = git.getRemote();
            StandardUsernameCredentials credentials = git.getCredentials();
            this.validate(remote, (StandardCredentials)credentials);
            return this.build(remote, (StandardCredentials)credentials, head, rev);
        }
        return null;
    }

    public final SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, SCMRevision rev) throws IOException, InterruptedException {
        if (scm instanceof GitSCM) {
            GitSCM git = (GitSCM)scm;
            List<UserRemoteConfig> configs = git.getUserRemoteConfigs();
            List<BranchSpec> branches = git.getBranches();
            if (configs.size() == 1 && this.supports(configs.get(0).getUrl()) && branches.size() == 1 && !branches.get(0).getName().contains("*")) {
                String name;
                StandardCredentials credentials;
                UserRemoteConfig config = configs.get(0);
                String credentialsId = config.getCredentialsId();
                String remote = config.getUrl();
                if (credentialsId != null) {
                    List urlCredentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)owner, (Authentication)(owner instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)owner)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)remote).build());
                    credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)urlCredentials, (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), GitClient.CREDENTIALS_MATCHER}));
                } else {
                    credentials = null;
                }
                this.validate(remote, credentials);
                SCMHead head = rev == null ? ((name = branches.get(0).getName()).startsWith("refs/tags/") ? new GitTagSCMHead(name.substring("refs/tags/".length()), this.getTimestamp(remote, credentials, name)) : (name.startsWith("refs/heads/") ? new GitBranchSCMHead(name.substring("refs/heads/".length())) : (name.startsWith(config.getName() + "/") ? new GitBranchSCMHead(name.substring(config.getName().length() + 1)) : new GitBranchSCMHead(name)))) : rev.getHead();
                return this.build(remote, credentials, head, rev);
            }
        }
        return null;
    }

    @CheckForNull
    protected abstract SCMFileSystem build(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull SCMHead var3, @CheckForNull SCMRevision var4) throws IOException, InterruptedException;

    public abstract long getTimestamp(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull String var3) throws IOException, InterruptedException;

    @CheckForNull
    public abstract SCMRevision getRevision(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull String var3) throws IOException, InterruptedException;

    public long getTimestamp(@NonNull String remote, @CheckForNull StandardCredentials credentials, @NonNull SCMHead head) throws IOException, InterruptedException {
        if (head instanceof TagSCMHead) {
            return this.getTimestamp(remote, credentials, "refs/tags/" + head.getName());
        }
        return this.getTimestamp(remote, credentials, "refs/heads/" + head.getName());
    }

    @CheckForNull
    public SCMRevision getRevision(@NonNull String remote, @CheckForNull StandardCredentials credentials, @NonNull SCMHead head) throws IOException, InterruptedException {
        if (head instanceof TagSCMHead) {
            return this.getRevision(remote, credentials, "refs/tags/" + head.getName());
        }
        return this.getRevision(remote, credentials, "refs/heads/" + head.getName());
    }

    public final Iterable<SCMRevision> getRevisions(@NonNull String remote, @CheckForNull StandardCredentials credentials) throws IOException, InterruptedException {
        return this.getRevisions(remote, credentials, EnumSet.allOf(ReferenceType.class));
    }

    public abstract Iterable<SCMRevision> getRevisions(@NonNull String var1, @CheckForNull StandardCredentials var2, @NonNull Set<ReferenceType> var3) throws IOException, InterruptedException;

    public abstract String getDefaultTarget(@NonNull String var1, @CheckForNull StandardCredentials var2) throws IOException, InterruptedException;

    public static enum ReferenceType {
        HEAD,
        TAG;

    }
}

