/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.GitUtils;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CloneOption
extends GitSCMExtension {
    private final boolean shallow;
    private final boolean noTags;
    private final String reference;
    private final Integer timeout;
    private Integer depth;
    private boolean honorRefspec = false;

    public CloneOption(boolean shallow, String reference, Integer timeout) {
        this(shallow, false, reference, timeout);
    }

    @DataBoundConstructor
    public CloneOption(boolean shallow, boolean noTags, String reference, Integer timeout) {
        this.shallow = shallow;
        this.noTags = noTags;
        this.reference = reference;
        this.timeout = timeout;
        this.honorRefspec = false;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public boolean isNoTags() {
        return this.noTags;
    }

    @DataBoundSetter
    public void setHonorRefspec(boolean honorRefspec) {
        this.honorRefspec = honorRefspec;
    }

    public boolean isHonorRefspec() {
        return this.honorRefspec;
    }

    public String getReference() {
        return this.reference;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public Integer getDepth() {
        return this.depth;
    }

    @Override
    public void decorateCloneCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        cmd.shallow(this.shallow);
        if (this.shallow) {
            int usedDepth = this.depth == null || this.depth < 1 ? 1 : this.depth;
            listener.getLogger().println("Using shallow clone with depth " + usedDepth);
            cmd.depth(Integer.valueOf(usedDepth));
        }
        if (this.noTags) {
            listener.getLogger().println("Avoid fetching tags");
            cmd.tags(false);
        }
        if (this.honorRefspec) {
            listener.getLogger().println("Honoring refspec on initial clone");
            RemoteConfig rc = scm.getRepositories().get(0);
            List refspecs = rc.getFetchRefSpecs();
            cmd.refspecs(refspecs);
        }
        cmd.timeout(this.timeout);
        Node node = GitUtils.workspaceToNode(git.getWorkTree());
        EnvVars env = build.getEnvironment(listener);
        Computer comp = node.toComputer();
        if (comp != null) {
            env.putAll((Map)comp.getEnvironment());
        }
        for (NodeProperty nodeProperty : node.getNodeProperties()) {
            nodeProperty.buildEnvVars(env, listener);
        }
        cmd.reference(env.expand(this.reference));
    }

    @Override
    public void decorateFetchCommand(GitSCM scm, GitClient git, TaskListener listener, FetchCommand cmd) throws IOException, InterruptedException, GitException {
        cmd.shallow(this.shallow);
        if (this.shallow) {
            int usedDepth = this.depth == null || this.depth < 1 ? 1 : this.depth;
            listener.getLogger().println("Using shallow fetch with depth " + usedDepth);
            cmd.depth(Integer.valueOf(usedDepth));
        }
        cmd.tags(!this.noTags);
        cmd.timeout(this.timeout);
    }

    @Override
    public GitClientType getRequiredClient() {
        return GitClientType.GITCLI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CloneOption that = (CloneOption)((Object)o);
        return this.shallow == that.shallow && this.noTags == that.noTags && Objects.equals(this.depth, that.depth) && this.honorRefspec == that.honorRefspec && Objects.equals(this.reference, that.reference) && Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.shallow, this.noTags, this.depth, this.honorRefspec, this.reference, this.timeout);
    }

    public String toString() {
        return "CloneOption{shallow=" + this.shallow + ", noTags=" + this.noTags + ", reference='" + this.reference + '\'' + ", timeout=" + this.timeout + ", depth=" + this.depth + ", honorRefspec=" + this.honorRefspec + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Advanced clone behaviours";
        }
    }
}

