/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.util.Build;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class BuildDetails
implements Action,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public Build build;
    public String scmName;
    public Set<String> remoteUrls = new HashSet<String>();
    @CheckForNull
    private Integer index;
    static final Logger LOGGER = Logger.getLogger(BuildDetails.class.getName());

    public BuildDetails(Build build) {
        this.build = build;
    }

    public BuildDetails(Build build, String scmName) {
        this.build = build;
        this.scmName = scmName;
    }

    public BuildDetails(Build build, String scmName, Collection<UserRemoteConfig> remoteConfigs) {
        this.build = build;
        this.scmName = scmName;
        for (UserRemoteConfig c : remoteConfigs) {
            this.remoteUrls.add(c.getUrl());
        }
    }

    public String getDisplayName() {
        if (this.scmName != null && !this.scmName.isEmpty()) {
            return "Git Build Details:" + this.scmName;
        }
        return "Git Build Details";
    }

    public String getIconFileName() {
        return Jenkins.RESOURCE_PATH + "/plugin/git/icons/git-32x32.png";
    }

    public String getUrlName() {
        return this.index == null ? "git" : "git-" + this.index;
    }

    public void setIndex(Integer index) {
        this.index = index == null || index <= 1 ? null : index;
    }

    @CheckForNull
    public Integer getIndex() {
        return this.index;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public Run<?, ?> getOwningRun() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return null;
        }
        return (Run)req.findAncestorObject(Run.class);
    }

    public Object readResolve() {
        if (this.remoteUrls == null) {
            this.remoteUrls = new HashSet<String>();
        }
        return this;
    }

    public void setScmName(String scmName) {
        this.scmName = scmName;
    }

    @Exported
    public String getScmName() {
        if (this.scmName == null) {
            this.scmName = "";
        }
        return this.scmName;
    }

    public void addRemoteUrl(String remoteUrl) {
        this.remoteUrls.add(remoteUrl);
    }

    @Exported
    public Set<String> getRemoteUrls() {
        return this.remoteUrls;
    }

    public boolean hasBeenReferenced(String remoteUrl) {
        return this.remoteUrls.contains(remoteUrl);
    }

    public BuildDetails clone() {
        BuildDetails clone;
        try {
            clone = (BuildDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning BuildDetails", e);
        }
        clone.remoteUrls = new HashSet<String>();
        if (this.build != null) {
            clone.build = this.build;
        }
        for (String remoteUrl : this.getRemoteUrls()) {
            clone.addRemoteUrl(remoteUrl);
        }
        return clone;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String toString() {
        String scmNameString = this.scmName == null ? "<null>" : this.scmName;
        return super.toString() + "[scmName=" + scmNameString + ",remoteUrls=" + this.remoteUrls + ",build=" + this.build + "]";
    }

    private String normalize(String url) {
        if (url == null) {
            return null;
        }
        String normalized = url.replaceAll("/+$", "").replaceAll("[.]git$", "");
        if (url.contains("://")) {
            try {
                URI uri = new URI(normalized);
                normalized = uri.normalize().toString();
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.FINEST, "URI syntax exception on " + url, ex);
            }
        }
        return normalized;
    }

    public boolean similarTo(BuildDetails that) {
        if (that == null) {
            return false;
        }
        if (this.remoteUrls == null ^ that.remoteUrls == null) {
            return false;
        }
        if (this.build == null ? that.build != null : !this.build.equals(that.build)) {
            return false;
        }
        HashSet<String> thisUrls = new HashSet<String>(this.remoteUrls.size());
        for (String url : this.remoteUrls) {
            thisUrls.add(this.normalize(url));
        }
        HashSet<String> thatUrls = new HashSet<String>(that.remoteUrls.size());
        for (String url : that.remoteUrls) {
            thatUrls.add(this.normalize(url));
        }
        return thisUrls.equals(thatUrls);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildDetails)) {
            return false;
        }
        BuildDetails otherBuildDetails = (BuildDetails)o;
        if (this.remoteUrls == null ^ otherBuildDetails.remoteUrls == null) {
            return false;
        }
        if (this.remoteUrls != null && otherBuildDetails.remoteUrls != null && !this.remoteUrls.equals(otherBuildDetails.remoteUrls)) {
            return false;
        }
        if (this.build == null ^ otherBuildDetails.build == null) {
            return false;
        }
        return this.build == null || otherBuildDetails.build == null || this.build.equals(otherBuildDetails.build);
    }

    public int hashCode() {
        int result = 3;
        result = result * 17 + (this.remoteUrls == null ? 5 : this.remoteUrls.hashCode());
        result = result * 17 + (this.build == null ? 11 : this.build.hashCode());
        return result;
    }
}

