/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.Util;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserIdentity
extends GitSCMExtension {
    private String name;
    private String email;

    @DataBoundConstructor
    public UserIdentity(String name, String email) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.email = Util.fixEmptyAndTrim((String)email);
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public void populateEnvironmentVariables(GitSCM scm, Map<String, String> env) {
        if (this.name != null) {
            env.put("GIT_COMMITTER_NAME", this.name);
            env.put("GIT_AUTHOR_NAME", this.name);
        }
        if (this.email != null) {
            env.put("GIT_COMMITTER_EMAIL", this.email);
            env.put("GIT_AUTHOR_EMAIL", this.email);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UserIdentity that = (UserIdentity)((Object)o);
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.email != null ? this.email.equals(that.email) : that.email == null;
    }

    public int hashCode() {
        return UserIdentity.class.hashCode();
    }

    public String toString() {
        return "UserIdentity{name='" + this.name + '\'' + ", email='" + this.email + '\'' + '}';
    }

    @Override
    public GitClient decorate(GitSCM scm, GitClient git) throws IOException, InterruptedException, GitException {
        GitSCM.DescriptorImpl d = scm.getDescriptor();
        String n = d.getGlobalConfigName();
        if (this.name != null) {
            n = this.name;
        }
        String e = d.getGlobalConfigEmail();
        if (this.email != null) {
            e = this.email;
        }
        git.setAuthor(n, e);
        git.setCommitter(n, e);
        return git;
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Custom user name/e-mail address";
        }
    }
}

