/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.git.util.MergeRecord;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.kohsuke.stapler.DataBoundConstructor;

public class PreBuildMerge
extends GitSCMExtension {
    private UserMergeOptions options;

    @DataBoundConstructor
    public PreBuildMerge(UserMergeOptions options) {
        if (options == null) {
            throw new IllegalStateException();
        }
        this.options = options;
    }

    public UserMergeOptions getOptions() {
        return this.options;
    }

    @Override
    public Revision decorateRevisionToBuild(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, Revision marked, Revision rev) throws IOException, InterruptedException {
        String remoteBranchRef = GitSCM.getParameterString(this.options.getRef(), build.getEnvironment(listener));
        if (rev.containsBranchName(remoteBranchRef)) {
            return rev;
        }
        listener.getLogger().println("Merging " + rev + " to " + remoteBranchRef + ", " + this.options);
        ObjectId target = git.revParse(remoteBranchRef);
        String paramLocalBranch = scm.getParamLocalBranch(build, listener);
        CheckoutCommand checkoutCommand = git.checkout().branch(paramLocalBranch).ref(remoteBranchRef).deleteBranchIfExist(true);
        for (Object ext : scm.getExtensions()) {
            ((GitSCMExtension)((Object)ext)).decorateCheckoutCommand(scm, build, git, listener, checkoutCommand);
        }
        checkoutCommand.execute();
        try {
            MergeCommand cmd = git.merge().setRevisionToMerge(rev.getSha1());
            for (GitSCMExtension ext : scm.getExtensions()) {
                ext.decorateMergeCommand(scm, build, git, listener, cmd);
            }
            cmd.execute();
        }
        catch (GitException ex) {
            checkoutCommand = git.checkout().branch(paramLocalBranch).ref(rev.getSha1String()).deleteBranchIfExist(true);
            for (GitSCMExtension ext : scm.getExtensions()) {
                ext.decorateCheckoutCommand(scm, build, git, listener, checkoutCommand);
            }
            checkoutCommand.execute();
            BuildData bd = scm.getBuildData(build);
            if (bd != null) {
                bd.saveBuild(new Build(marked, rev, build.getNumber(), Result.FAILURE));
            } else {
                listener.getLogger().println("Was not possible to get build data");
            }
            throw new AbortException("Branch not suitable for integration as it does not merge cleanly: " + ex.getMessage());
        }
        build.addAction((Action)new MergeRecord(remoteBranchRef, target.getName()));
        Revision mergeRevision = new GitUtils(listener, git).getRevisionForSHA1(git.revParse("HEAD"));
        mergeRevision.getBranches().add(new Branch(remoteBranchRef, target));
        return mergeRevision;
    }

    @Override
    public void decorateMergeCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, MergeCommand cmd) throws IOException, InterruptedException, GitException {
        if (this.options.getMergeStrategy() != null) {
            cmd.setStrategy(this.options.getMergeStrategy());
        }
        cmd.setGitPluginFastForwardMode(this.options.getFastForwardMode());
    }

    @Override
    public GitClientType getRequiredClient() {
        return GitClientType.GITCLI;
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Merge before build";
        }
    }
}

