/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.Messages;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.CommitTimeComparator;
import hudson.plugins.git.util.GitUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InverseBuildChooser
extends BuildChooser {
    private static final BranchSpec HEAD = new BranchSpec("*/HEAD");
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public InverseBuildChooser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData buildData, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        GitUtils utils = new GitUtils(listener, git);
        Collection<Object> branchRevs = new ArrayList<Revision>(utils.getAllBranchRevisions());
        List<BranchSpec> specifiedBranches = this.gitSCM.getBranches();
        Iterator i = branchRevs.iterator();
        while (i.hasNext()) {
            Revision revision = (Revision)i.next();
            Iterator j = revision.getBranches().iterator();
            block4: while (j.hasNext()) {
                Branch branch = (Branch)j.next();
                for (BranchSpec spec : specifiedBranches) {
                    if (!spec.matches(branch.getName()) && !HEAD.matches(branch.getName())) continue;
                    j.remove();
                    continue block4;
                }
            }
            if (!revision.getBranches().isEmpty()) continue;
            i.remove();
        }
        if ((branchRevs = utils.filterTipBranches(branchRevs)).isEmpty()) {
            listener.getLogger().println(Messages.BuildChooser_Inverse_EverythingExcluded());
        }
        i = branchRevs.iterator();
        while (i.hasNext()) {
            Revision r = (Revision)i.next();
            if (!buildData.hasBeenBuilt(r.getSha1())) continue;
            i.remove();
        }
        if (!isPollCall && branchRevs.isEmpty() && buildData.getLastBuiltRevision() != null) {
            listener.getLogger().println(Messages.BuildChooser_BuildingLastRevision());
            return Collections.singletonList(buildData.getLastBuiltRevision());
        }
        Repository repository = utils.git.getRepository();
        try {
            Collections.sort(branchRevs, new CommitTimeComparator(repository));
        }
        finally {
            repository.close();
        }
        return branchRevs;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return Messages.BuildChooser_Inverse();
        }
    }
}

