/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitPublisher
extends Recorder
implements Serializable,
MatrixAggregatable {
    private static final long serialVersionUID = 1L;
    private Long configVersion;
    private boolean pushMerge;
    private boolean pushOnlyIfSuccess;
    private List<TagToPush> tagsToPush;
    private List<BranchToPush> branchesToPush;
    private List<NoteToPush> notesToPush;

    @DataBoundConstructor
    public GitPublisher(List<TagToPush> tagsToPush, List<BranchToPush> branchesToPush, List<NoteToPush> notesToPush, boolean pushOnlyIfSuccess, boolean pushMerge) {
        this.tagsToPush = tagsToPush;
        this.branchesToPush = branchesToPush;
        this.notesToPush = notesToPush;
        this.pushMerge = pushMerge;
        this.pushOnlyIfSuccess = pushOnlyIfSuccess;
        this.configVersion = 2L;
    }

    public boolean isPushOnlyIfSuccess() {
        return this.pushOnlyIfSuccess;
    }

    public boolean isPushMerge() {
        return this.pushMerge;
    }

    public boolean isPushTags() {
        if (this.tagsToPush == null) {
            return false;
        }
        return !this.tagsToPush.isEmpty();
    }

    public boolean isPushBranches() {
        if (this.branchesToPush == null) {
            return false;
        }
        return !this.branchesToPush.isEmpty();
    }

    public boolean isPushNotes() {
        if (this.notesToPush == null) {
            return false;
        }
        return !this.notesToPush.isEmpty();
    }

    public List<TagToPush> getTagsToPush() {
        if (this.tagsToPush == null) {
            this.tagsToPush = new ArrayList<TagToPush>();
        }
        return this.tagsToPush;
    }

    public List<BranchToPush> getBranchesToPush() {
        if (this.branchesToPush == null) {
            this.branchesToPush = new ArrayList<BranchToPush>();
        }
        return this.branchesToPush;
    }

    public List<NoteToPush> getNotesToPush() {
        if (this.notesToPush == null) {
            this.notesToPush = new ArrayList<NoteToPush>();
        }
        return this.notesToPush;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                return GitPublisher.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
            }
        };
    }

    private String replaceAdditionalEnvironmentalVariables(String input, AbstractBuild<?, ?> build) {
        if (build == null) {
            return input;
        }
        String buildResult = build.getResult().toString();
        String buildDuration = build.getDurationString();
        if (buildResult == null) {
            buildResult = "";
        }
        buildDuration = buildDuration == null ? "" : buildDuration.replaceAll("and counting", "");
        input = input.replaceAll("\\$BUILDRESULT", buildResult);
        input = input.replaceAll("\\$BUILDDURATION", buildDuration);
        return input;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException {
        String confEmail;
        EnvVars tempEnvironment;
        if (build instanceof MatrixRun) {
            return true;
        }
        SCM scm = build.getProject().getScm();
        if (!(scm instanceof GitSCM)) {
            return false;
        }
        final GitSCM gitSCM = (GitSCM)scm;
        if (gitSCM.getUseShallowClone()) {
            listener.getLogger().println("GitPublisher disabled while using shallow clone.");
            return true;
        }
        final String projectName = build.getProject().getName();
        FilePath workspacePath = build.getWorkspace();
        final int buildNumber = build.getNumber();
        final Result buildResult = build.getResult();
        if (this.pushOnlyIfSuccess && buildResult.isWorseThan(Result.SUCCESS)) {
            listener.getLogger().println("Build did not succeed and the project is configured to only push after a successful build, so no pushing will occur.");
            return true;
        }
        final String gitExe = gitSCM.getGitExe(build.getBuiltOn(), (TaskListener)listener);
        try {
            tempEnvironment = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to build up environment"));
            tempEnvironment = new EnvVars();
        }
        String confName = gitSCM.getGitConfigNameToUse();
        if (confName != null && !confName.equals("")) {
            tempEnvironment.put("GIT_COMMITTER_NAME", confName);
            tempEnvironment.put("GIT_AUTHOR_NAME", confName);
        }
        if ((confEmail = gitSCM.getGitConfigEmailToUse()) != null && !confEmail.equals("")) {
            tempEnvironment.put("GIT_COMMITTER_EMAIL", confEmail);
            tempEnvironment.put("GIT_AUTHOR_EMAIL", confEmail);
        }
        final EnvVars environment = tempEnvironment;
        FilePath workingDirectory = gitSCM.workingDirectory(workspacePath, environment);
        boolean pushResult = true;
        if (this.pushMerge) {
            boolean mergeResult;
            try {
                mergeResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                    private static final long serialVersionUID = 1L;

                    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                        GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(workspace).using(gitExe).getClient();
                        if (!gitSCM.getSkipTag()) {
                            String buildnumber = "jenkins-" + projectName.replace(" ", "_") + "-" + buildNumber;
                            git.deleteTag(buildnumber);
                            buildnumber = buildnumber + "-" + buildResult.toString();
                            git.tag(buildnumber, "Jenkins Build #" + buildNumber);
                        }
                        PreBuildMergeOptions mergeOptions = gitSCM.getMergeOptions();
                        String mergeTarget = environment.expand(mergeOptions.getMergeTarget());
                        if (mergeOptions.doMerge() && buildResult.isBetterOrEqualTo(Result.SUCCESS)) {
                            RemoteConfig remote = mergeOptions.getMergeRemote();
                            listener.getLogger().println("Pushing HEAD to branch " + mergeTarget + " of " + remote.getName() + " repository");
                            git.push(remote.getName(), "HEAD:" + mergeTarget);
                        }
                        return true;
                    }
                });
            }
            catch (Throwable e) {
                e.printStackTrace(listener.error("Failed to push merge to origin repository"));
                build.setResult(Result.FAILURE);
                mergeResult = false;
            }
            if (!mergeResult) {
                pushResult = false;
            }
        }
        if (this.isPushTags()) {
            boolean allTagsResult = true;
            for (final TagToPush tagToPush : this.tagsToPush) {
                boolean tagResult = true;
                if (tagToPush.getTagName() == null) {
                    listener.getLogger().println("No tag to push defined");
                    tagResult = false;
                }
                if (tagToPush.getTargetRepoName() == null) {
                    listener.getLogger().println("No target repo to push to defined");
                    tagResult = false;
                }
                if (tagResult) {
                    final String tagName = environment.expand(tagToPush.getTagName());
                    final String tagMessage = Util.fixNull((String)environment.expand(tagToPush.getTagMessage()));
                    final String targetRepo = environment.expand(tagToPush.getTargetRepoName());
                    try {
                        tagResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                            private static final long serialVersionUID = 1L;

                            public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                                GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(workspace).using(gitExe).getClient();
                                RemoteConfig remote = gitSCM.getRepositoryByName(targetRepo);
                                if (remote == null) {
                                    listener.getLogger().println("No repository found for target repo name " + targetRepo);
                                    return false;
                                }
                                boolean tagExists = git.tagExists(tagName.replace(' ', '_'));
                                if (tagToPush.isCreateTag() || tagToPush.isUpdateTag()) {
                                    if (tagExists && !tagToPush.isUpdateTag()) {
                                        listener.getLogger().println("Tag " + tagName + " already exists and Create Tag is specified, so failing.");
                                        return false;
                                    }
                                    if (tagMessage.isEmpty()) {
                                        git.tag(tagName, "Jenkins Git plugin tagging with " + tagName);
                                    } else {
                                        git.tag(tagName, tagMessage);
                                    }
                                } else if (!tagExists) {
                                    listener.getLogger().println("Tag " + tagName + " does not exist and Create Tag is not specified, so failing.");
                                    return false;
                                }
                                listener.getLogger().println("Pushing tag " + tagName + " to repo " + targetRepo);
                                git.push(remote.getName(), tagName);
                                return true;
                            }
                        });
                    }
                    catch (Throwable e) {
                        e.printStackTrace(listener.error("Failed to push tag " + tagName + " to " + targetRepo));
                        build.setResult(Result.FAILURE);
                        tagResult = false;
                    }
                }
                if (tagResult) continue;
                allTagsResult = false;
            }
            if (!allTagsResult) {
                pushResult = false;
            }
        }
        if (this.isPushBranches()) {
            boolean allBranchesResult = true;
            for (BranchToPush branchToPush : this.branchesToPush) {
                boolean branchResult = true;
                if (branchToPush.getBranchName() == null) {
                    listener.getLogger().println("No branch to push defined");
                    return false;
                }
                if (branchToPush.getTargetRepoName() == null) {
                    listener.getLogger().println("No branch repo to push to defined");
                    return false;
                }
                final String branchName = environment.expand(branchToPush.getBranchName());
                final String targetRepo = environment.expand(branchToPush.getTargetRepoName());
                if (branchResult) {
                    try {
                        branchResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                            private static final long serialVersionUID = 1L;

                            public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                                GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(workspace).using(gitExe).getClient();
                                RemoteConfig remote = gitSCM.getRepositoryByName(targetRepo);
                                if (remote == null) {
                                    listener.getLogger().println("No repository found for target repo name " + targetRepo);
                                    return false;
                                }
                                listener.getLogger().println("Pushing HEAD to branch " + branchName + " at repo " + targetRepo);
                                git.push(remote.getName(), "HEAD:" + branchName);
                                return true;
                            }
                        });
                    }
                    catch (Throwable e) {
                        e.printStackTrace(listener.error("Failed to push branch " + branchName + " to " + targetRepo));
                        build.setResult(Result.FAILURE);
                        branchResult = false;
                    }
                }
                if (branchResult) continue;
                allBranchesResult = false;
            }
            if (!allBranchesResult) {
                pushResult = false;
            }
        }
        if (this.isPushNotes()) {
            boolean allNotesResult = true;
            for (NoteToPush noteToPush : this.notesToPush) {
                boolean noteResult = true;
                if (noteToPush.getnoteMsg() == null) {
                    listener.getLogger().println("No note to push defined");
                    return false;
                }
                noteToPush.setEmptyTargetRepoToOrigin();
                String noteMsgTmp = environment.expand(noteToPush.getnoteMsg());
                final String noteMsg = this.replaceAdditionalEnvironmentalVariables(noteMsgTmp, build);
                final String noteNamespace = environment.expand(noteToPush.getnoteNamespace());
                final String targetRepo = environment.expand(noteToPush.getTargetRepoName());
                final boolean noteReplace = noteToPush.getnoteReplace();
                if (noteResult) {
                    try {
                        noteResult = (Boolean)workingDirectory.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){
                            private static final long serialVersionUID = 1L;

                            public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                                GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(workspace).using(gitExe).getClient();
                                RemoteConfig remote = gitSCM.getRepositoryByName(targetRepo);
                                if (remote == null) {
                                    listener.getLogger().println("No repository found for target repo name " + targetRepo);
                                    return false;
                                }
                                listener.getLogger().println("Adding note to namespace \"" + noteNamespace + "\":\n" + noteMsg + "\n******");
                                if (noteReplace) {
                                    git.addNote(noteMsg, noteNamespace);
                                } else {
                                    git.appendNote(noteMsg, noteNamespace);
                                }
                                git.push(remote.getName(), "refs/notes/*");
                                return true;
                            }
                        });
                    }
                    catch (Throwable e) {
                        e.printStackTrace(listener.error("Failed to add note: \n" + noteMsg + "\n******"));
                        build.setResult(Result.FAILURE);
                        noteResult = false;
                    }
                }
                if (noteResult) continue;
                allNotesResult = false;
            }
            if (!allNotesResult) {
                pushResult = false;
            }
        }
        return pushResult;
    }

    private Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.configVersion < 1L && this.tagsToPush == null) {
            this.pushMerge = true;
        }
        return this;
    }

    public static final class NoteToPush
    extends PushConfig {
        private String noteMsg;
        private String noteNamespace;
        private boolean noteReplace;

        public String getnoteMsg() {
            return this.noteMsg;
        }

        public String getnoteNamespace() {
            return this.noteNamespace;
        }

        public boolean getnoteReplace() {
            return this.noteReplace;
        }

        @DataBoundConstructor
        public NoteToPush(String targetRepoName, String noteMsg, String noteNamespace, boolean noteReplace) {
            super(targetRepoName);
            this.noteMsg = Util.fixEmptyAndTrim((String)noteMsg);
            this.noteReplace = noteReplace;
            this.noteNamespace = noteNamespace != null && !noteNamespace.trim().isEmpty() ? Util.fixEmptyAndTrim((String)noteNamespace) : "master";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends Descriptor<PushConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    public static final class TagToPush
    extends PushConfig {
        private String tagName;
        private String tagMessage;
        private boolean createTag;
        private boolean updateTag;

        public String getTagName() {
            return this.tagName;
        }

        public String getTagMessage() {
            return this.tagMessage;
        }

        public boolean isCreateTag() {
            return this.createTag;
        }

        public boolean isUpdateTag() {
            return this.updateTag;
        }

        @DataBoundConstructor
        public TagToPush(String targetRepoName, String tagName, String tagMessage, boolean createTag, boolean updateTag) {
            super(targetRepoName);
            this.tagName = Util.fixEmptyAndTrim((String)tagName);
            this.tagMessage = tagMessage;
            this.createTag = createTag;
            this.updateTag = updateTag;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends Descriptor<PushConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    public static final class BranchToPush
    extends PushConfig {
        private String branchName;

        public String getBranchName() {
            return this.branchName;
        }

        @DataBoundConstructor
        public BranchToPush(String targetRepoName, String branchName) {
            super(targetRepoName);
            this.branchName = Util.fixEmptyAndTrim((String)branchName);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends Descriptor<PushConfig> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PushConfig
    extends AbstractDescribableImpl<PushConfig>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String targetRepoName;

        public PushConfig(String targetRepoName) {
            this.targetRepoName = Util.fixEmptyAndTrim((String)targetRepoName);
        }

        public String getTargetRepoName() {
            return this.targetRepoName;
        }

        public void setTargetRepoName() {
            this.targetRepoName = this.targetRepoName;
        }

        public void setEmptyTargetRepoToOrigin() {
            if (this.targetRepoName == null || this.targetRepoName.trim().isEmpty()) {
                this.targetRepoName = "origin";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=-1.0)
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Git Publisher";
        }

        public String getHelpFile() {
            return "/plugin/git/gitPublisher.html";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public FormValidation doCheckTagName(@QueryParameter String value) {
            return this.checkFieldNotEmpty(value, "Tag Name");
        }

        public FormValidation doCheckBranchName(@QueryParameter String value) {
            return this.checkFieldNotEmpty(value, "Branch Name");
        }

        public FormValidation doCheckNoteMsg(@QueryParameter String value) {
            return this.checkFieldNotEmpty(value, "Note");
        }

        public FormValidation doCheckRemote(@AncestorInPath AbstractProject project, StaplerRequest req) throws IOException, ServletException {
            boolean isMerge;
            String remote = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (remote.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            FormValidation validation = this.checkFieldNotEmpty(remote, "Remote Name");
            if (validation.kind != FormValidation.Kind.OK) {
                return validation;
            }
            GitSCM scm = (GitSCM)project.getScm();
            if (scm.getRepositoryByName(remote) == null) {
                return FormValidation.error((String)("No remote repository configured with name '" + remote + "'"));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        private FormValidation checkFieldNotEmpty(String value, String field) {
            if ((value = StringUtils.strip((String)value)) == null || value.equals("")) {
                return FormValidation.error((String)(field + " is required."));
            }
            return FormValidation.ok();
        }
    }
}

