/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.verifier;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.gitclient.verifier.AbstractCliGitHostKeyVerifier;
import org.jenkinsci.plugins.gitclient.verifier.AbstractJGitHostKeyVerifier;
import org.jenkinsci.plugins.gitclient.verifier.HostKeyVerifierFactory;

public class NoHostKeyVerifier
extends HostKeyVerifierFactory {
    private static final Logger LOGGER = Logger.getLogger(NoHostKeyVerifier.class.getName());

    @Override
    public AbstractCliGitHostKeyVerifier forCliGit(TaskListener listener) {
        return (AbstractCliGitHostKeyVerifier & Serializable)tempKnownHosts -> "-o StrictHostKeyChecking=no";
    }

    @Override
    public AbstractJGitHostKeyVerifier forJGit(TaskListener listener) {
        return new AbstractJGitHostKeyVerifier(new KnownHosts()){

            @Override
            public String[] getServerHostKeyAlgorithms(Connection connection) {
                return new String[0];
            }

            public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) {
                LOGGER.log(Level.FINEST, "No host key verifier, host {0}:{1} not verified with host key {2} {3}", new Object[]{hostname, port, serverHostKeyAlgorithm, Base64.getEncoder().encodeToString(serverHostKey)});
                return true;
            }
        };
    }
}

