/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.trilead;

import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.trilead.StandardUsernameCredentialsCredentialItem;

public class SmartCredentialsProvider
extends CredentialsProvider {
    public final TaskListener listener;
    private StandardCredentials defaultCredentials;
    private Map<String, StandardCredentials> specificCredentials = new HashMap<String, StandardCredentials>();
    private static final Logger LOGGER = Logger.getLogger(SmartCredentialsProvider.class.getName());

    public SmartCredentialsProvider(TaskListener listener) {
        this.listener = listener;
    }

    public synchronized void clearCredentials() {
        this.defaultCredentials = null;
        this.specificCredentials.clear();
    }

    public synchronized void addCredentials(String url, StandardCredentials credentials) {
        this.specificCredentials.put(this.normalizeURI(url), credentials);
    }

    public synchronized void addDefaultCredentials(StandardCredentials credentials) {
        this.defaultCredentials = credentials;
    }

    public boolean isInteractive() {
        return false;
    }

    public synchronized boolean supports(CredentialItem ... credentialItems) {
        block0: for (CredentialItem item : credentialItems) {
            if (this.supports(this.defaultCredentials, item)) continue;
            for (StandardCredentials c : this.specificCredentials.values()) {
                if (!this.supports(c, item)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean supports(StandardCredentials c, CredentialItem i) {
        if (c == null) {
            return false;
        }
        if (i instanceof StandardUsernameCredentialsCredentialItem) {
            return c instanceof StandardUsernameCredentials;
        }
        if (i instanceof CredentialItem.Username) {
            return c instanceof UsernameCredentials;
        }
        if (i instanceof CredentialItem.Password) {
            return c instanceof PasswordCredentials;
        }
        return false;
    }

    public synchronized boolean get(URIish uri, CredentialItem ... credentialItems) throws UnsupportedCredentialItem {
        StandardCredentials c = this.specificCredentials.get(uri == null ? null : this.normalizeURI(uri.toString()));
        if (c == null) {
            c = this.defaultCredentials;
        }
        if (c == null) {
            if (uri != null) {
                LOGGER.log(Level.FINE, () -> "No credentials provided for " + uri);
            }
            return false;
        }
        for (CredentialItem i : credentialItems) {
            if (i instanceof StandardUsernameCredentialsCredentialItem && c instanceof StandardUsernameCredentials) {
                ((StandardUsernameCredentialsCredentialItem)i).setValue((StandardUsernameCredentials)c);
                continue;
            }
            if (i instanceof CredentialItem.Username && c instanceof UsernameCredentials) {
                ((CredentialItem.Username)i).setValue(((UsernameCredentials)c).getUsername());
                continue;
            }
            if (i instanceof CredentialItem.Password && c instanceof PasswordCredentials) {
                ((CredentialItem.Password)i).setValue(((PasswordCredentials)c).getPassword().getPlainText().toCharArray());
                continue;
            }
            if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ") && c instanceof PasswordCredentials) {
                ((CredentialItem.StringType)i).setValue(((PasswordCredentials)c).getPassword().getPlainText());
                continue;
            }
            throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
        }
        return true;
    }

    private String normalizeURI(String uri) {
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)uri, (String)"/"), (String)".git");
    }
}

