/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitAPI
extends CliGitAPIImpl {
    private static final long serialVersionUID = 1L;
    private final GitClient jgit;

    @Deprecated
    public GitAPI(String gitExe, FilePath repository, TaskListener listener, EnvVars environment) throws IOException, InterruptedException {
        this(gitExe, new File(repository.getRemote()), listener, environment);
    }

    @Deprecated
    public GitAPI(String gitExe, FilePath repository, TaskListener listener, EnvVars environment, String reference) throws IOException, InterruptedException {
        this(gitExe, repository, listener, environment);
    }

    @Deprecated
    public GitAPI(String gitExe, File repository, TaskListener listener, EnvVars environment) throws IOException, InterruptedException {
        super(gitExe, repository, listener, environment);
        this.jgit = Git.USE_CLI ? null : Git.with(listener, environment).in(repository).using("jgit").getClient();
    }

    @Override
    public void add(String filePattern) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.add(filePattern);
        } else {
            this.jgit.add(filePattern);
        }
    }

    @Override
    public String getRemoteUrl(String name) throws GitException, InterruptedException {
        return Git.USE_CLI ? super.getRemoteUrl(name) : this.jgit.getRemoteUrl(name);
    }

    @Override
    public void push(String remoteName, String refspec) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.push(remoteName, refspec);
        } else {
            this.jgit.push(remoteName, refspec);
        }
    }

    @Override
    public String getTagMessage(String tagName) throws GitException, InterruptedException {
        return Git.USE_CLI ? super.getTagMessage(tagName) : this.jgit.getTagMessage(tagName);
    }

    @Override
    public GitClient subGit(String subdir) {
        return Git.USE_CLI ? super.subGit(subdir) : this.jgit.subGit(subdir);
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.setRemoteUrl(name, url);
        } else {
            this.jgit.setRemoteUrl(name, url);
        }
    }

    @Override
    public Set<Branch> getBranches() throws GitException, InterruptedException {
        return Git.USE_CLI ? super.getBranches() : this.jgit.getBranches();
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException, InterruptedException {
        return Git.USE_CLI ? super.getRemoteBranches() : this.jgit.getRemoteBranches();
    }

    @Override
    public void init() throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.init();
        } else {
            this.jgit.init();
        }
    }

    @Override
    public void deleteBranch(String name) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.deleteBranch(name);
        } else {
            this.jgit.deleteBranch(name);
        }
    }

    @Override
    public void checkout(String ref, String branch) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.checkout().ref(ref).branch(branch).execute();
        } else {
            this.jgit.checkout().ref(ref).branch(branch).execute();
        }
    }

    @Override
    public boolean hasGitRepo() throws GitException, InterruptedException {
        return Git.USE_CLI ? super.hasGitRepo() : this.jgit.hasGitRepo();
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws GitException, InterruptedException {
        return Git.USE_CLI ? super.isCommitInRepo(commit) : this.jgit.isCommitInRepo(commit);
    }

    @Override
    public void commit(String message) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.commit(message);
        } else {
            this.jgit.commit(message);
        }
    }

    @Override
    public void commit(String message, PersonIdent author, PersonIdent committer) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.setAuthor(author);
            super.setCommitter(committer);
            super.commit(message);
        } else {
            this.jgit.setAuthor(author);
            this.jgit.setCommitter(committer);
            this.jgit.commit(message);
        }
    }

    @Override
    public void checkout(String ref) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.checkout().ref(ref).execute();
        } else {
            this.jgit.checkout().ref(ref).execute();
        }
    }

    @Override
    public void deleteTag(String tagName) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.deleteTag(tagName);
        } else {
            this.jgit.deleteTag(tagName);
        }
    }

    @Override
    @NonNull
    public Repository getRepository() throws GitException {
        return Git.USE_CLI ? super.getRepository() : this.jgit.getRepository();
    }

    @Override
    public void tag(String tagName, String comment) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.tag(tagName, comment);
        } else {
            this.jgit.tag(tagName, comment);
        }
    }

    @Override
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.fetch_().from(url, refspecs).execute();
        } else {
            this.jgit.fetch_().from(url, refspecs).execute();
        }
    }

    @Override
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.fetch(remoteName, refspec);
        } else {
            this.jgit.fetch(remoteName, refspec);
        }
    }

    @Override
    public void fetch(String remoteName, RefSpec refspec) throws GitException, InterruptedException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    @Override
    public boolean tagExists(String tagName) throws GitException, InterruptedException {
        return Git.USE_CLI ? super.tagExists(tagName) : this.jgit.tagExists(tagName);
    }

    @Override
    public void clean() throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.clean();
        } else {
            this.jgit.clean();
        }
    }

    @Override
    public ObjectId revParse(String revName) throws GitException, InterruptedException {
        return Git.USE_CLI ? super.revParse(revName) : this.jgit.revParse(revName);
    }

    @Override
    public void branch(String name) throws GitException, InterruptedException {
        if (Git.USE_CLI) {
            super.branch(name);
        } else {
            this.jgit.branch(name);
        }
    }
}

