/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.PathRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitURIRequirementsBuilder {
    private static final String SCHEME_P = "([a-z][a-z0-9+-]+)://";
    private static final String OPT_USER_PWD_P = "(?:([^/:@]+)(?::([^\\\\/]+))?@)?";
    private static final String HOST_P = "((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\]))";
    private static final String OPT_PORT_P = "(?::(\\d+))?";
    private static final String USER_HOME_P = "(?:/~(?:[^\\\\/]+))";
    private static final String OPT_DRIVE_LETTER_P = "(?:[A-Za-z]:)?";
    private static final String RELATIVE_PATH_P = "(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)";
    private static final String PATH_P = "((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))";
    private static final long serialVersionUID = 1L;
    private static final Pattern FULL_URI = Pattern.compile("^([a-z][a-z0-9+-]+)://(?:(?:([^/:@]+)(?::([^\\\\/]+))?@)?((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\]))(?::(\\d+))?((?:/~(?:[^\\\\/]+))?[\\\\/]))?(.+)?$");
    private static final Pattern LOCAL_FILE = Pattern.compile("^([\\\\/]?((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)))$");
    private static final Pattern SINGLE_SLASH_FILE_URI = Pattern.compile("^(file):([\\\\/](?![\\\\/])((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)))$");
    private static final Pattern RELATIVE_SCP_URI = Pattern.compile("^(?:([^/:@]+)(?::([^\\\\/]+))?@)?((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\])):((?:(?:/~(?:[^\\\\/]+))[\\\\/])?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))$");
    private static final Pattern ABSOLUTE_SCP_URI = Pattern.compile("^(?:([^/:@]+)(?::([^\\\\/]+))?@)?([^\\\\/:]{2,}):([\\\\/](?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))$");
    @NonNull
    private final List<DomainRequirement> requirements;

    private GitURIRequirementsBuilder(@NonNull List<DomainRequirement> requirements) {
        this.requirements = new ArrayList<DomainRequirement>(requirements);
    }

    @NonNull
    public static GitURIRequirementsBuilder create() {
        return new GitURIRequirementsBuilder(Collections.emptyList());
    }

    @NonNull
    public GitURIRequirementsBuilder duplicate() {
        return new GitURIRequirementsBuilder(this.requirements);
    }

    @NonNull
    public static GitURIRequirementsBuilder fromUri(@CheckForNull String uri) {
        return GitURIRequirementsBuilder.create().withUri(uri);
    }

    @NonNull
    public GitURIRequirementsBuilder withUri(@CheckForNull String uri) {
        if (uri != null) {
            Matcher matcher = SINGLE_SLASH_FILE_URI.matcher(uri);
            if (matcher.matches()) {
                return this.withScheme("file").withPath(matcher.group(2)).withoutHostname().withoutHostnamePort();
            }
            matcher = FULL_URI.matcher(uri);
            if (matcher.matches()) {
                this.withScheme(matcher.group(1));
                if (!"file".equals(matcher.group(1)) && matcher.group(4) != null) {
                    this.withPath(matcher.group(7));
                    if (matcher.group(5) != null) {
                        this.withHostnamePort(matcher.group(4), Integer.parseInt(matcher.group(5)));
                    } else {
                        this.withHostname(matcher.group(4)).withoutHostnamePort();
                    }
                } else {
                    this.withPath(matcher.group(4) + "/" + matcher.group(7));
                }
                return this;
            }
            matcher = RELATIVE_SCP_URI.matcher(uri);
            if (matcher.matches()) {
                return this.withScheme("ssh").withPath(matcher.group(4)).withHostnamePort(matcher.group(3), 22);
            }
            matcher = ABSOLUTE_SCP_URI.matcher(uri);
            if (matcher.matches()) {
                return this.withScheme("ssh").withPath(matcher.group(4)).withHostnamePort(matcher.group(3), 22);
            }
            matcher = LOCAL_FILE.matcher(uri);
            if (matcher.matches()) {
                return this.withScheme("file").withPath(matcher.group(2)).withoutHostname().withoutHostnamePort();
            }
        }
        return this.withoutScheme().withoutPath().withoutHostname().withoutHostnamePort();
    }

    @NonNull
    public GitURIRequirementsBuilder withoutScheme() {
        this.requirements.removeIf(r -> r instanceof SchemeRequirement);
        return this;
    }

    @NonNull
    public GitURIRequirementsBuilder withoutPath() {
        this.requirements.removeIf(r -> r instanceof PathRequirement);
        return this;
    }

    @NonNull
    public GitURIRequirementsBuilder withoutHostname() {
        this.requirements.removeIf(r -> r instanceof HostnameRequirement);
        return this;
    }

    @NonNull
    public GitURIRequirementsBuilder withoutHostnamePort() {
        this.requirements.removeIf(r -> r instanceof HostnamePortRequirement);
        return this;
    }

    @NonNull
    public GitURIRequirementsBuilder withScheme(@CheckForNull String scheme) {
        this.withoutScheme();
        if (scheme != null) {
            this.requirements.add((DomainRequirement)new SchemeRequirement(scheme));
        }
        return this;
    }

    @NonNull
    public GitURIRequirementsBuilder withPath(@CheckForNull String path) {
        this.withoutPath();
        if (path != null) {
            this.requirements.add((DomainRequirement)new PathRequirement(path));
        }
        return this;
    }

    @NonNull
    public GitURIRequirementsBuilder withHostname(@CheckForNull String hostname) {
        return this.withHostnamePort(hostname, -1);
    }

    @NonNull
    public GitURIRequirementsBuilder withHostnamePort(@CheckForNull String hostname, int port) {
        this.withoutHostname();
        this.withoutHostnamePort();
        if (hostname != null) {
            this.requirements.add((DomainRequirement)new HostnameRequirement(hostname));
            if (port != -1) {
                this.requirements.add((DomainRequirement)new HostnamePortRequirement(hostname, port));
            }
        }
        return this;
    }

    @NonNull
    public List<DomainRequirement> build() {
        return new ArrayList<DomainRequirement>(this.requirements);
    }
}

