/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitLockFailedException;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.AddNoteCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.ShowNoteCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.InitCommand;
import org.jenkinsci.plugins.gitclient.JGitProgressMonitor;
import org.jenkinsci.plugins.gitclient.LegacyCompatibleGitAPIImpl;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.PushCommand;
import org.jenkinsci.plugins.gitclient.RevListCommand;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;
import org.jenkinsci.plugins.gitclient.trilead.TrileadSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGitAPIImpl
extends LegacyCompatibleGitAPIImpl {
    private final TaskListener listener;
    private PersonIdent author;
    private PersonIdent committer;
    private CredentialsProvider provider;

    JGitAPIImpl(File workspace, TaskListener listener) {
        super(workspace);
        this.listener = listener;
        SshSessionFactory.setInstance((SshSessionFactory)new TrileadSessionFactory());
    }

    @Override
    public void clearCredentials() {
        this.asSmartCredentialsProvider().clearCredentials();
    }

    @Override
    public void addCredentials(String url, StandardCredentials credentials) {
        this.asSmartCredentialsProvider().addCredentials(url, credentials);
    }

    @Override
    public void addDefaultCredentials(StandardCredentials credentials) {
        this.asSmartCredentialsProvider().addDefaultCredentials(credentials);
    }

    private synchronized SmartCredentialsProvider asSmartCredentialsProvider() {
        if (!(this.provider instanceof SmartCredentialsProvider)) {
            this.provider = new SmartCredentialsProvider(this.listener);
        }
        return (SmartCredentialsProvider)this.provider;
    }

    public synchronized void setCredentialsProvider(CredentialsProvider prov) {
        this.provider = prov;
    }

    private synchronized CredentialsProvider getProvider() {
        return this.provider;
    }

    @Override
    public GitClient subGit(String subdir) {
        return new JGitAPIImpl(new File(this.workspace, subdir), this.listener);
    }

    @Override
    public void setAuthor(String name, String email) throws GitException {
        this.author = new PersonIdent(name, email);
    }

    @Override
    public void setCommitter(String name, String email) throws GitException {
        this.committer = new PersonIdent(name, email);
    }

    @Override
    public void init() throws GitException, InterruptedException {
        this.init_().workspace(this.workspace.getAbsolutePath()).execute();
    }

    private void doInit(String workspace, boolean bare) throws GitException {
        try {
            Git.init().setBare(bare).setDirectory(new File(workspace)).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public CheckoutCommand checkout() {
        return new CheckoutCommand(){
            public String ref;
            public String branch;
            public boolean deleteBranch;
            public List<String> sparseCheckoutPaths = Collections.emptyList();

            @Override
            public CheckoutCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            @Override
            public CheckoutCommand branch(String branch) {
                this.branch = branch;
                return this;
            }

            @Override
            public CheckoutCommand deleteBranchIfExist(boolean deleteBranch) {
                this.deleteBranch = deleteBranch;
                return this;
            }

            @Override
            public CheckoutCommand sparseCheckoutPaths(List<String> sparseCheckoutPaths) {
                this.sparseCheckoutPaths = sparseCheckoutPaths == null ? Collections.emptyList() : sparseCheckoutPaths;
                return this;
            }

            @Override
            public CheckoutCommand timeout(Integer timeout) {
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                if (!this.sparseCheckoutPaths.isEmpty()) {
                    JGitAPIImpl.this.listener.getLogger().println("[ERROR] JGit doesn't support sparse checkout.");
                    throw new UnsupportedOperationException("not implemented yet");
                }
                if (this.branch == null) {
                    JGitAPIImpl.this.doCheckout(this.ref);
                } else if (this.deleteBranch) {
                    JGitAPIImpl.this.doCheckoutBranch(this.branch, this.ref);
                } else {
                    JGitAPIImpl.this.doCheckout(this.ref, this.branch);
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCheckout(String ref) throws GitException {
        Object var9_4;
        boolean retried = false;
        Repository repo = null;
        try {
            while (true) {
                try {
                    repo = this.getRepository();
                    this.git(repo).checkout().setName(ref).setForce(true).call();
                    var9_4 = null;
                    if (repo == null) return;
                }
                catch (CheckoutConflictException e) {
                    if (repo != null) {
                        repo.close();
                        repo = null;
                    }
                    if (retried) {
                        throw new GitException("Could not checkout " + ref, e);
                    }
                    retried = true;
                    repo = this.getRepository();
                    for (String path : e.getConflictingPaths()) {
                        File conflict = new File(repo.getWorkTree(), path);
                        if (conflict.delete() || !conflict.exists()) continue;
                        this.listener.getLogger().println("[WARNING] conflicting path " + conflict + " not deleted");
                    }
                    var9_4 = null;
                    if (repo == null) continue;
                    repo.close();
                    continue;
                }
                catch (GitAPIException e) {
                    throw new GitException("Could not checkout " + ref, e);
                }
                catch (JGitInternalException e) {
                    if (Pattern.matches("Cannot lock.+", e.getMessage())) {
                        throw new GitLockFailedException("Could not lock repository. Please try again", e);
                    }
                    throw e;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            var9_4 = null;
            if (repo != null) {
                repo.close();
            }
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCheckout(String ref, String branch) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                if (ref == null) {
                    ref = repo.resolve("HEAD").name();
                }
                this.git(repo).checkout().setName(branch).setCreateBranch(true).setForce(true).setStartPoint(ref).call();
            }
            catch (IOException e) {
                throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
            }
            catch (GitAPIException e) {
                throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
            }
            Object var6_4 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCheckoutBranch(String branch, String ref) throws GitException {
        Repository repo = null;
        try {
            block9: {
                try {
                    repo = this.getRepository();
                    RefUpdate refUpdate = branch == null ? repo.updateRef("HEAD", true) : repo.updateRef("refs/heads/" + branch);
                    refUpdate.setNewObjectId((AnyObjectId)repo.resolve(ref));
                    switch (refUpdate.forceUpdate()) {
                        case NOT_ATTEMPTED: 
                        case LOCK_FAILURE: 
                        case REJECTED: 
                        case REJECTED_CURRENT_BRANCH: 
                        case IO_FAILURE: 
                        case RENAMED: {
                            String string;
                            StringBuilder stringBuilder = new StringBuilder().append("Could not update ");
                            if (branch != null) {
                                string = branch;
                                throw new GitException(stringBuilder.append(string).append(" to ").append(ref).toString());
                            }
                            string = "";
                            throw new GitException(stringBuilder.append(string).append(" to ").append(ref).toString());
                        }
                    }
                    if (branch == null) break block9;
                    this.doCheckout(branch);
                }
                catch (IOException e) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("Could not checkout ");
                    if (branch != null) {
                        string = branch;
                        throw new GitException(stringBuilder.append(string).append(" with start point ").append(ref).toString(), e);
                    }
                    string = "";
                    throw new GitException(stringBuilder.append(string).append(" with start point ").append(ref).toString(), e);
                }
            }
            Object var6_6 = null;
            if (repo == null) return;
            repo.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(String filePattern) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).add().addFilepattern(filePattern).call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var5_3 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    private Git git(Repository repo) {
        return Git.wrap((Repository)repo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(String message) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                CommitCommand cmd = this.git(repo).commit().setMessage(message);
                if (this.author != null) {
                    cmd.setAuthor(this.author);
                }
                if (this.committer != null) {
                    cmd.setCommitter(new PersonIdent(this.committer, new Date()));
                }
                cmd.call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var5_5 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void branch(String name) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).branchCreate().setName(name).call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var5_3 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteBranch(String name) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).branchDelete().setForce(true).setBranchNames(new String[]{name}).call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var5_3 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    public Set<Branch> getBranches() throws GitException {
        HashSet<Branch> hashSet;
        block5: {
            Repository repo = null;
            try {
                repo = this.getRepository();
                List refs = this.git(repo).branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
                HashSet<Branch> branches = new HashSet<Branch>(refs.size());
                for (Ref ref : refs) {
                    branches.add(new Branch(ref));
                }
                hashSet = branches;
                Object var7_7 = null;
                if (repo == null) break block5;
            }
            catch (GitAPIException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var7_8 = null;
                        if (repo == null) break block6;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            repo.close();
        }
        return hashSet;
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException {
        HashSet<Branch> hashSet;
        block5: {
            Repository repo = null;
            try {
                repo = this.getRepository();
                List refs = this.git(repo).branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                HashSet<Branch> branches = new HashSet<Branch>(refs.size());
                for (Ref ref : refs) {
                    branches.add(new Branch(ref));
                }
                hashSet = branches;
                Object var7_7 = null;
                if (repo == null) break block5;
            }
            catch (GitAPIException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var7_8 = null;
                        if (repo == null) break block6;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            repo.close();
        }
        return hashSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tag(String name, String message) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).tag().setName(name).setMessage(message).setForceUpdate(true).call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var6_4 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    public boolean tagExists(String tagName) throws GitException {
        boolean bl;
        block4: {
            Repository repo = null;
            try {
                repo = this.getRepository();
                Ref tag = repo.getRefDatabase().getRef("refs/tags/" + tagName);
                bl = tag != null;
                Object var6_6 = null;
                if (repo == null) break block4;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var6_7 = null;
                        if (repo == null) break block5;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            repo.close();
        }
        return bl;
    }

    @Override
    public FetchCommand fetch_() {
        return new FetchCommand(){
            public URIish url;
            public List<RefSpec> refspecs;

            @Override
            public FetchCommand from(URIish remote, List<RefSpec> refspecs) {
                this.url = remote;
                this.refspecs = refspecs;
                return this;
            }

            @Override
            public FetchCommand prune() {
                throw new UnsupportedOperationException("JGit don't (yet) support pruning during fetch");
            }

            @Override
            public FetchCommand shallow(boolean shallow) {
                throw new UnsupportedOperationException("JGit don't (yet) support fetch --depth");
            }

            @Override
            public FetchCommand timeout(Integer timeout) {
                return this;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() throws GitException, InterruptedException {
                Repository repo;
                block9: {
                    repo = null;
                    org.eclipse.jgit.api.FetchCommand fetch = null;
                    try {
                        try {
                            repo = JGitAPIImpl.this.getRepository();
                            fetch = JGitAPIImpl.this.git(repo).fetch().setTagOpt(TagOpt.FETCH_TAGS);
                            fetch.setRemote(this.url.toString());
                            fetch.setCredentialsProvider(JGitAPIImpl.this.getProvider());
                            ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
                            refSpecs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
                            if (this.refspecs != null) {
                                for (RefSpec rs : this.refspecs) {
                                    if (rs == null) continue;
                                    refSpecs.add(rs);
                                }
                            }
                            fetch.setRefSpecs(refSpecs);
                            fetch.call();
                        }
                        catch (GitAPIException e) {
                            throw new GitException(e);
                        }
                        Object var7_7 = null;
                        if (fetch == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (fetch != null && fetch.getRepository() != null) {
                            fetch.getRepository().close();
                        }
                        if (repo == null) throw throwable;
                        repo.close();
                        throw throwable;
                    }
                    if (fetch.getRepository() != null) {
                        fetch.getRepository().close();
                    }
                }
                if (repo == null) return;
                repo.close();
            }
        };
    }

    @Override
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        this.fetch_().from(url, refspecs).execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                org.eclipse.jgit.api.FetchCommand fetch = this.git(repo).fetch().setTagOpt(TagOpt.FETCH_TAGS);
                if (remoteName != null) {
                    fetch.setRemote(remoteName);
                }
                fetch.setCredentialsProvider(this.getProvider());
                ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
                refSpecs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
                if (refspec != null && refspec.length > 0) {
                    for (RefSpec rs : refspec) {
                        if (rs == null) continue;
                        refSpecs.add(rs);
                    }
                }
                fetch.setRefSpecs(refSpecs);
                fetch.call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var11_11 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    public void fetch(String remoteName, RefSpec refspec) throws GitException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void ref(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                RefUpdate refUpdate = repo.updateRef(refName);
                refUpdate.setNewObjectId((AnyObjectId)repo.getRef("HEAD").getObjectId());
                switch (refUpdate.forceUpdate()) {
                    case NOT_ATTEMPTED: 
                    case LOCK_FAILURE: 
                    case REJECTED: 
                    case REJECTED_CURRENT_BRANCH: 
                    case IO_FAILURE: 
                    case RENAMED: {
                        throw new GitException("Could not update " + refName + " to HEAD");
                    }
                }
            }
            catch (IOException e) {
                throw new GitException("Could not update " + refName + " to HEAD", e);
            }
            Object var5_5 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    public boolean refExists(String refName) throws GitException, InterruptedException {
        boolean bl;
        block4: {
            refName = refName.replace(' ', '_');
            Repository repo = null;
            try {
                repo = this.getRepository();
                Ref ref = repo.getRefDatabase().getRef(refName);
                bl = ref != null;
                Object var6_6 = null;
                if (repo == null) break block4;
            }
            catch (IOException e) {
                try {
                    throw new GitException("Error checking ref " + refName, e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var6_7 = null;
                        if (repo == null) break block5;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            repo.close();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteRef(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                RefUpdate refUpdate = repo.updateRef(refName);
                refUpdate.setNewObjectId((AnyObjectId)repo.getRef("HEAD").getObjectId());
                refUpdate.setForceUpdate(true);
                switch (refUpdate.delete()) {
                    case NOT_ATTEMPTED: 
                    case LOCK_FAILURE: 
                    case REJECTED: 
                    case REJECTED_CURRENT_BRANCH: 
                    case IO_FAILURE: 
                    case RENAMED: {
                        throw new GitException("Could not delete " + refName);
                    }
                }
            }
            catch (IOException e) {
                throw new GitException("Could not delete " + refName, e);
            }
            Object var5_5 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    public Set<String> getRefNames(String refPrefix) throws GitException, InterruptedException {
        HashSet<String> hashSet;
        block5: {
            refPrefix = refPrefix.isEmpty() ? "" : refPrefix.replace(' ', '_');
            Repository repo = null;
            try {
                repo = this.getRepository();
                Map refList = repo.getRefDatabase().getRefs(refPrefix);
                HashSet<String> refs = new HashSet<String>(refList.size());
                for (Ref ref : refList.values()) {
                    refs.add(ref.getName());
                }
                hashSet = refs;
                Object var8_8 = null;
                if (repo == null) break block5;
            }
            catch (IOException e) {
                try {
                    throw new GitException("Error retrieving refs with prefix " + refPrefix, e);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var8_9 = null;
                        if (repo == null) break block6;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            repo.close();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ObjectId> getHeadRev(String url) throws GitException, InterruptedException {
        HashMap<String, ObjectId> heads = new HashMap<String, ObjectId>();
        try {
            Repository repo = this.openDummyRepository();
            Transport tn = Transport.open((Repository)repo, (URIish)new URIish(url));
            tn.setCredentialsProvider(this.getProvider());
            FetchConnection c = tn.openFetch();
            try {
                for (Ref r : c.getRefs()) {
                    heads.put(r.getName(), r.getPeeledObjectId() != null ? r.getPeeledObjectId() : r.getObjectId());
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                c.close();
                tn.close();
                repo.close();
                throw throwable;
            }
            c.close();
            tn.close();
            repo.close();
            {
            }
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (URISyntaxException e) {
            throw new GitException(e);
        }
        return heads;
    }

    private String createRefRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder();
        if (glob.startsWith("refs/")) {
            out.append("^");
        } else {
            out.append("^.*/");
        }
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectId getHeadRev(String remoteRepoUrl, String branchSpec) throws GitException {
        try {
            FetchConnection c;
            Transport tn;
            Repository repo;
            block8: {
                ObjectId objectId;
                block7: {
                    String branchName = this.extractBranchNameFromBranchSpec(branchSpec);
                    String regexBranch = this.createRefRegexFromGlob(branchName);
                    repo = this.openDummyRepository();
                    tn = Transport.open((Repository)repo, (URIish)new URIish(remoteRepoUrl));
                    tn.setCredentialsProvider(this.getProvider());
                    c = tn.openFetch();
                    try {
                        for (Ref r : c.getRefs()) {
                            if (!r.getName().matches(regexBranch)) continue;
                            objectId = r.getPeeledObjectId() != null ? r.getPeeledObjectId() : r.getObjectId();
                            Object var12_14 = null;
                            break block7;
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        c.close();
                        tn.close();
                        repo.close();
                        throw throwable;
                    }
                }
                c.close();
                tn.close();
                repo.close();
                return objectId;
            }
            Object var12_15 = null;
            c.close();
            tn.close();
            repo.close();
            return null;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (URISyntaxException e) {
            throw new GitException(e);
        }
        catch (IllegalStateException e) {
            throw new GitException(e);
        }
    }

    private Repository openDummyRepository() throws IOException {
        final File tempDir = Util.createTempDir();
        return new FileRepository(tempDir){

            public void close() {
                super.close();
                try {
                    Util.deleteRecursive((File)tempDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public String getRemoteUrl(String name) throws GitException {
        Repository repo = this.getRepository();
        String url = repo.getConfig().getString("remote", name, "url");
        repo.close();
        return url;
    }

    @Override
    @NonNull
    public Repository getRepository() throws GitException {
        try {
            return ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(this.workspace)).build();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public FilePath getWorkTree() {
        return new FilePath(this.workspace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRemoteUrl(String name, String url) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                StoredConfig config = repo.getConfig();
                config.setString("remote", name, "url", url);
                config.save();
            }
            catch (IOException e) {
                throw new GitException(e);
            }
            Object var6_6 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addRemoteUrl(String name, String url) throws GitException, InterruptedException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                StoredConfig config = repo.getConfig();
                ArrayList<String> urls = new ArrayList<String>();
                urls.addAll(Arrays.asList(config.getStringList("remote", name, "url")));
                urls.add(url);
                config.setStringList("remote", name, "url", urls);
                config.save();
            }
            catch (IOException e) {
                throw new GitException(e);
            }
            Object var7_7 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addNote(String note, String namespace) throws GitException {
        ObjectReader or;
        Repository repo;
        block9: {
            repo = null;
            RevWalk walk = null;
            or = null;
            try {
                try {
                    repo = this.getRepository();
                    ObjectId head = repo.resolve("HEAD");
                    AddNoteCommand cmd = this.git(repo).notesAdd();
                    cmd.setMessage(this.normalizeNote(note));
                    cmd.setNotesRef(this.qualifyNotesNamespace(namespace));
                    or = repo.newObjectReader();
                    walk = new RevWalk(or);
                    cmd.setObjectId(walk.parseAny((AnyObjectId)head));
                    cmd.call();
                }
                catch (GitAPIException e) {
                    throw new GitException(e);
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
                Object var9_10 = null;
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (walk != null) {
                    walk.dispose();
                }
                if (or != null) {
                    or.release();
                }
                if (repo == null) throw throwable;
                repo.close();
                throw throwable;
            }
            walk.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo == null) return;
        repo.close();
    }

    private String normalizeNote(String note) {
        note = note.trim();
        note = note.replaceAll("\r\n", "\n").replaceAll("\n{3,}", "\n\n");
        note = note + "\n";
        return note;
    }

    private String qualifyNotesNamespace(String namespace) {
        if (!namespace.startsWith("refs/")) {
            namespace = "refs/notes/" + namespace;
        }
        return namespace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void appendNote(String note, String namespace) throws GitException {
        ObjectReader or;
        Repository repo;
        block12: {
            repo = null;
            RevWalk walk = null;
            or = null;
            try {
                try {
                    repo = this.getRepository();
                    ObjectId head = repo.resolve("HEAD");
                    ShowNoteCommand cmd = this.git(repo).notesShow();
                    cmd.setNotesRef(this.qualifyNotesNamespace(namespace));
                    or = repo.newObjectReader();
                    walk = new RevWalk(or);
                    cmd.setObjectId(walk.parseAny((AnyObjectId)head));
                    Note n = cmd.call();
                    if (n == null) {
                        this.addNote(note, namespace);
                    } else {
                        ObjectLoader ol = or.open((AnyObjectId)n.getData());
                        StringWriter sw = new StringWriter();
                        IOUtils.copy((Reader)new InputStreamReader((InputStream)ol.openStream(), Constants.CHARSET), (Writer)sw);
                        sw.write("\n");
                        this.addNote(sw.toString() + this.normalizeNote(note), namespace);
                    }
                }
                catch (GitAPIException e) {
                    throw new GitException(e);
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
                Object var12_13 = null;
                if (walk == null) break block12;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (walk != null) {
                    walk.dispose();
                }
                if (or != null) {
                    or.release();
                }
                if (repo == null) throw throwable;
                repo.close();
                throw throwable;
            }
            walk.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo == null) return;
        repo.close();
    }

    @Override
    public ChangelogCommand changelog() {
        return new ChangelogCommand(){
            Repository repo;
            ObjectReader or;
            RevWalk walk;
            Writer out;
            boolean hasIncludedRev;
            {
                this.repo = JGitAPIImpl.this.getRepository();
                this.or = this.repo.newObjectReader();
                this.walk = new RevWalk(this.or);
                this.hasIncludedRev = false;
            }

            public ChangelogCommand excludes(String rev) {
                try {
                    return this.excludes(this.repo.resolve(rev));
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand excludes(ObjectId rev) {
                try {
                    this.walk.markUninteresting(this.walk.lookupCommit((AnyObjectId)rev));
                    return this;
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand includes(String rev) {
                try {
                    this.includes(this.repo.resolve(rev));
                    this.hasIncludedRev = true;
                    return this;
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand includes(ObjectId rev) {
                try {
                    this.walk.markStart(this.walk.lookupCommit((AnyObjectId)rev));
                    this.hasIncludedRev = true;
                    return this;
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand to(Writer w) {
                this.out = w;
                return this;
            }

            public ChangelogCommand max(int n) {
                this.walk.setRevFilter(MaxCountRevFilter.create((int)n));
                return this;
            }

            private void closeResources() {
                this.walk.dispose();
                this.or.release();
                this.repo.close();
            }

            public void abort() {
                this.closeResources();
            }

            public void execute() throws GitException, InterruptedException {
                PrintWriter pw = new PrintWriter(this.out, false);
                try {
                    try {
                        RawFormatter formatter = new RawFormatter();
                        if (!this.hasIncludedRev) {
                            this.includes("HEAD");
                        }
                        for (RevCommit commit : this.walk) {
                            if (commit.getParentCount() > 1) continue;
                            formatter.format(commit, null, pw);
                        }
                        Object var6_6 = null;
                        this.closeResources();
                        pw.flush();
                    }
                    catch (IOException e) {
                        throw new GitException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    this.closeResources();
                    pw.flush();
                    throw throwable;
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void clean() throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                Git git = this.git(repo);
                git.reset().setMode(ResetCommand.ResetType.HARD).call();
                git.clean().setCleanDirectories(true).setIgnore(false).call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var4_4 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    public CloneCommand clone_() {
        final org.eclipse.jgit.api.CloneCommand base = new org.eclipse.jgit.api.CloneCommand();
        base.setDirectory(this.workspace);
        base.setProgressMonitor((ProgressMonitor)new JGitProgressMonitor(this.listener));
        base.setCredentialsProvider(this.getProvider());
        return new CloneCommand(){

            public CloneCommand url(String url) {
                base.setURI(url);
                return this;
            }

            public CloneCommand repositoryName(String name) {
                base.setRemote(name);
                return this;
            }

            public CloneCommand shallow() {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support shallow clone. This flag is ignored");
                return this;
            }

            public CloneCommand shared() {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support shared flag. This flag is ignored");
                return this;
            }

            public CloneCommand reference(String reference) {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support reference repository. This flag is ignored.");
                return this;
            }

            public CloneCommand timeout(Integer timeout) {
                return this;
            }

            public CloneCommand noCheckout() {
                base.setNoCheckout(true);
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void execute() throws GitException, InterruptedException {
                try {
                    try {
                        if (JGitAPIImpl.this.workspace.exists()) {
                            Util.deleteContentsRecursive((File)JGitAPIImpl.this.workspace);
                        }
                        base.call();
                    }
                    catch (GitAPIException e) {
                        throw new GitException(e);
                    }
                    catch (IOException e) {
                        throw new GitException(e);
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    if (base.getRepository() == null) throw throwable;
                    base.getRepository().close();
                    throw throwable;
                }
                if (base.getRepository() == null) return;
                base.getRepository().close();
            }
        };
    }

    @Override
    public MergeCommand merge() {
        return new MergeCommand(){
            ObjectId rev;
            MergeStrategy strategy;

            public MergeCommand setRevisionToMerge(ObjectId rev) {
                this.rev = rev;
                return this;
            }

            public MergeCommand setStrategy(MergeCommand.Strategy strategy) {
                if (strategy != null && !strategy.toString().isEmpty() && strategy != MergeCommand.Strategy.DEFAULT) {
                    if (strategy == MergeCommand.Strategy.OURS) {
                        this.strategy = MergeStrategy.OURS;
                        return this;
                    }
                    if (strategy == MergeCommand.Strategy.RESOLVE) {
                        this.strategy = MergeStrategy.RESOLVE;
                        return this;
                    }
                    if (strategy == MergeCommand.Strategy.OCTOPUS) {
                        this.strategy = MergeStrategy.SIMPLE_TWO_WAY_IN_CORE;
                        return this;
                    }
                    JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't fully support merge strategies. This flag is ignored");
                }
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void execute() throws GitException, InterruptedException {
                Repository repo = null;
                try {
                    try {
                        repo = JGitAPIImpl.this.getRepository();
                        Git git = JGitAPIImpl.this.git(repo);
                        MergeResult mergeResult = this.strategy != null ? git.merge().setStrategy(this.strategy).include((AnyObjectId)this.rev).call() : git.merge().include((AnyObjectId)this.rev).call();
                        if (!mergeResult.getMergeStatus().isSuccessful()) {
                            git.reset().setMode(ResetCommand.ResetType.HARD).call();
                            throw new GitException("Failed to merge " + this.rev);
                        }
                        Object var5_5 = null;
                        if (repo == null) return;
                    }
                    catch (GitAPIException e) {
                        throw new GitException("Failed to merge " + this.rev, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (repo == null) throw throwable;
                    repo.close();
                    throw throwable;
                }
                repo.close();
            }
        };
    }

    @Override
    public InitCommand init_() {
        return new InitCommand(){
            public String workspace;
            public boolean bare;

            public InitCommand workspace(String workspace) {
                this.workspace = workspace;
                return this;
            }

            public InitCommand bare(boolean bare) {
                this.bare = bare;
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                JGitAPIImpl.this.doInit(this.workspace, this.bare);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteTag(String tagName) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).tagDelete().setTags(new String[]{tagName}).call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var5_3 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    public String getTagMessage(String tagName) throws GitException {
        String string;
        ObjectReader or;
        Repository repo;
        block8: {
            repo = null;
            or = null;
            RevWalk walk = null;
            try {
                repo = this.getRepository();
                or = repo.newObjectReader();
                walk = new RevWalk(or);
                string = walk.parseTag((AnyObjectId)repo.resolve(tagName)).getFullMessage().trim();
                Object var7_7 = null;
                if (walk == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var7_8 = null;
                        if (walk != null) {
                            walk.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) break block9;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            walk.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo != null) {
            repo.close();
        }
        return string;
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        ArrayList<IndexEntry> arrayList;
        ObjectReader or;
        Repository repo;
        block9: {
            repo = null;
            or = null;
            RevWalk w = null;
            try {
                ArrayList<IndexEntry> r = new ArrayList<IndexEntry>();
                repo = this.getRepository();
                or = repo.newObjectReader();
                w = new RevWalk(or);
                RevTree t = w.parseTree((AnyObjectId)repo.resolve(treeIsh));
                SubmoduleWalk walk = new SubmoduleWalk(repo);
                walk.setTree((AnyObjectId)t);
                walk.setRootTree((AnyObjectId)t);
                while (walk.next()) {
                    r.add(new IndexEntry(walk));
                }
                arrayList = r;
                Object var10_10 = null;
                if (w == null) break block9;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var10_11 = null;
                        if (w != null) {
                            w.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) break block10;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            w.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo != null) {
            repo.close();
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addSubmodule(String remoteURL, String subdir) throws GitException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).submoduleAdd().setPath(subdir).setURI(remoteURL).call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var6_4 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        HashSet<String> hashSet;
        if (tagPattern == null) {
            tagPattern = "*";
        }
        Repository repo = null;
        try {
            try {
                HashSet<String> tags = new HashSet<String>();
                FileNameMatcher matcher = new FileNameMatcher(tagPattern, Character.valueOf('/'));
                repo = this.getRepository();
                Map refList = repo.getRefDatabase().getRefs("refs/tags/");
                for (Ref ref : refList.values()) {
                    String name = ref.getName().substring("refs/tags/".length());
                    matcher.reset();
                    matcher.append(name);
                    if (!matcher.isMatch()) continue;
                    tags.add(name);
                }
                hashSet = tags;
                Object var10_11 = null;
                if (repo == null) return hashSet;
            }
            catch (IOException e) {
                throw new GitException(e);
            }
            catch (InvalidPatternException e) {
                throw new GitException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getRemoteTagNames(String tagPattern) throws GitException {
        HashSet<String> hashSet;
        if (tagPattern == null) {
            tagPattern = "*";
        }
        Repository repo = null;
        try {
            try {
                HashSet<String> tags = new HashSet<String>();
                FileNameMatcher matcher = new FileNameMatcher(tagPattern, Character.valueOf('/'));
                repo = this.getRepository();
                Map refList = repo.getRefDatabase().getRefs("refs/tags/");
                for (Ref ref : refList.values()) {
                    String name = ref.getName().substring("refs/tags/".length());
                    matcher.reset();
                    matcher.append(name);
                    if (!matcher.isMatch()) continue;
                    tags.add(name);
                }
                hashSet = tags;
                Object var10_11 = null;
                if (repo == null) return hashSet;
            }
            catch (IOException e) {
                throw new GitException(e);
            }
            catch (InvalidPatternException e) {
                throw new GitException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGitRepo() throws GitException {
        boolean bl;
        block4: {
            Repository repo = null;
            try {
                repo = this.getRepository();
                bl = repo.getObjectDatabase().exists();
                Object var5_4 = null;
                if (repo == null) break block4;
            }
            catch (GitException e) {
                boolean bl2;
                block5: {
                    try {
                        bl2 = false;
                        Object var5_5 = null;
                        if (repo == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var5_6 = null;
                            if (repo == null) break block6;
                            repo.close();
                        }
                        throw throwable;
                    }
                    repo.close();
                }
                return bl2;
            }
            repo.close();
        }
        return bl;
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws GitException {
        Repository repo = this.getRepository();
        boolean found = repo.hasObject((AnyObjectId)commit);
        repo.close();
        return found;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prune(RemoteConfig repository) throws GitException {
        Repository gitRepo = null;
        try {
            try {
                String remote = repository.getName();
                String prefix = "refs/remotes/" + remote + "/";
                Set<String> branches = this.listRemoteBranches(remote);
                gitRepo = this.getRepository();
                for (Ref r : new ArrayList(gitRepo.getAllRefs().values())) {
                    if (!r.getName().startsWith(prefix) || branches.contains(r.getName())) continue;
                    RefUpdate update = gitRepo.updateRef(r.getName());
                    update.setRefLogMessage("remote branch pruned", false);
                    update.setForceUpdate(true);
                    RefUpdate.Result res = update.delete();
                }
                Object var11_12 = null;
                if (gitRepo == null) return;
            }
            catch (URISyntaxException e) {
                throw new GitException(e);
            }
            catch (IOException e) {
                throw new GitException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (gitRepo == null) throw throwable;
            gitRepo.close();
            throw throwable;
        }
        gitRepo.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> listRemoteBranches(String remote) throws NotSupportedException, TransportException, URISyntaxException {
        Repository repo = this.getRepository();
        StoredConfig config = repo.getConfig();
        HashSet<String> branches = new HashSet<String>();
        Transport tn = Transport.open((Repository)repo, (URIish)new URIish(config.getString("remote", remote, "url")));
        tn.setCredentialsProvider(this.getProvider());
        FetchConnection c = tn.openFetch();
        try {
            for (Ref r : c.getRefs()) {
                if (!r.getName().startsWith("refs/heads/")) continue;
                branches.add("refs/remotes/" + remote + "/" + r.getName().substring("refs/heads/".length()));
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            repo.close();
            c.close();
            tn.close();
            throw throwable;
        }
        repo.close();
        c.close();
        tn.close();
        return branches;
    }

    @Override
    public PushCommand push() {
        return new PushCommand(){
            public URIish remote;
            public String refspec;
            public boolean force;

            public PushCommand to(URIish remote) {
                this.remote = remote;
                return this;
            }

            public PushCommand ref(String refspec) {
                this.refspec = refspec;
                return this;
            }

            public PushCommand force() {
                this.force = true;
                return this;
            }

            public PushCommand timeout(Integer timeout) {
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void execute() throws GitException, InterruptedException {
                RefSpec ref = this.refspec != null ? new RefSpec(this.refspec) : Transport.REFSPEC_PUSH_ALL;
                Repository repo = null;
                try {
                    try {
                        repo = JGitAPIImpl.this.getRepository();
                        Git g = JGitAPIImpl.this.git(repo);
                        StoredConfig config = g.getRepository().getConfig();
                        config.setString("remote", "org_jenkinsci_plugins_gitclient_JGitAPIImpl", "url", this.remote.toPrivateASCIIString());
                        ((org.eclipse.jgit.api.PushCommand)g.push().setRemote("org_jenkinsci_plugins_gitclient_JGitAPIImpl").setRefSpecs(new RefSpec[]{ref}).setProgressMonitor((ProgressMonitor)new JGitProgressMonitor(JGitAPIImpl.this.listener)).setCredentialsProvider(JGitAPIImpl.this.getProvider())).setForce(this.force).call();
                        config.unset("remote", "org_jenkinsci_plugins_gitclient_JGitAPIImpl", "url");
                    }
                    catch (GitAPIException e) {
                        throw new GitException(e);
                    }
                    Object var6_6 = null;
                    if (repo == null) return;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (repo == null) throw throwable;
                    repo.close();
                    throw throwable;
                }
                repo.close();
            }
        };
    }

    @Override
    public RevListCommand revList_() {
        return new RevListCommand(){
            public boolean all;
            public boolean firstParent;
            public String refspec;
            public List<ObjectId> out;

            @Override
            public RevListCommand all() {
                this.all = true;
                return this;
            }

            @Override
            public RevListCommand firstParent() {
                this.firstParent = true;
                return this;
            }

            @Override
            public RevListCommand to(List<ObjectId> revs) {
                this.out = revs;
                return this;
            }

            @Override
            public RevListCommand reference(String reference) {
                this.refspec = reference;
                return this;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() throws GitException, InterruptedException {
                ObjectReader or;
                Repository repo;
                block13: {
                    repo = null;
                    or = null;
                    RevWalk walk = null;
                    if (this.firstParent) {
                        throw new UnsupportedOperationException("not implemented yet");
                    }
                    try {
                        try {
                            repo = JGitAPIImpl.this.getRepository();
                            or = repo.newObjectReader();
                            walk = new RevWalk(or);
                            if (this.all) {
                                JGitAPIImpl.this.markAllRefs(walk);
                            } else if (this.refspec != null) {
                                walk.markStart(walk.parseCommit((AnyObjectId)repo.resolve(this.refspec)));
                            }
                            walk.setRetainBody(false);
                            walk.sort(RevSort.COMMIT_TIME_DESC);
                            for (RevCommit c : walk) {
                                this.out.add(c.copy());
                            }
                            Object var7_7 = null;
                            if (walk == null) break block13;
                        }
                        catch (IOException e) {
                            throw new GitException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (walk != null) {
                            walk.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) throw throwable;
                        repo.close();
                        throw throwable;
                    }
                    walk.dispose();
                }
                if (or != null) {
                    or.release();
                }
                if (repo == null) return;
                repo.close();
            }
        };
    }

    @Override
    public List<ObjectId> revListAll() throws GitException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.all();
        revListCommand.to(oidList);
        try {
            revListCommand.execute();
        }
        catch (InterruptedException e) {
            throw new GitException(e);
        }
        return oidList;
    }

    @Override
    public List<ObjectId> revList(String ref) throws GitException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.reference(ref);
        revListCommand.to(oidList);
        try {
            revListCommand.execute();
        }
        catch (InterruptedException e) {
            throw new GitException(e);
        }
        return oidList;
    }

    @Override
    public ObjectId revParse(String revName) throws GitException {
        ObjectId objectId;
        block5: {
            Repository repo = null;
            try {
                repo = this.getRepository();
                ObjectId id = repo.resolve(revName + "^{commit}");
                if (id == null) {
                    throw new GitException("Unknown git object " + revName);
                }
                objectId = id;
                Object var6_6 = null;
                if (repo == null) break block5;
            }
            catch (IOException e) {
                try {
                    throw new GitException("Failed to resolve git reference " + revName, e);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var6_7 = null;
                        if (repo == null) break block6;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            repo.close();
        }
        return objectId;
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException {
        ArrayList<String> arrayList;
        ObjectReader or;
        Repository repo;
        block14: {
            repo = null;
            or = null;
            RevWalk w = null;
            try {
                repo = this.getRepository();
                or = repo.newObjectReader();
                w = new RevWalk(or);
                w.markStart(w.parseCommit((AnyObjectId)to));
                if (from != null) {
                    w.markUninteresting(w.parseCommit((AnyObjectId)from));
                } else {
                    w.setRevFilter(MaxCountRevFilter.create((int)1));
                }
                ArrayList<String> r = new ArrayList<String>();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                RawFormatter f = new RawFormatter();
                for (RevCommit c : w) {
                    if (c.getParentCount() <= 1) {
                        f.format(c, null, pw);
                    } else {
                        for (RevCommit p : c.getParents()) {
                            f.format(c, p, pw);
                        }
                    }
                    pw.flush();
                    r.addAll(Arrays.asList(sw.toString().split("\n")));
                    sw.getBuffer().setLength(0);
                }
                arrayList = r;
                Object var17_17 = null;
                if (w == null) break block14;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block15: {
                        Object var17_18 = null;
                        if (w != null) {
                            w.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) break block15;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            w.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo != null) {
            repo.close();
        }
        return arrayList;
    }

    private Iterable<JGitAPIImpl> submodules() throws IOException {
        ArrayList<JGitAPIImpl> submodules = new ArrayList<JGitAPIImpl>();
        Repository repo = this.getRepository();
        SubmoduleWalk generator = SubmoduleWalk.forIndex((Repository)repo);
        while (generator.next()) {
            submodules.add(new JGitAPIImpl(generator.getDirectory(), this.listener));
        }
        repo.close();
        return submodules;
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException {
        try {
            for (JGitAPIImpl sub : this.submodules()) {
                sub.clean();
                if (!recursive) continue;
                sub.submoduleClean(true);
            }
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public SubmoduleUpdateCommand submoduleUpdate() {
        return new SubmoduleUpdateCommand(){
            boolean recursive = false;
            boolean remoteTracking = false;
            String ref = null;

            public SubmoduleUpdateCommand recursive(boolean recursive) {
                this.recursive = recursive;
                return this;
            }

            public SubmoduleUpdateCommand remoteTracking(boolean remoteTracking) {
                this.remoteTracking = remoteTracking;
                return this;
            }

            public SubmoduleUpdateCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            public SubmoduleUpdateCommand timeout(Integer timeout) {
                return this;
            }

            public SubmoduleUpdateCommand useBranch(String submodule, String branchname) {
                return this;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute() throws GitException, InterruptedException {
                Repository repo = null;
                if (this.remoteTracking) {
                    JGitAPIImpl.this.listener.getLogger().println("[ERROR] JGit doesn't support remoteTracking submodules yet.");
                    throw new UnsupportedOperationException("not implemented yet");
                }
                if (this.ref != null && !this.ref.isEmpty()) {
                    JGitAPIImpl.this.listener.getLogger().println("[ERROR] JGit doesn't support submodule update --reference yet.");
                    throw new UnsupportedOperationException("not implemented yet");
                }
                try {
                    try {
                        repo = JGitAPIImpl.this.getRepository();
                        JGitAPIImpl.this.git(repo).submoduleUpdate().call();
                        if (this.recursive) {
                            for (JGitAPIImpl sub : JGitAPIImpl.this.submodules()) {
                                sub.submoduleUpdate(this.recursive);
                            }
                        }
                        Object var5_6 = null;
                        if (repo == null) return;
                    }
                    catch (IOException e) {
                        throw new GitException(e);
                    }
                    catch (GitAPIException e) {
                        throw new GitException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (repo == null) throw throwable;
                    repo.close();
                    throw throwable;
                }
                repo.close();
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void merge(String refSpec) throws GitException, InterruptedException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.merge(repo.resolve(refSpec));
            }
            catch (IOException e) {
                throw new GitException(e);
            }
            Object var5_3 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    @Deprecated
    public void push(RemoteConfig repository, String refspec) throws GitException, InterruptedException {
        this.push(repository.getName(), refspec);
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec) throws GitException, InterruptedException {
        ArrayList<Branch> arrayList;
        ObjectReader or;
        Repository repo;
        block16: {
            repo = null;
            or = null;
            RevWalk walk = null;
            try {
                repo = this.getRepository();
                or = repo.newObjectReader();
                walk = new RevWalk(or);
                walk.setRetainBody(false);
                walk.sort(RevSort.TOPO);
                ObjectId id = repo.resolve(revspec);
                if (id == null) {
                    throw new GitException("Invalid commit: " + revspec);
                }
                RevCommit target = walk.parseCommit((AnyObjectId)id);
                ArrayList<RevFlag> flags = new ArrayList<RevFlag>(24);
                for (int i = 0; i < 24; ++i) {
                    flags.add(walk.newFlag("branch" + i));
                }
                walk.carry(flags);
                ArrayList<Branch> result = new ArrayList<Branch>();
                List<Ref> branches = this.getAllBranchRefs();
                while (!branches.isEmpty()) {
                    RevCommit c;
                    List<Ref> batch = branches.subList(0, Math.min(flags.size(), branches.size()));
                    branches = branches.subList(batch.size(), branches.size());
                    walk.reset();
                    int idx = 0;
                    for (Ref r : batch) {
                        RevCommit c2 = walk.parseCommit((AnyObjectId)r.getObjectId());
                        walk.markStart(c2);
                        c2.add((RevFlag)flags.get(idx));
                        ++idx;
                    }
                    for (RevCommit p : target.getParents()) {
                        walk.markUninteresting(p);
                    }
                    Iterator<Ref> i$ = walk.iterator();
                    while (i$.hasNext() && !(c = (RevCommit)i$.next()).equals((AnyObjectId)target)) {
                    }
                    idx = 0;
                    for (Ref r : batch) {
                        if (target.has((RevFlag)flags.get(idx))) {
                            result.add(new Branch(r));
                        }
                        ++idx;
                    }
                }
                arrayList = result;
                Object var17_22 = null;
                if (walk == null) break block16;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var17_23 = null;
                        if (walk != null) {
                            walk.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) break block17;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            walk.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo != null) {
            repo.close();
        }
        return arrayList;
    }

    private List<Ref> getAllBranchRefs() {
        ArrayList<Ref> branches = new ArrayList<Ref>();
        Repository repo = this.getRepository();
        for (Ref r : repo.getAllRefs().values()) {
            if (!r.getName().startsWith("refs/heads/")) continue;
            branches.add(r);
        }
        repo.close();
        return branches;
    }

    @Override
    @Deprecated
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) throws InterruptedException {
        ObjectId objectId;
        ObjectReader or;
        Repository repo;
        block13: {
            RevCommit base;
            RevWalk walk;
            block11: {
                ObjectId objectId2;
                block12: {
                    repo = null;
                    or = null;
                    walk = null;
                    repo = this.getRepository();
                    or = repo.newObjectReader();
                    walk = new RevWalk(or);
                    walk.setRetainBody(false);
                    walk.setRevFilter(RevFilter.MERGE_BASE);
                    walk.markStart(walk.parseCommit((AnyObjectId)id1));
                    walk.markStart(walk.parseCommit((AnyObjectId)id2));
                    base = walk.next();
                    if (base != null) break block11;
                    objectId2 = null;
                    Object var9_10 = null;
                    if (walk == null) break block12;
                    walk.dispose();
                }
                if (or != null) {
                    or.release();
                }
                if (repo != null) {
                    repo.close();
                }
                return objectId2;
            }
            try {
                objectId = base.getId();
                Object var9_11 = null;
                if (walk == null) break block13;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var9_12 = null;
                        if (walk != null) {
                            walk.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) break block14;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            walk.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo != null) {
            repo.close();
        }
        return objectId;
    }

    @Override
    @Deprecated
    public String getAllLogEntries(String branch) throws InterruptedException {
        String string;
        ObjectReader or;
        Repository repo;
        block9: {
            repo = null;
            or = null;
            RevWalk walk = null;
            try {
                StringBuilder w = new StringBuilder();
                repo = this.getRepository();
                or = repo.newObjectReader();
                walk = new RevWalk(or);
                this.markAllRefs(walk);
                walk.setRetainBody(false);
                for (RevCommit c : walk) {
                    w.append('\'').append(c.name()).append('#').append(c.getCommitTime()).append("'\n");
                }
                string = w.toString().trim();
                Object var9_9 = null;
                if (walk == null) break block9;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var9_10 = null;
                        if (walk != null) {
                            walk.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) break block10;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            walk.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo != null) {
            repo.close();
        }
        return string;
    }

    private void markAllRefs(RevWalk walk) throws IOException {
        this.markRefs(walk, (Predicate<Ref>)Predicates.alwaysTrue());
    }

    private void markRefs(RevWalk walk, Predicate<Ref> filter) throws IOException {
        Repository repo = this.getRepository();
        for (Ref r : repo.getAllRefs().values()) {
            if (!filter.apply((Object)r)) continue;
            RevCommit c = walk.parseCommit((AnyObjectId)r.getObjectId());
            walk.markStart(c);
        }
        repo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void submoduleInit() throws GitException, InterruptedException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).submoduleInit().call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var4_2 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void submoduleSync() throws GitException, InterruptedException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                this.git(repo).submoduleSync().call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var4_2 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    @Deprecated
    public String getSubmoduleUrl(String name) throws GitException, InterruptedException {
        Repository repo = this.getRepository();
        String v = repo.getConfig().getString("submodule", name, "url");
        repo.close();
        if (v == null) {
            throw new GitException("No such submodule: " + name);
        }
        return v.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void setSubmoduleUrl(String name, String url) throws GitException, InterruptedException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                StoredConfig config = repo.getConfig();
                config.setString("submodule", name, "url", url);
                config.save();
            }
            catch (IOException e) {
                throw new GitException(e);
            }
            Object var6_6 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    @Deprecated
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    @Deprecated
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String describe(String tip) throws GitException, InterruptedException {
        String string;
        block17: {
            ObjectId tipId;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Candidate {
                final RevCommit commit;
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit, Ref tag) {
                    this.commit = commit;
                    this.tag = tag;
                    this.flag = w.newFlag(tag.getName());
                    allFlags.add(this.flag);
                    w.carry(this.flag);
                    commit.add(this.flag);
                    commit.carry(this.flag);
                }

                public boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                public String describe(ObjectId tip) throws IOException {
                    return String.format("%s-%d-g%s", this.tag.getName().substring("refs/tags/".length()), this.depth, or.abbreviate((AnyObjectId)tip).name());
                }
            }
            ArrayList<Candidate> candidates;
            RevFlagSet allFlags;
            HashMap<ObjectId, Ref> tags;
            RevWalk w;
            ObjectReader or;
            Repository repo;
            block15: {
                String string2;
                block16: {
                    repo = null;
                    repo = this.getRepository();
                    or = repo.newObjectReader();
                    w = new RevWalk(or);
                    w.setRetainBody(false);
                    tags = new HashMap<ObjectId, Ref>();
                    for (Ref r : repo.getTags().values()) {
                        ObjectId key = repo.peel(r).getPeeledObjectId();
                        if (key == null) {
                            key = r.getObjectId();
                        }
                        tags.put(key, r);
                    }
                    allFlags = new RevFlagSet();
                    candidates = new ArrayList<Candidate>();
                    tipId = repo.resolve(tip);
                    Ref lucky = (Ref)tags.get(tipId);
                    if (lucky == null) break block15;
                    string2 = lucky.getName().substring("refs/tags/".length());
                    Object var18_13 = null;
                    if (repo == null) break block16;
                    repo.close();
                }
                return string2;
            }
            try {
                RevCommit c;
                w.markStart(w.parseCommit((AnyObjectId)tipId));
                int maxCandidates = 10;
                int seen = 0;
                while ((c = w.next()) != null) {
                    Ref t;
                    if (!c.hasAny(allFlags) && (t = (Ref)tags.get(c)) != null) {
                        Candidate cd = new Candidate(c, t);
                        candidates.add(cd);
                        cd.depth = seen;
                    }
                    for (Candidate cd : candidates) {
                        if (cd.reaches(c)) continue;
                        ++cd.depth;
                    }
                    if (candidates.size() >= maxCandidates) break;
                    ++seen;
                }
                while ((c = w.next()) != null) {
                    if (c.hasAll(allFlags)) {
                        for (RevCommit p : c.getParents()) {
                            p.add(RevFlag.SEEN);
                        }
                        continue;
                    }
                    for (Candidate cd : candidates) {
                        if (cd.reaches(c)) continue;
                        ++cd.depth;
                    }
                }
                if (candidates.isEmpty()) {
                    throw new GitException("No tags can describe " + tip);
                }
                Collections.sort(candidates, new Comparator<Candidate>(){

                    @Override
                    public int compare(Candidate o1, Candidate o2) {
                        return o1.depth - o2.depth;
                    }
                });
                string = ((Candidate)candidates.get(0)).describe(tipId);
                Object var18_14 = null;
                if (repo == null) break block17;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block18: {
                        Object var18_15 = null;
                        if (repo == null) break block18;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            repo.close();
        }
        return string;
    }

    @Override
    @Deprecated
    public List<IndexEntry> lsTree(String treeIsh, boolean recursive) throws GitException, InterruptedException {
        ArrayList<IndexEntry> arrayList;
        ObjectReader or;
        Repository repo;
        block9: {
            repo = null;
            or = null;
            RevWalk w = null;
            try {
                repo = this.getRepository();
                or = repo.newObjectReader();
                w = new RevWalk(or);
                TreeWalk tree = new TreeWalk(or);
                tree.addTree((AnyObjectId)w.parseTree((AnyObjectId)repo.resolve(treeIsh)));
                tree.setRecursive(recursive);
                ArrayList<IndexEntry> r = new ArrayList<IndexEntry>();
                while (tree.next()) {
                    RevObject rev = w.parseAny((AnyObjectId)tree.getObjectId(0));
                    r.add(new IndexEntry(String.format("%06o", tree.getRawMode(0)), Constants.typeString((int)rev.getType()), tree.getObjectId(0).name(), tree.getNameString()));
                }
                arrayList = r;
                Object var10_10 = null;
                if (w == null) break block9;
            }
            catch (IOException e) {
                try {
                    throw new GitException(e);
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var10_11 = null;
                        if (w != null) {
                            w.dispose();
                        }
                        if (or != null) {
                            or.release();
                        }
                        if (repo == null) break block10;
                        repo.close();
                    }
                    throw throwable;
                }
            }
            w.dispose();
        }
        if (or != null) {
            or.release();
        }
        if (repo != null) {
            repo.close();
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void reset(boolean hard) throws GitException, InterruptedException {
        Repository repo = null;
        try {
            try {
                repo = this.getRepository();
                ResetCommand reset = new ResetCommand(repo);
                reset.setMode(hard ? ResetCommand.ResetType.HARD : ResetCommand.ResetType.MIXED);
                reset.call();
            }
            catch (GitAPIException e) {
                throw new GitException(e);
            }
            Object var5_5 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public boolean isBareRepository(String GIT_DIR) throws GitException, InterruptedException {
        Repository repo = null;
        boolean isBare = false;
        if (GIT_DIR == null) {
            throw new GitException("Not a git repository");
        }
        try {
            try {
                repo = StringUtils.isBlank((String)GIT_DIR) || !new File(GIT_DIR).isAbsolute() ? (new File(this.workspace, ".git").exists() ? this.getRepository() : ((RepositoryBuilder)new RepositoryBuilder().setGitDir(this.workspace)).build()) : ((RepositoryBuilder)new RepositoryBuilder().setGitDir(new File(GIT_DIR))).build();
                isBare = repo.isBare();
            }
            catch (IOException ioe) {
                throw new GitException(ioe);
            }
            Object var6_4 = null;
            if (repo == null) return isBare;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
        return isBare;
    }

    @Override
    @Deprecated
    public String getDefaultRemote(String _default_) throws GitException, InterruptedException {
        Set remotes = this.getConfig(null).getSubsections("remote");
        if (remotes.contains(_default_)) {
            return _default_;
        }
        return (String)Iterables.getFirst((Iterable)remotes, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException, InterruptedException {
        Repository repo = null;
        try {
            try {
                repo = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(new File(GIT_DIR))).build();
                StoredConfig config = repo.getConfig();
                config.setString("remote", name, "url", url);
                config.save();
            }
            catch (IOException ioe) {
                throw new GitException(ioe);
            }
            Object var7_7 = null;
            if (repo == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (repo == null) throw throwable;
            repo.close();
            throw throwable;
        }
        repo.close();
    }

    @Override
    @Deprecated
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException, InterruptedException {
        return this.getConfig(GIT_DIR).getString("remote", name, "url");
    }

    private StoredConfig getConfig(String GIT_DIR) throws GitException {
        Repository repo = null;
        if (StringUtils.isBlank((String)GIT_DIR)) {
            repo = this.getRepository();
        } else {
            try {
                repo = ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(new File(GIT_DIR))).build();
            }
            catch (IOException ioe) {
                throw new GitException(ioe);
            }
        }
        StoredConfig config = repo.getConfig();
        repo.close();
        return config;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrefixPredicate
    implements Predicate<Ref> {
        private final String prefix;

        PrefixPredicate(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(Ref r) {
            return r.getName().startsWith(this.prefix);
        }
    }

    class RawFormatter {
        RawFormatter() {
        }

        private boolean hasNewPath(DiffEntry d) {
            return d.getChangeType() == DiffEntry.ChangeType.COPY || d.getChangeType() == DiffEntry.ChangeType.RENAME;
        }

        private String statusOf(DiffEntry d) {
            switch (d.getChangeType()) {
                case ADD: {
                    return "A";
                }
                case MODIFY: {
                    return "M";
                }
                case DELETE: {
                    return "D";
                }
                case RENAME: {
                    return "R" + d.getScore();
                }
                case COPY: {
                    return "C" + d.getScore();
                }
            }
            throw new AssertionError((Object)("Unexpected change type: " + d.getChangeType()));
        }

        void format(RevCommit commit, @Nullable RevCommit parent, PrintWriter pw) throws IOException {
            if (parent != null) {
                pw.printf("commit %s (from %s)\n", commit.name(), parent.name());
            } else {
                pw.printf("commit %s\n", commit.name());
            }
            pw.printf("tree %s\n", commit.getTree().name());
            for (RevCommit p : commit.getParents()) {
                pw.printf("parent %s\n", p.name());
            }
            pw.printf("author %s\n", commit.getAuthorIdent().toExternalString());
            pw.printf("committer %s\n", commit.getCommitterIdent().toExternalString());
            String msg = commit.getFullMessage();
            if (msg.endsWith("\n")) {
                msg = msg.substring(0, msg.length() - 1);
            }
            msg = msg.replace("\n", "\n    ");
            msg = "    " + msg + "\n";
            pw.println(msg);
            Repository repo = JGitAPIImpl.this.getRepository();
            ObjectReader or = repo.newObjectReader();
            TreeWalk tw = new TreeWalk(or);
            if (parent != null) {
                tw.reset(new AnyObjectId[]{parent.getTree(), commit.getTree()});
            } else if (commit.getParentCount() > 0) {
                tw.reset(new AnyObjectId[]{commit.getParent(0).getTree(), commit.getTree()});
            } else {
                tw.reset(new AnyObjectId[]{commit.getTree(), commit.getTree()});
            }
            tw.setRecursive(true);
            tw.setFilter(TreeFilter.ANY_DIFF);
            RenameDetector rd = new RenameDetector(repo);
            rd.reset();
            rd.addAll((Collection)DiffEntry.scan((TreeWalk)tw));
            List diffs = rd.compute(or, null);
            tw.release();
            or.release();
            repo.close();
            for (DiffEntry diff : diffs) {
                pw.printf(":%06o %06o %s %s %s\t%s", diff.getOldMode().getBits(), diff.getNewMode().getBits(), diff.getOldId().name(), diff.getNewId().name(), this.statusOf(diff), diff.getChangeType() == DiffEntry.ChangeType.ADD ? diff.getNewPath() : diff.getOldPath());
                if (this.hasNewPath(diff)) {
                    pw.printf(" %s", diff.getNewPath());
                }
                pw.println();
                pw.println();
            }
        }
    }
}

