/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb.upstream;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbGitHubAuth;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommitStatusException;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildResultMessage;
import org.jenkinsci.plugins.ghprb.extensions.status.GhprbSimpleStatus;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

@Extension
public class GhprbUpstreamStatusListener
extends RunListener<AbstractBuild<?, ?>> {
    private static final Logger logger = Logger.getLogger(GhprbUpstreamStatusListener.class.getName());
    private GHRepository repo;

    private Map<String, String> returnEnvironmentVars(AbstractBuild<?, ?> build, TaskListener listener) {
        Map<String, String> envVars = Ghprb.getEnvVars(build, listener);
        if (!envVars.containsKey("ghprbUpstreamStatus")) {
            return null;
        }
        GhprbGitHubAuth auth = GhprbTrigger.getDscp().getGitHubAuth(envVars.get("ghprbCredentialsId"));
        try {
            GitHub gh = auth.getConnection((Item)build.getProject());
            this.repo = gh.getRepository(envVars.get("ghprbGhRepository"));
            return envVars;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to connect to GitHub repo", e);
            return null;
        }
    }

    private GhprbSimpleStatus returnGhprbSimpleStatus(Map<String, String> envVars) {
        ArrayList<GhprbBuildResultMessage> statusMessages = new ArrayList<GhprbBuildResultMessage>(5);
        for (GHCommitState state : GHCommitState.values()) {
            String envVar = String.format("ghprb%sMessage", state.name());
            String message = envVars.get(envVar);
            statusMessages.add(new GhprbBuildResultMessage(state, message));
        }
        return new GhprbSimpleStatus(Boolean.valueOf(envVars.get("ghprbShowMatrixStatus")), envVars.get("ghprbCommitStatusContext"), envVars.get("ghprbStatusUrl"), envVars.get("ghprbTriggeredStatus"), envVars.get("ghprbStartedStatus"), Boolean.valueOf(envVars.get("ghprbAddTestResults")), statusMessages);
    }

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) {
        Map<String, String> envVars = this.returnEnvironmentVars(build, (TaskListener)listener);
        if (envVars != null) {
            logger.log(Level.FINE, "Job: " + build.getFullDisplayName() + " Attempting to send GitHub commit status");
            try {
                this.returnGhprbSimpleStatus(envVars).onEnvironmentSetup((Run<?, ?>)build, (TaskListener)listener, this.repo);
            }
            catch (GhprbCommitStatusException e) {
                e.printStackTrace();
            }
        }
        return new Environment(){};
    }

    public void onStarted(AbstractBuild<?, ?> build, TaskListener listener) {
        Map<String, String> envVars = this.returnEnvironmentVars(build, listener);
        if (envVars == null) {
            return;
        }
        try {
            this.returnGhprbSimpleStatus(envVars).onBuildStart((Run<?, ?>)build, listener, this.repo);
        }
        catch (GhprbCommitStatusException e) {
            e.printStackTrace();
        }
    }

    public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
        Map<String, String> envVars = this.returnEnvironmentVars(build, listener);
        if (envVars == null) {
            return;
        }
        try {
            this.returnGhprbSimpleStatus(envVars).onBuildComplete((Run<?, ?>)build, listener, this.repo);
        }
        catch (GhprbCommitStatusException e) {
            e.printStackTrace();
        }
    }
}

