/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb.upstream;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildResultMessage;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;

public class GhprbUpstreamStatus
extends BuildWrapper {
    private final Boolean showMatrixStatus;
    private final String commitStatusContext;
    private final String triggeredStatus;
    private final String startedStatus;
    private final String statusUrl;
    private final Boolean addTestResults;
    private final List<GhprbBuildResultMessage> completedStatus;

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        variables.put("ghprbShowMatrixStatus", Boolean.toString(this.getShowMatrixStatus()));
        variables.put("ghprbUpstreamStatus", "true");
        variables.put("ghprbCommitStatusContext", this.getCommitStatusContext());
        variables.put("ghprbTriggeredStatus", this.getTriggeredStatus());
        variables.put("ghprbStartedStatus", this.getStartedStatus());
        variables.put("ghprbStatusUrl", this.getStatusUrl());
        variables.put("ghprbAddTestResults", Boolean.toString(this.getAddTestResults()));
        HashMap<GHCommitState, StringBuilder> statusMessages = new HashMap<GHCommitState, StringBuilder>(5);
        for (GhprbBuildResultMessage ghprbBuildResultMessage : this.getCompletedStatus()) {
            StringBuilder sb;
            GHCommitState state = ghprbBuildResultMessage.getResult();
            if (!statusMessages.containsKey(state)) {
                sb = new StringBuilder();
                statusMessages.put(state, sb);
            } else {
                sb = (StringBuilder)statusMessages.get(state);
                sb.append("\n");
            }
            sb.append(ghprbBuildResultMessage.getMessage());
        }
        for (Map.Entry entry : statusMessages.entrySet()) {
            String key = String.format("ghprb%sMessage", ((GHCommitState)entry.getKey()).name());
            variables.put(key, ((StringBuilder)entry.getValue()).toString());
        }
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.makeBuildVariables(build, build.getBuildVariables());
        return new BuildWrapper.Environment(){};
    }

    public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.makeBuildVariables(build, build.getBuildVariables());
    }

    @DataBoundConstructor
    public GhprbUpstreamStatus(Boolean showMatrixStatus, String commitStatusContext, String statusUrl, String triggeredStatus, String startedStatus, Boolean addTestResults, List<GhprbBuildResultMessage> completedStatus) {
        this.showMatrixStatus = showMatrixStatus;
        this.statusUrl = statusUrl;
        this.commitStatusContext = commitStatusContext == null ? "" : commitStatusContext;
        this.triggeredStatus = triggeredStatus;
        this.startedStatus = startedStatus;
        this.addTestResults = addTestResults;
        this.completedStatus = completedStatus;
    }

    public String getStatusUrl() {
        return this.statusUrl == null ? "" : this.statusUrl;
    }

    public String getCommitStatusContext() {
        return this.commitStatusContext == null ? "" : this.commitStatusContext;
    }

    public String getStartedStatus() {
        return this.startedStatus == null ? "" : this.startedStatus;
    }

    public String getTriggeredStatus() {
        return this.triggeredStatus == null ? "" : this.triggeredStatus;
    }

    public Boolean getAddTestResults() {
        return this.addTestResults == null ? Boolean.valueOf(false) : this.addTestResults;
    }

    public Boolean getShowMatrixStatus() {
        return this.showMatrixStatus == null ? Boolean.valueOf(false) : this.showMatrixStatus;
    }

    public List<GhprbBuildResultMessage> getCompletedStatus() {
        return this.completedStatus == null ? new ArrayList(0) : this.completedStatus;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        public String getDisplayName() {
            return "Set GitHub commit status with custom context and message (Must configure upstream job using GHPRB trigger)";
        }
    }
}

