/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb.manager.impl.downstreambuilds;

import com.cloudbees.plugins.flow.FlowRun;
import com.cloudbees.plugins.flow.JobInvocation;
import hudson.model.Run;
import hudson.tasks.test.AggregatedTestResultAction;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.ghprb.manager.configuration.JobConfiguration;
import org.jenkinsci.plugins.ghprb.manager.impl.GhprbBaseBuildManager;
import org.jgrapht.DirectedGraph;

public class BuildFlowBuildManager
extends GhprbBaseBuildManager {
    private static final Logger logger = Logger.getLogger(BuildFlowBuildManager.class.getName());

    public BuildFlowBuildManager(Run<?, ?> build) {
        super(build);
    }

    public BuildFlowBuildManager(Run<?, ?> build, JobConfiguration jobConfiguration) {
        super(build, jobConfiguration);
    }

    @Override
    public String calculateBuildUrl(String publishedURL) {
        Iterator<?> iterator = this.downstreamProjects();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            JobInvocation jobInvocation = (JobInvocation)iterator.next();
            sb.append("\n");
            sb.append("<a href='");
            sb.append(jobInvocation.getBuildUrl());
            sb.append("'>");
            sb.append(jobInvocation.getBuildUrl());
            sb.append("</a>");
        }
        return sb.toString();
    }

    @Override
    public Iterator<?> downstreamProjects() {
        FlowRun flowRun = (FlowRun)this.build;
        DirectedGraph directedGraph = flowRun.getJobsGraph();
        return directedGraph.vertexSet().iterator();
    }

    @Override
    public String getTestResults() {
        Iterator<?> iterator = this.downstreamProjects();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            JobInvocation jobInvocation = (JobInvocation)iterator.next();
            try {
                Run build = jobInvocation.getBuild();
                AggregatedTestResultAction testResultAction = (AggregatedTestResultAction)build.getAction(AggregatedTestResultAction.class);
                if (testResultAction == null) continue;
                sb.append("\n");
                sb.append(jobInvocation.getBuildUrl());
                sb.append("\n");
                sb.append(this.getAggregatedTestResults(build));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Job execution has failed", e);
            }
        }
        return sb.toString();
    }
}

