/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb.extensions;

import hudson.DescriptorExtensionList;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtension;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtensionType;
import org.jenkinsci.plugins.ghprb.extensions.GhprbGlobalExtension;
import org.jenkinsci.plugins.ghprb.extensions.GhprbProjectExtension;

public abstract class GhprbExtensionDescriptor
extends Descriptor<GhprbExtension> {
    public boolean isApplicable(Class<?> type) {
        return true;
    }

    public static List<GhprbExtensionDescriptor> getExtensions(Class<? extends GhprbExtensionType> ... types) {
        List<GhprbExtensionDescriptor> list = GhprbExtensionDescriptor.getExtensions();
        GhprbExtensionDescriptor.filterExtensions(list, types);
        return list;
    }

    private static void filterExtensions(List<GhprbExtensionDescriptor> descriptors, Class<? extends GhprbExtensionType> ... types) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(types.length);
        for (Class<? extends GhprbExtensionType> type : types) {
            predicates.add(InstanceofPredicate.getInstance(type));
        }
        Predicate anyPredicate = PredicateUtils.anyPredicate(predicates);
        Iterator<GhprbExtensionDescriptor> iter = descriptors.iterator();
        while (iter.hasNext()) {
            GhprbExtensionDescriptor descriptor = iter.next();
            if (anyPredicate.evaluate((Object)descriptor)) continue;
            iter.remove();
        }
    }

    private static DescriptorExtensionList<GhprbExtension, GhprbExtensionDescriptor> getExtensionList() {
        return Jenkins.getInstance().getDescriptorList(GhprbExtension.class);
    }

    private static List<GhprbExtensionDescriptor> getExtensions() {
        ArrayList<GhprbExtensionDescriptor> list = new ArrayList<GhprbExtensionDescriptor>();
        list.addAll((Collection<GhprbExtensionDescriptor>)GhprbExtensionDescriptor.getExtensionList());
        return list;
    }

    public static List<GhprbExtensionDescriptor> allProject() {
        List<GhprbExtensionDescriptor> list = GhprbExtensionDescriptor.getExtensions();
        GhprbExtensionDescriptor.filterExtensions(list, GhprbProjectExtension.class);
        return list;
    }

    public static List<GhprbExtensionDescriptor> allGlobal() {
        List<GhprbExtensionDescriptor> list = GhprbExtensionDescriptor.getExtensions();
        GhprbExtensionDescriptor.filterExtensions(list, GhprbGlobalExtension.class);
        return list;
    }
}

