/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.csrf.CrumbExclusion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class GhprbRootAction
implements UnprotectedRootAction {
    static final String URL = "ghprbhook";
    private static final Logger logger = Logger.getLogger(GhprbRootAction.class.getName());
    private Set<StartTrigger> triggerThreads = Collections.newSetFromMap(new WeakHashMap());
    private ExecutorService pool = Executors.newCachedThreadPool();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL;
    }

    public int getThreadCount() {
        return this.triggerThreads == null ? 0 : this.triggerThreads.size();
    }

    public void doIndex(StaplerRequest req, StaplerResponse resp) {
        String event = req.getHeader("X-GitHub-Event");
        String signature = req.getHeader("X-Hub-Signature");
        String type = req.getContentType();
        String payload = null;
        String body = null;
        if (type != null && type.toLowerCase().startsWith("application/json")) {
            body = this.extractRequestBody(req);
            if (body == null) {
                logger.log(Level.SEVERE, "Can't get request body for application/json.");
                resp.setStatus(400);
                return;
            }
            payload = body;
        } else if (type != null && type.toLowerCase().startsWith("application/x-www-form-urlencoded")) {
            body = this.extractRequestBody(req);
            if (body == null || body.length() <= 8) {
                logger.log(Level.SEVERE, "Request doesn't contain payload. You're sending url encoded request, so you should pass github payload through 'payload' request parameter");
                resp.setStatus(400);
                return;
            }
            try {
                String encoding = req.getCharacterEncoding();
                payload = URLDecoder.decode(body.substring(8), encoding != null ? encoding : "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.SEVERE, "Error while trying to decode the payload");
                resp.setStatus(400);
                return;
            }
        }
        if (payload == null) {
            logger.log(Level.SEVERE, "Payload is null, maybe content type ''{0}'' is not supported by this plugin. Please use 'application/json' or 'application/x-www-form-urlencoded'", new Object[]{type});
            resp.setStatus(415);
            return;
        }
        logger.log(Level.FINE, "Got payload event: {0}", event);
        String threadBody = body;
        String threadPayload = payload;
        this.handleAction(event, signature, threadPayload, threadBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAction(String event, String signature, String payload, String body) {
        Authentication old = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        GHEventPayload.IssueComment comment = null;
        GHEventPayload.PullRequest pr = null;
        String repoName = null;
        try {
            GitHub gh = GitHub.connectAnonymously();
            if (StringUtils.equalsIgnoreCase((String)"issue_comment", (String)event)) {
                comment = this.getIssueComment(payload, gh);
                GHIssueState state = comment.getIssue().getState();
                if (state == GHIssueState.CLOSED) {
                    logger.log(Level.INFO, "Skip comment on closed PR");
                    return;
                }
                if (!comment.getIssue().isPullRequest()) {
                    logger.log(Level.INFO, "Skip comment on Issue");
                    return;
                }
                repoName = comment.getRepository().getFullName();
                logger.log(Level.INFO, "Checking issue comment ''{0}'' for repo {1}", new Object[]{comment.getComment().getBody(), repoName});
            } else if (StringUtils.equalsIgnoreCase((String)"pull_request", (String)event)) {
                pr = this.getPullRequest(payload, gh);
                repoName = pr.getRepository().getFullName();
                logger.log(Level.INFO, "Checking PR #{1} for {0}", new Object[]{repoName, pr.getNumber()});
            } else {
                logger.log(Level.WARNING, "Request not known for event: {0}", new Object[]{event});
                return;
            }
            Set<GhprbTrigger> triggers = this.getTriggers(repoName, body, signature);
            this.handleEvent(triggers, payload, pr, comment);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to connect to GitHub anonymously", e);
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(old);
        }
    }

    private void handleEvent(Set<GhprbTrigger> triggers, String payload, GHEventPayload.PullRequest anonPr, GHEventPayload.IssueComment anonComment) {
        for (GhprbTrigger trigger : triggers) {
            try {
                StartTrigger runner = new StartTrigger();
                runner.trigger = trigger;
                if (anonPr != null) {
                    runner.pr = this.getPullRequest(payload, trigger.getGitHub());
                }
                if (anonComment != null) {
                    runner.comment = this.getIssueComment(payload, trigger.getGitHub());
                }
                this.triggerThreads.add(runner);
                this.pool.submit(runner);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to get authorized version of event", e);
            }
        }
    }

    private void triggerComment(final GhprbTrigger trigger, final GHEventPayload.IssueComment comment) {
        new Thread(){

            @Override
            public void run() {
                try {
                    trigger.handleComment(comment);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Unable to handle comment for PR# ");
                    sb.append(comment.getIssue().getId());
                    sb.append(", repo: ");
                    sb.append(comment.getRepository().getFullName());
                    logger.log(Level.SEVERE, sb.toString(), e);
                }
            }
        }.start();
    }

    private void triggerPr(final GhprbTrigger trigger, final GHEventPayload.PullRequest pr) {
        new Thread(){

            @Override
            public void run() {
                try {
                    trigger.handlePR(pr);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Unable to handle PR# ");
                    sb.append(pr.getNumber());
                    sb.append(" for repo: ");
                    sb.append(pr.getRepository().getFullName());
                    logger.log(Level.SEVERE, sb.toString(), e);
                }
            }
        }.start();
    }

    private GHEventPayload.PullRequest getPullRequest(String payload, GitHub gh) throws IOException {
        GHEventPayload.PullRequest pr = (GHEventPayload.PullRequest)gh.parseEventPayload((Reader)new StringReader(payload), GHEventPayload.PullRequest.class);
        return pr;
    }

    private GHEventPayload.IssueComment getIssueComment(String payload, GitHub gh) throws IOException {
        GHEventPayload.IssueComment issueComment = (GHEventPayload.IssueComment)gh.parseEventPayload((Reader)new StringReader(payload), GHEventPayload.IssueComment.class);
        return issueComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractRequestBody(StaplerRequest req) {
        String body = null;
        BufferedReader br = null;
        try {
            br = req.getReader();
            body = IOUtils.toString((Reader)br);
        }
        catch (IOException e) {
            body = null;
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
        }
        return body;
    }

    private Set<GhprbTrigger> getTriggers(String repoName, String body, String signature) {
        HashSet<GhprbTrigger> triggers = new HashSet<GhprbTrigger>();
        Set<Job<?, ?>> projects = GhprbTrigger.getDscp().getRepoTriggers(repoName);
        if (projects != null) {
            for (Job<?, ?> project : projects) {
                GhprbTrigger trigger = Ghprb.extractTrigger(project);
                if (trigger == null) {
                    logger.log(Level.WARNING, "Warning, trigger unexpectedly null for project " + project.getFullName());
                    continue;
                }
                try {
                    if (!trigger.matchSignature(body, signature)) continue;
                    triggers.add(trigger);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to match signature for trigger on project: " + trigger.getProjectName(), e);
                }
            }
        }
        return triggers;
    }

    @Extension
    public static class GhprbRootActionCrumbExclusion
    extends CrumbExclusion {
        public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.equals(this.getExclusionPath())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return true;
            }
            return false;
        }

        public String getExclusionPath() {
            return "/ghprbhook/";
        }
    }

    private class StartTrigger
    implements Runnable {
        GhprbTrigger trigger;
        GHEventPayload.PullRequest pr;
        GHEventPayload.IssueComment comment;

        private StartTrigger() {
        }

        @Override
        public void run() {
            try {
                if (this.pr != null) {
                    GhprbRootAction.this.triggerPr(this.trigger, this.pr);
                }
                if (this.comment != null) {
                    GhprbRootAction.this.triggerComment(this.trigger, this.comment);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to run thread", e);
            }
            finally {
                GhprbRootAction.this.triggerThreads.remove(this);
            }
        }
    }
}

