/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.SaveableListener;
import hudson.util.Secret;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommentAppender;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommitStatusException;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtension;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildStatus;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class GhprbRepository
implements Saveable {
    private static final transient Logger logger = Logger.getLogger(GhprbRepository.class.getName());
    private static final transient EnumSet<GHEvent> HOOK_EVENTS = EnumSet.of(GHEvent.ISSUE_COMMENT, GHEvent.PULL_REQUEST);
    private final String reponame;
    private final Map<Integer, GhprbPullRequest> pullRequests = new ConcurrentHashMap<Integer, GhprbPullRequest>();
    private transient GHRepository ghRepository;
    private transient GhprbTrigger trigger;
    public static final Object createHookLock = new Object();

    public GhprbRepository(String reponame, GhprbTrigger trigger) {
        this.reponame = reponame;
        this.trigger = trigger;
    }

    public void addPullRequests(Map<Integer, GhprbPullRequest> prs) {
        this.pullRequests.putAll(prs);
    }

    public void init() {
        for (Map.Entry<Integer, GhprbPullRequest> next : this.pullRequests.entrySet()) {
            GhprbPullRequest pull = next.getValue();
            pull.init(this.trigger.getHelper(), this);
        }
    }

    private boolean initGhRepository() {
        if (this.ghRepository != null) {
            return true;
        }
        GitHub gitHub = null;
        try {
            gitHub = this.trigger.getGitHub();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error while accessing rate limit API", ex);
            return false;
        }
        if (gitHub == null) {
            logger.log(Level.SEVERE, "No connection returned to GitHub server!");
            return false;
        }
        try {
            if (gitHub.getRateLimit().remaining == 0) {
                logger.log(Level.INFO, "Exceeded rate limit for repository");
                return false;
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.INFO, "Rate limit API not found.");
            return false;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error while accessing rate limit API", ex);
            return false;
        }
        try {
            this.ghRepository = gitHub.getRepository(this.reponame);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not retrieve GitHub repository named " + this.reponame + " (Do you have properly set 'GitHub project' field in job configuration?)", ex);
            return false;
        }
        return true;
    }

    public void check() {
        List openPulls;
        if (!this.trigger.isActive()) {
            logger.log(Level.FINE, "Project is not active, not checking github state");
            return;
        }
        if (!this.initGhRepository()) {
            return;
        }
        GHRepository repo = this.getGitHubRepo();
        try {
            openPulls = repo.getPullRequests(GHIssueState.OPEN);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not retrieve open pull requests.", ex);
            return;
        }
        HashSet<Integer> closedPulls = new HashSet<Integer>(this.pullRequests.keySet());
        for (GHPullRequest pr : openPulls) {
            if (pr.getHead() == null) {
                try {
                    pr = this.getActualPullRequest(pr.getNumber());
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Could not retrieve pr " + pr.getNumber(), ex);
                    return;
                }
            }
            this.check(pr);
            closedPulls.remove(pr.getNumber());
        }
        for (Integer id : closedPulls) {
            this.pullRequests.remove(id);
        }
        try {
            this.save();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to save repository!", e);
        }
    }

    private void check(GHPullRequest pr) {
        int number = pr.getNumber();
        try {
            GhprbPullRequest pull = this.getPullRequest(null, number);
            pull.check(pr, false);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to check pr: " + number, e);
        }
        try {
            this.save();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to save repository!", e);
        }
    }

    public void commentOnFailure(Run<?, ?> build, TaskListener listener, GhprbCommitStatusException ex) {
        PrintStream stream = null;
        if (listener != null) {
            stream = listener.getLogger();
        }
        GHCommitState state = ex.getState();
        IOException baseException = ex.getException();
        String newMessage = baseException instanceof FileNotFoundException ? "FileNotFoundException means that the credentials Jenkins is using is probably wrong. Or the user account does not have write access to the repo." : "Could not update commit status of the Pull Request on GitHub.";
        if (stream != null) {
            stream.println(newMessage);
            baseException.printStackTrace(stream);
        } else {
            logger.log(Level.INFO, newMessage, baseException);
        }
        if (GhprbTrigger.getDscp().getUseComments().booleanValue()) {
            StringBuilder msg = new StringBuilder(ex.getMessage());
            if (build != null) {
                msg.append("\n");
                GhprbTrigger trigger = Ghprb.extractTrigger(build);
                for (GhprbExtension ext : Ghprb.matchesAll(trigger.getExtensions(), GhprbBuildStatus.class)) {
                    if (!(ext instanceof GhprbCommentAppender)) continue;
                    msg.append(((GhprbCommentAppender)((Object)ext)).postBuildComment(build, null));
                }
            }
            if (GhprbTrigger.getDscp().getUseDetailedComments().booleanValue() || state == GHCommitState.SUCCESS || state == GHCommitState.FAILURE) {
                logger.log(Level.INFO, "Trying to send comment.", baseException);
                this.addComment(ex.getId(), msg.toString());
            }
        } else {
            logger.log(Level.SEVERE, "Could not update commit status of the Pull Request on GitHub.");
        }
    }

    public String getName() {
        return this.reponame;
    }

    public void addComment(int id, String comment) {
        this.addComment(id, comment, null, null);
    }

    public void addComment(int id, String comment, Run<?, ?> build, TaskListener listener) {
        if (comment.trim().isEmpty()) {
            return;
        }
        if (build != null && listener != null) {
            try {
                comment = build.getEnvironment(listener).expand(comment);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error", e);
            }
        }
        try {
            GHRepository repo = this.getGitHubRepo();
            GHPullRequest pr = repo.getPullRequest(id);
            pr.comment(comment);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not add comment to pull request #" + id + ": '" + comment + "'", ex);
        }
    }

    public void closePullRequest(int id) {
        try {
            GHRepository repo = this.getGitHubRepo();
            GHPullRequest pr = repo.getPullRequest(id);
            pr.close();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not close the pull request #" + id + ": '", ex);
        }
    }

    private boolean hookExist() throws IOException {
        GHRepository ghRepository = this.getGitHubRepo();
        if (ghRepository == null) {
            throw new IOException("Unable to get repo [ " + this.reponame + " ]");
        }
        for (GHHook h : ghRepository.getHooks()) {
            if (!"web".equals(h.getName()) || !this.getHookUrl().equals(h.getConfig().get("url"))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createHook() {
        try {
            Object object = createHookLock;
            synchronized (object) {
                if (this.hookExist()) {
                    return true;
                }
                HashMap<String, String> config = new HashMap<String, String>();
                String secret = this.getSecret();
                config.put("url", new URL(this.getHookUrl()).toExternalForm());
                config.put("insecure_ssl", "1");
                if (!StringUtils.isEmpty((String)secret)) {
                    config.put("secret", secret);
                }
                this.getGitHubRepo().createHook("web", config, HOOK_EVENTS, true);
                return true;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not create web hook for repository {0}. Does the user (from global configuration) have admin rights to the repository?", this.reponame);
            return false;
        }
    }

    private String getSecret() {
        Secret secret = this.trigger.getGitHubApiAuth().getSecret();
        return secret == null ? "" : secret.getPlainText();
    }

    private String getHookUrl() {
        String baseUrl = this.trigger.getGitHubApiAuth().getJenkinsUrl();
        if (baseUrl == null) {
            baseUrl = Jenkins.getInstance().getRootUrl();
        }
        return baseUrl + "ghprbhook" + "/";
    }

    public GhprbPullRequest getPullRequest(int id) {
        return this.pullRequests.get(id);
    }

    public GHPullRequest getActualPullRequest(int id) throws IOException {
        return this.getGitHubRepo().getPullRequest(id);
    }

    void onIssueCommentHook(GHEventPayload.IssueComment issueComment) throws IOException {
        if (!this.trigger.isActive()) {
            logger.log(Level.FINE, "Not checking comments since build is disabled");
            return;
        }
        int number = issueComment.getIssue().getNumber();
        logger.log(Level.FINER, "Comment on issue #{0} from {1}: {2}", new Object[]{number, issueComment.getComment().getUser(), issueComment.getComment().getBody()});
        if (!"created".equals(issueComment.getAction())) {
            return;
        }
        GhprbPullRequest pull = this.getPullRequest(null, number);
        pull.check(issueComment.getComment());
        try {
            this.save();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to save repository!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GhprbPullRequest getPullRequest(GHPullRequest ghpr, Integer number) throws IOException {
        if (number == null) {
            number = ghpr.getNumber();
        }
        GhprbRepository ghprbRepository = this;
        synchronized (ghprbRepository) {
            GhprbPullRequest pr = this.pullRequests.get(number);
            if (pr == null) {
                if (ghpr == null) {
                    GHRepository repo = this.getGitHubRepo();
                    ghpr = repo.getPullRequest(number.intValue());
                }
                pr = new GhprbPullRequest(ghpr, this.trigger.getHelper(), this);
                this.pullRequests.put(number, pr);
            }
            return pr;
        }
    }

    void onPullRequestHook(GHEventPayload.PullRequest pr) throws IOException {
        GHPullRequest ghpr = pr.getPullRequest();
        int number = pr.getNumber();
        String action = pr.getAction();
        boolean doSave = false;
        if ("closed".equals(action)) {
            this.pullRequests.remove(number);
            doSave = true;
        } else if (!this.trigger.isActive()) {
            logger.log(Level.FINE, "Not processing Pull request since the build is disabled");
        } else if ("edited".equals(action) || "opened".equals(action) || "reopened".equals(action) || "synchronize".equals(action)) {
            GhprbPullRequest pull = this.getPullRequest(ghpr, number);
            pull.check(ghpr, true);
            doSave = true;
        } else {
            logger.log(Level.WARNING, "Unknown Pull Request hook action: {0}", action);
        }
        if (doSave) {
            try {
                this.save();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to save repository!", e);
            }
        }
    }

    public GHRepository getGitHubRepo() {
        if (this.ghRepository == null && !this.initGhRepository()) {
            logger.log(Level.SEVERE, "Unable to get repository [ {0} ]", this.reponame);
        }
        return this.ghRepository;
    }

    public void load() throws IOException {
        XmlFile xml = this.getConfigXml(this.trigger.getActualProject());
        if (xml.exists()) {
            xml.unmarshal((Object)this);
        }
        this.save();
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        XmlFile config = this.getConfigXml(this.trigger.getActualProject());
        config.write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)config);
    }

    protected XmlFile getConfigXml(Job<?, ?> project) throws IOException {
        try {
            String escapedRepoName = URLEncoder.encode(this.reponame, "UTF8");
            File file = new File(project.getBuildDir() + "/pullrequests", escapedRepoName);
            return Items.getConfigFile((File)file);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }
}

