/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class GhprbParametersAction
extends ParametersAction {
    private List<ParameterValue> parameters;

    public GhprbParametersAction(List<ParameterValue> parameters) {
        super(parameters);
        this.parameters = parameters;
    }

    public GhprbParametersAction(ParameterValue ... parameters) {
        this(Arrays.asList(parameters));
    }

    public List<ParameterValue> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public ParameterValue getParameter(String name) {
        for (ParameterValue parameter : this.parameters) {
            if (parameter == null || !parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @Extension
    public static final class GhprbAdditionalParameterEnvironmentContributor
    extends EnvironmentContributor {
        public void buildEnvironmentFor(@Nonnull Run run, @Nonnull EnvVars envs, @Nonnull TaskListener listener) throws IOException, InterruptedException {
            GhprbParametersAction gpa = (GhprbParametersAction)run.getAction(GhprbParametersAction.class);
            if (gpa != null) {
                for (ParameterValue p : gpa.getParameters()) {
                    envs.put(p.getName(), String.valueOf(p.getValue()));
                }
            }
            super.buildEnvironmentFor(run, envs, listener);
        }
    }
}

