/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.HostnamePortSpecification;
import com.cloudbees.plugins.credentials.domains.HostnameSpecification;
import com.cloudbees.plugins.credentials.domains.PathSpecification;
import com.cloudbees.plugins.credentials.domains.SchemeSpecification;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import hudson.util.Secret;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.ParameterizedJobMixIn;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.GhprbBranch;
import org.jenkinsci.plugins.ghprb.GhprbBuilds;
import org.jenkinsci.plugins.ghprb.GhprbCause;
import org.jenkinsci.plugins.ghprb.GhprbGitHub;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtension;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtensionDescriptor;
import org.jenkinsci.plugins.ghprb.extensions.GhprbProjectExtension;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHUser;

public class Ghprb {
    private static final Logger logger = Logger.getLogger(Ghprb.class.getName());
    public static final Pattern githubUserRepoPattern = Pattern.compile("^(http[s]?://[^/]*)/([^/]*/[^/]*).*");
    private final GhprbTrigger trigger;

    public Ghprb(GhprbTrigger trigger) {
        this.trigger = trigger;
    }

    public void addWhitelist(String author) {
        logger.log(Level.INFO, "Adding {0} to whitelist", author);
        this.trigger.addWhitelist(author);
    }

    public boolean isProjectDisabled() {
        return !this.trigger.isActive();
    }

    public GhprbBuilds getBuilds() {
        return this.trigger.getBuilds();
    }

    public GhprbTrigger getTrigger() {
        return this.trigger;
    }

    public GhprbGitHub getGitHub() {
        return this.trigger.getGhprbGitHub();
    }

    public static Pattern compilePattern(String regex) {
        try {
            return Pattern.compile(regex, 34);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to compile pattern " + regex, e);
            return null;
        }
    }

    private static boolean checkPattern(Pattern pattern, String comment) {
        return pattern != null && pattern.matcher(comment).matches();
    }

    private Pattern retestPhrasePattern() {
        return Ghprb.compilePattern(this.trigger.getDescriptor().getRetestPhrase());
    }

    public Set<String> getSkipBuildPhrases() {
        return new HashSet<String>(Arrays.asList(this.getTrigger().getSkipBuildPhrase().split("[\\r\\n]+")));
    }

    public Set<String> getBlacklistedCommitAuthors() {
        return new HashSet<String>(Arrays.asList(this.getTrigger().getBlackListCommitAuthor().split("[\\r\\n]+")));
    }

    public String checkBlackListCommitAuthor(String author) {
        Set<String> authors = this.getBlacklistedCommitAuthors();
        authors.remove("");
        HashMap skipPatterns = new HashMap();
        for (String s : authors) {
            if (!Ghprb.compilePattern(s = s.trim()).matcher(author).matches()) continue;
            return s;
        }
        return null;
    }

    public String checkSkipBuildPhrase(GHIssue issue) {
        String skipBuildPhrase2;
        Set<String> skipBuildPhrases = this.getSkipBuildPhrases();
        skipBuildPhrases.remove("");
        HashMap<Pattern, String> skipPatterns = new HashMap<Pattern, String>();
        for (String skipBuildPhrase2 : skipBuildPhrases) {
            skipBuildPhrase2 = skipBuildPhrase2.trim();
            skipPatterns.put(Ghprb.compilePattern(skipBuildPhrase2), skipBuildPhrase2);
        }
        String pullRequestTitle = issue.getTitle();
        skipBuildPhrase2 = this.checkSkipBuildInString(skipPatterns, pullRequestTitle);
        if (StringUtils.isNotBlank((String)skipBuildPhrase2)) {
            return skipBuildPhrase2;
        }
        String pullRequestBody = issue.getBody();
        skipBuildPhrase2 = this.checkSkipBuildInString(skipPatterns, pullRequestBody);
        if (StringUtils.isNotBlank((String)skipBuildPhrase2)) {
            return skipBuildPhrase2;
        }
        return null;
    }

    private String checkSkipBuildInString(Map<Pattern, String> patterns, String string) {
        if (!patterns.isEmpty() && StringUtils.isNotBlank((String)string)) {
            for (Map.Entry<Pattern, String> e : patterns.entrySet()) {
                if (!e.getKey().matcher(string).matches()) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public Set<String> getBlackListLabels() {
        return this.spiltLabels(this.getTrigger().getBlackListLabels());
    }

    public Set<String> getWhiteListLabels() {
        return this.spiltLabels(this.getTrigger().getWhiteListLabels());
    }

    private Set<String> spiltLabels(String labelsField) {
        HashSet<String> labels = new HashSet<String>();
        if (labelsField != null && !labelsField.trim().isEmpty()) {
            String[] split = labelsField.split("\\n+");
            for (int i = 0; i < split.length; ++i) {
                split[i] = split[i].trim();
            }
            Collections.addAll(labels, split);
        }
        return labels;
    }

    private Pattern whitelistPhrasePattern() {
        return Ghprb.compilePattern(this.trigger.getDescriptor().getWhitelistPhrase());
    }

    private Pattern oktotestPhrasePattern() {
        return Ghprb.compilePattern(this.trigger.getDescriptor().getOkToTestPhrase());
    }

    private Pattern triggerPhrase() {
        return Ghprb.compilePattern(this.trigger.getTriggerPhrase());
    }

    private HashSet<String> admins() {
        HashSet<String> adminList = new HashSet<String>(Arrays.asList(this.trigger.getAdminlist().toLowerCase().split("\\s+")));
        adminList.remove("");
        return adminList;
    }

    private HashSet<String> whitelisted() {
        HashSet<String> whitelistedList = new HashSet<String>(Arrays.asList(this.trigger.getWhitelist().toLowerCase().split("\\s+")));
        whitelistedList.remove("");
        return whitelistedList;
    }

    private HashSet<String> organisations() {
        HashSet<String> organisationsList = new HashSet<String>(Arrays.asList(this.trigger.getOrgslist().split("\\s+")));
        organisationsList.remove("");
        return organisationsList;
    }

    public boolean isRetestPhrase(String comment) {
        return Ghprb.checkPattern(this.retestPhrasePattern(), comment);
    }

    public boolean isWhitelistPhrase(String comment) {
        return Ghprb.checkPattern(this.whitelistPhrasePattern(), comment);
    }

    public boolean isOktotestPhrase(String comment) {
        return Ghprb.checkPattern(this.oktotestPhrasePattern(), comment);
    }

    public boolean isTriggerPhrase(String comment) {
        return Ghprb.checkPattern(this.triggerPhrase(), comment);
    }

    public boolean ifOnlyTriggerPhrase() {
        return this.trigger.getOnlyTriggerPhrase();
    }

    public boolean isWhitelisted(GHUser user) {
        return this.trigger.getPermitAll() != false || this.whitelisted().contains(user.getLogin().toLowerCase()) || this.admins().contains(user.getLogin().toLowerCase()) || this.isInWhitelistedOrganisation(user);
    }

    public boolean isAdmin(GHUser user) {
        return this.admins().contains(user.getLogin().toLowerCase()) || this.trigger.getAllowMembersOfWhitelistedOrgsAsAdmin() != false && this.isInWhitelistedOrganisation(user);
    }

    public boolean isBotUser(GHUser user) {
        return user != null && user.getLogin().equals(this.getGitHub().getBotUserLogin());
    }

    private boolean isInWhitelistedOrganisation(GHUser user) {
        for (String organisation : this.organisations()) {
            if (!this.getGitHub().isUserMemberOfOrganization(organisation, user)) continue;
            return true;
        }
        return false;
    }

    List<GhprbBranch> getBlackListTargetBranches() {
        return this.trigger.getBlackListTargetBranches();
    }

    List<GhprbBranch> getWhiteListTargetBranches() {
        return this.trigger.getWhiteListTargetBranches();
    }

    public List<Pattern> getIncludedRegionPatterns() {
        List<String> regions = Arrays.asList(this.trigger.getIncludedRegions().split("\\s+"));
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(regions.size());
        for (String region : regions) {
            if (!StringUtils.isNotEmpty((String)region)) continue;
            patterns.add(Pattern.compile(region));
        }
        return patterns;
    }

    public List<Pattern> getExcludedRegionPatterns() {
        List<String> regions = Arrays.asList(this.trigger.getExcludedRegions().split("\\s+"));
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(regions.size());
        for (String region : regions) {
            if (!StringUtils.isNotEmpty((String)region)) continue;
            patterns.add(Pattern.compile(region));
        }
        return patterns;
    }

    public static String replaceMacros(Run<?, ?> build, TaskListener listener, String inputString) {
        String returnString = inputString;
        if (build != null && inputString != null) {
            try {
                Map<String, String> messageEnvVars = Ghprb.getEnvVars(build, listener);
                returnString = Util.replaceMacro((String)inputString, messageEnvVars);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Couldn't replace macros in message: ", e);
            }
        }
        return returnString;
    }

    public static Map<String, String> getEnvVars(Run<?, ?> build, TaskListener listener) {
        HashMap<String, String> messageEnvVars = new HashMap<String, String>();
        if (build != null) {
            messageEnvVars.putAll((Map<String, String>)build.getCharacteristicEnvVars());
            if (build instanceof AbstractBuild) {
                messageEnvVars.putAll(((AbstractBuild)build).getBuildVariables());
            }
            try {
                messageEnvVars.putAll((Map<String, String>)build.getEnvironment(listener));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Couldn't get Env Variables: ", e);
            }
        }
        return messageEnvVars;
    }

    public static String replaceMacros(Job<?, ?> project, String inputString) {
        String returnString = inputString;
        if (project != null && inputString != null) {
            try {
                HashMap messageEnvVars = new HashMap();
                messageEnvVars.putAll(project.getCharacteristicEnvVars());
                returnString = Util.replaceMacro((String)inputString, messageEnvVars);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Couldn't replace macros in message: ", e);
            }
        }
        return returnString;
    }

    public static GHCommitState getState(Run<?, ?> build) {
        GHCommitState state = build.getResult() == Result.SUCCESS ? GHCommitState.SUCCESS : (build.getResult() == Result.UNSTABLE ? GhprbTrigger.getDscp().getUnstableAs() : GHCommitState.FAILURE);
        return state;
    }

    public static Set<String> createSet(String list) {
        String listString = list == null ? "" : list;
        List<String> listList = Arrays.asList(listString.split("\\s+"));
        HashSet<String> listSet = new HashSet<String>(listList);
        listSet.remove("");
        return listSet;
    }

    public static GhprbCause getCause(Run<?, ?> build) {
        Cause cause = build.getCause(GhprbCause.class);
        if (cause == null || !(cause instanceof GhprbCause)) {
            return null;
        }
        return (GhprbCause)cause;
    }

    public static GhprbTrigger extractTrigger(Run<?, ?> build) {
        return Ghprb.extractTrigger(build.getParent());
    }

    public static GhprbTrigger extractTrigger(Job<?, ?> p) {
        ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)p;
        GhprbTrigger ghprbTrigger = null;
        if (p instanceof ParameterizedJobMixIn.ParameterizedJob) {
            for (Trigger trigger : pJob.getTriggers().values()) {
                if (!(trigger instanceof GhprbTrigger)) continue;
                ghprbTrigger = (GhprbTrigger)trigger;
                break;
            }
        }
        return ghprbTrigger;
    }

    private static List<Predicate> createPredicate(Class<?> ... types) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(types.length);
        for (Class<?> type : types) {
            predicates.add(InstanceofPredicate.getInstance(type));
        }
        return predicates;
    }

    public static void filterList(DescribableList<GhprbExtension, GhprbExtensionDescriptor> descriptors, Predicate predicate) {
        for (GhprbExtension descriptor : descriptors) {
            if (predicate.evaluate((Object)descriptor)) continue;
            descriptors.remove((Object)descriptor);
        }
    }

    private static DescribableList<GhprbExtension, GhprbExtensionDescriptor> copyExtensions(DescribableList<GhprbExtension, GhprbExtensionDescriptor> ... extensionsList) {
        DescribableList copiedList = new DescribableList(Saveable.NOOP);
        for (DescribableList<GhprbExtension, GhprbExtensionDescriptor> extensions : extensionsList) {
            copiedList.addAll(extensions);
        }
        return copiedList;
    }

    public static DescribableList<GhprbExtension, GhprbExtensionDescriptor> getJobExtensions(GhprbTrigger trigger, Class<?> ... types) {
        DescribableList<GhprbExtension, GhprbExtensionDescriptor> copied = Ghprb.copyExtensions(trigger.getDescriptor().getExtensions());
        Ghprb.filterList(copied, PredicateUtils.notPredicate((Predicate)InstanceofPredicate.getInstance(GhprbProjectExtension.class)));
        copied = Ghprb.copyExtensions(copied, trigger.getExtensions());
        Ghprb.filterList(copied, PredicateUtils.anyPredicate(Ghprb.createPredicate(types)));
        return copied;
    }

    public static DescribableList<GhprbExtension, GhprbExtensionDescriptor> matchesAll(DescribableList<GhprbExtension, GhprbExtensionDescriptor> extensions, Class<?> ... types) {
        Predicate predicate = PredicateUtils.allPredicate(Ghprb.createPredicate(types));
        DescribableList copyExtensions = new DescribableList(Saveable.NOOP);
        copyExtensions.addAll(extensions);
        Ghprb.filterList((DescribableList<GhprbExtension, GhprbExtensionDescriptor>)copyExtensions, predicate);
        return copyExtensions;
    }

    public static DescribableList<GhprbExtension, GhprbExtensionDescriptor> matchesSome(DescribableList<GhprbExtension, GhprbExtensionDescriptor> extensions, Class<?> ... types) {
        Predicate predicate = PredicateUtils.anyPredicate(Ghprb.createPredicate(types));
        DescribableList copyExtensions = new DescribableList(Saveable.NOOP);
        copyExtensions.addAll(extensions);
        Ghprb.filterList((DescribableList<GhprbExtension, GhprbExtensionDescriptor>)copyExtensions, predicate);
        return copyExtensions;
    }

    public static DescribableList<GhprbExtension, GhprbExtensionDescriptor> onlyOneEntry(DescribableList<GhprbExtension, GhprbExtensionDescriptor> extensions, Class<?> ... types) {
        DescribableList copyExtensions = new DescribableList(Saveable.NOOP);
        HashSet extSet = new HashSet(types.length);
        List<Predicate> predicates = Ghprb.createPredicate(types);
        for (GhprbExtension extension : extensions) {
            if (!Ghprb.addExtension(extension, predicates, extSet)) continue;
            copyExtensions.add((Object)extension);
        }
        return copyExtensions;
    }

    private static boolean addExtension(GhprbExtension extension, List<Predicate> predicates, Set<Class<?>> extSet) {
        for (Predicate predicate : predicates) {
            if (!predicate.evaluate((Object)extension)) continue;
            Class clazz = ((InstanceofPredicate)predicate).getType();
            if (extSet.contains(clazz)) {
                return false;
            }
            extSet.add(clazz);
            return true;
        }
        return true;
    }

    public static void addIfMissing(DescribableList<GhprbExtension, GhprbExtensionDescriptor> extensions, GhprbExtension ext, Class<?> type) {
        if (ext == null) {
            return;
        }
        Predicate predicate = InstanceofPredicate.getInstance(type);
        for (GhprbExtension extension : extensions) {
            if (!predicate.evaluate((Object)extension)) continue;
            return;
        }
        extensions.add((Object)ext);
    }

    public static StandardCredentials lookupCredentials(Item context, String credentialId, String uri) {
        String contextName = "(Jenkins.instance)";
        if (context != null) {
            contextName = context.getFullName();
        }
        logger.log(Level.FINE, "Looking up credentials for {0}, using context {1} for url {2}", new Object[]{credentialId, contextName, uri});
        logger.log(Level.FINE, "Using null context because of issues not getting all credentials");
        List credentials = CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)null, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)uri).build());
        logger.log(Level.FINE, "Found {0} credentials", new Object[]{credentials.size()});
        return credentialId == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
    }

    public static String createCredentials(String serverAPIUrl, String token) throws Exception {
        String description = serverAPIUrl + " GitHub auto generated token credentials";
        StringCredentialsImpl credentials = new StringCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), description, Secret.fromString((String)token));
        return Ghprb.createCredentials(serverAPIUrl, (StandardCredentials)credentials);
    }

    public static String createCredentials(String serverAPIUrl, String username, String password) throws Exception {
        String description = serverAPIUrl + " GitHub auto generated Username password credentials";
        UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), description, username, password);
        return Ghprb.createCredentials(serverAPIUrl, (StandardCredentials)credentials);
    }

    private static String createCredentials(String serverAPIUrl, StandardCredentials credentials) throws Exception {
        ArrayList<Object> specifications = new ArrayList<Object>(2);
        URI serverUri = new URI(serverAPIUrl);
        if (serverUri.getPort() > 0) {
            specifications.add(new HostnamePortSpecification(serverUri.getHost() + ":" + serverUri.getPort(), null));
        } else {
            specifications.add(new HostnameSpecification(serverUri.getHost(), null));
        }
        specifications.add(new SchemeSpecification(serverUri.getScheme()));
        String path = serverUri.getPath();
        if (StringUtils.isEmpty((String)path)) {
            path = "/";
        }
        specifications.add(new PathSpecification(path, null, false));
        Domain domain = new Domain(serverUri.getHost(), "Auto generated credentials domain", specifications);
        SystemCredentialsProvider.StoreImpl provider = new SystemCredentialsProvider.StoreImpl();
        provider.addDomain(domain, new Credentials[]{credentials});
        return credentials.getId();
    }

    public static <T extends GhprbExtension> T getGlobal(Class<T> clazz) {
        DescribableList copyExtensions = new DescribableList(Saveable.NOOP);
        copyExtensions.addAll(GhprbTrigger.DESCRIPTOR.getExtensions());
        Ghprb.filterList((DescribableList<GhprbExtension, GhprbExtensionDescriptor>)copyExtensions, InstanceofPredicate.getInstance(clazz));
        return (T)((Object)((GhprbExtension)copyExtensions.get(clazz)));
    }

    public static <T, S extends GhprbExtension> T getDefaultValue(S local, Class<S> globalClass, String methodName) {
        T toReturn = null;
        S global = Ghprb.getGlobal(globalClass);
        if (local == null && global == null) {
            return null;
        }
        try {
            if (local == null) {
                return (T)global.getClass().getMethod(methodName, new Class[0]).invoke(global, new Object[0]);
            }
            if (global == null) {
                return (T)((Object)local).getClass().getMethod(methodName, new Class[0]).invoke((Object)local, new Object[0]);
            }
            Object localValue = ((Object)local).getClass().getMethod(methodName, new Class[0]).invoke((Object)local, new Object[0]);
            Object globalValue = global.getClass().getMethod(methodName, new Class[0]).invoke(global, new Object[0]);
            if (localValue instanceof String ? StringUtils.isEmpty((String)((String)localValue)) : localValue instanceof List && ((List)localValue).isEmpty()) {
                return (T)globalValue;
            }
            return (T)localValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return toReturn;
        }
    }
}

