/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.gwt.FoundJob;
import org.jenkinsci.plugins.gwt.GenericResponse;
import org.jenkinsci.plugins.gwt.GenericTrigger;
import org.jenkinsci.plugins.gwt.GenericTriggerResults;
import org.jenkinsci.plugins.gwt.jobfinder.JobFinder;
import org.jenkinsci.plugins.gwt.whitelist.WhitelistException;
import org.jenkinsci.plugins.gwt.whitelist.WhitelistVerifier;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class GenericWebHookRequestReceiver
extends CrumbExclusion
implements UnprotectedRootAction {
    private static final int RESPECT_JOBS_QUIET_PERIOD = -1;
    private static final String NO_JOBS_MSG = "Did not find any jobs with " + GenericTrigger.class.getSimpleName() + " configured! If you are using a token, you need to pass it like ...trigger/invoke?token=TOKENHERE. If you are not using a token, you need to authenticate like http://user:passsword@jenkins/generic-webhook... ";
    private static final String URL_NAME = "generic-webhook-trigger";
    private static final Logger LOGGER = Logger.getLogger(GenericWebHookRequestReceiver.class.getName());

    public HttpResponse doInvoke(StaplerRequest request) {
        String postContent = null;
        Map parameterMap = null;
        Map<String, List<String>> headers = null;
        try {
            headers = this.getHeaders(request);
            parameterMap = request.getParameterMap();
            postContent = IOUtils.toString((InputStream)request.getInputStream(), (String)Charsets.UTF_8.name());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "", e);
            return GenericResponse.jsonResponse(500, "Unable to read inputstream: " + e.getMessage());
        }
        try {
            WhitelistVerifier.verifyWhitelist(request.getRemoteAddr(), headers, postContent);
        }
        catch (WhitelistException e) {
            return GenericResponse.jsonResponse(403, "Sender, " + request.getRemoteHost() + ", with headers " + headers + " did not pass whitelist.\n" + e.getMessage());
        }
        String givenToken = this.getGivenToken(headers, parameterMap);
        return this.doInvoke(headers, parameterMap, postContent, givenToken);
    }

    @VisibleForTesting
    String getGivenToken(Map<String, List<String>> headers, Map<String, String[]> parameterMap) {
        if (parameterMap.containsKey("token")) {
            return parameterMap.get("token")[0];
        }
        if (headers.containsKey("token")) {
            return headers.get("token").get(0);
        }
        if (headers.containsKey("authorization")) {
            for (String candidateValue : headers.get("authorization")) {
                if (!candidateValue.startsWith("Bearer ")) continue;
                return candidateValue.substring(7);
            }
        }
        if (headers.containsKey("x-gitlab-token")) {
            return headers.get("x-gitlab-token").get(0);
        }
        return null;
    }

    @VisibleForTesting
    int getGivenQuietPeriod(Map<String, List<String>> headers, Map<String, String[]> parameterMap) {
        if (parameterMap.containsKey("jobQuietPeriod")) {
            try {
                return Integer.parseInt(parameterMap.get("jobQuietPeriod")[0]);
            }
            catch (Exception e) {
                return -1;
            }
        }
        if (headers.containsKey("jobQuietPeriod")) {
            try {
                return Integer.parseInt(headers.get("jobQuietPeriod").get(0));
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    @VisibleForTesting
    Map<String, List<String>> getHeaders(StaplerRequest request) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration headersEnumeration = request.getHeaderNames();
        while (headersEnumeration.hasMoreElements()) {
            String headerName = (String)headersEnumeration.nextElement();
            headers.put(headerName.toLowerCase(), Collections.list(request.getHeaders(headerName)));
        }
        return headers;
    }

    @VisibleForTesting
    HttpResponse doInvoke(Map<String, List<String>> headers, Map<String, String[]> parameterMap, String postContent, String givenToken) {
        List<FoundJob> foundJobs = JobFinder.findAllJobsWithTrigger(givenToken);
        HashMap<String, Object> triggerResultsMap = new HashMap<String, Object>();
        boolean allSilent = true;
        boolean errors = false;
        for (FoundJob foundJob : foundJobs) {
            try {
                LOGGER.log(Level.FINE, "Triggering " + foundJob.getFullName());
                LOGGER.log(Level.FINE, " with:\n\n" + postContent + "\n\n");
                GenericTrigger genericTrigger = foundJob.getGenericTrigger();
                int quietPeriod = -1;
                if (genericTrigger.getOverrideQuietPeriod()) {
                    quietPeriod = this.getGivenQuietPeriod(headers, parameterMap);
                }
                GenericTriggerResults triggerResults = genericTrigger.trigger(headers, parameterMap, postContent, quietPeriod);
                if (genericTrigger.isSilentResponse()) continue;
                allSilent = false;
                triggerResultsMap.put(foundJob.getFullName(), triggerResults);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, foundJob.getFullName(), t);
                String msg = this.createMessageFromException(t);
                triggerResultsMap.put(foundJob.getFullName(), msg);
                errors = true;
            }
        }
        if (allSilent && foundJobs.size() > 0) {
            return HttpResponses.ok();
        }
        if (errors) {
            return GenericResponse.jsonResponse(500, "There were errors when triggering jobs.", triggerResultsMap);
        }
        if (foundJobs.isEmpty()) {
            LOGGER.log(Level.FINE, NO_JOBS_MSG);
            return GenericResponse.jsonResponse(404, NO_JOBS_MSG);
        }
        return GenericResponse.jsonResponse(200, "Triggered jobs.", triggerResultsMap);
    }

    String createMessageFromException(Throwable t) {
        String stacktraceInfo = "";
        if (t.getStackTrace().length > 0) {
            stacktraceInfo = "Thrown in: " + t.getStackTrace()[0].getClassName() + ":" + t.getStackTrace()[0].getLineNumber();
        }
        String msg = "Exception occurred (" + t.getClass() + ": " + t.getMessage() + "), full stack trace in Jenkins server log. " + stacktraceInfo;
        return msg;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/generic-webhook-trigger/")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }
}

