/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hudson.model.Executor;
import hudson.model.Run;
import hudson.plugins.gearman.GearmanPluginUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.gearman.client.GearmanJobResult;
import org.gearman.client.GearmanJobResultImpl;
import org.gearman.worker.AbstractGearmanFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopJobWorker
extends AbstractGearmanFunction {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");

    public GearmanJobResult executeFunction() {
        String decodedData;
        boolean jobResult = false;
        String jobResultMsg = "";
        try {
            decodedData = new String((byte[])this.data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding exception in argument");
        }
        Gson gson = new Gson();
        Map data = (Map)gson.fromJson(decodedData, new TypeToken<Map<String, String>>(){}.getType());
        String jobName = (String)data.get("name");
        String buildNumber = (String)data.get("number");
        if (jobName.isEmpty() || buildNumber.isEmpty()) {
            throw new IllegalArgumentException("Build id is invalid or not specified");
        }
        Run<?, ?> build = GearmanPluginUtil.findBuild(jobName, Integer.parseInt(buildNumber));
        if (build != null) {
            if (build.isBuilding()) {
                Executor executor = build.getExecutor();
                if (executor == null) {
                    executor = build.getOneOffExecutor();
                }
                if (executor == null) {
                    throw new IllegalArgumentException("Cannot find executor for build " + jobName + ": " + buildNumber);
                }
                if (!executor.isInterrupted()) {
                    executor.interrupt();
                    logger.info("---- Aborting build : " + jobName + ": " + buildNumber);
                    jobResult = true;
                }
            } else {
                logger.info("---- Request to abourt non-building build : " + jobName + ": " + buildNumber);
            }
        } else {
            throw new IllegalArgumentException("Cannot find build " + jobName + ": " + buildNumber);
        }
        GearmanJobResultImpl gjr = null;
        try {
            gjr = new GearmanJobResultImpl(this.jobHandle, jobResult, jobResultMsg.getBytes("UTF-8"), null, null, 0L, 0L);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding exception in gearman job result");
        }
        return gjr;
    }
}

