/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hudson.model.Run;
import hudson.plugins.gearman.GearmanPluginUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.gearman.client.GearmanJobResult;
import org.gearman.client.GearmanJobResultImpl;
import org.gearman.worker.AbstractGearmanFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetDescriptionWorker
extends AbstractGearmanFunction {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GearmanJobResult executeFunction() {
        String decodedData;
        boolean jobResult = false;
        String jobResultMsg = "";
        try {
            decodedData = new String((byte[])this.data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding exception in argument");
        }
        Gson gson = new Gson();
        Map data = (Map)gson.fromJson(decodedData, new TypeToken<Map<String, String>>(){}.getType());
        String buildDescription = (String)data.get("html_description");
        String jobName = (String)data.get("name");
        String buildNumber = (String)data.get("number");
        if (jobName.isEmpty()) throw new IllegalArgumentException("Build id is invalid or not specified");
        if (buildNumber.isEmpty()) throw new IllegalArgumentException("Build id is invalid or not specified");
        Run<?, ?> build = GearmanPluginUtil.findBuild(jobName, Integer.parseInt(buildNumber));
        if (build == null) throw new IllegalArgumentException("Cannot find build number " + buildNumber);
        try {
            GearmanPluginUtil.setBuildDescription(build, buildDescription);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to set description for " + jobName + ": " + buildNumber);
        }
        jobResultMsg = "Description for Jenkins build " + buildNumber + " was updated to " + buildDescription;
        jobResult = true;
        GearmanJobResultImpl gjr = null;
        try {
            return new GearmanJobResultImpl(this.jobHandle, jobResult, jobResultMsg.getBytes("UTF-8"), null, null, 0L, 0L);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding exception in gearman job result");
        }
    }
}

