/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.CauseOfBlockage;
import hudson.plugins.gearman.AbstractWorkerThread;
import hudson.plugins.gearman.AvailabilityMonitor;
import hudson.plugins.gearman.ExecutorWorkerThread;
import hudson.plugins.gearman.GearmanPluginConfig;
import hudson.plugins.gearman.GearmanPluginUtil;
import hudson.plugins.gearman.ManagementWorkerThread;
import hudson.plugins.gearman.NodeAvailabilityMonitor;
import hudson.plugins.gearman.NoopAvailabilityMonitor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GearmanProxy {
    private static GearmanProxy gearmanProxy;
    private static final Logger logger;
    private final List<ExecutorWorkerThread> gewtHandles = Collections.synchronizedList(new ArrayList());
    private final List<ManagementWorkerThread> gmwtHandles = Collections.synchronizedList(new ArrayList());
    private final String masterName;

    public static synchronized GearmanProxy getInstance() {
        if (gearmanProxy == null) {
            gearmanProxy = new GearmanProxy();
        }
        return gearmanProxy;
    }

    private GearmanProxy() {
        Computer master = null;
        String hostname = "anonymous";
        try {
            master = Jenkins.get().getComputer("");
            hostname = master.getHostName();
        }
        catch (Exception e) {
            logger.warn("Exception while getting hostname", (Throwable)e);
        }
        if (master == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.warn("Exception while getting hostname", (Throwable)e);
            }
        }
        this.masterName = hostname;
    }

    protected void testResetHandles() {
        this.gmwtHandles.clear();
        this.gewtHandles.clear();
    }

    public void initWorkers() {
        List nodes;
        Computer computer;
        this.createManagementWorker();
        Node masterNode = null;
        try {
            masterNode = Jenkins.get().getComputer("").getNode();
        }
        catch (NullPointerException npe) {
            logger.info("---- Master is offline");
        }
        catch (Exception e) {
            logger.error("Exception while finding master", (Throwable)e);
        }
        if (masterNode != null && (computer = masterNode.toComputer()) != null) {
            this.createExecutorWorkersOnNode(computer);
        }
        if (!(nodes = Jenkins.getInstance().getNodes()).isEmpty()) {
            for (Node node : nodes) {
                Computer computer2 = node.toComputer();
                if (computer2 == null) continue;
                this.createExecutorWorkersOnNode(computer2);
            }
        }
        logger.info("---- Num of executors running = " + this.getNumExecutors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createManagementWorker() {
        List<ManagementWorkerThread> list = this.gmwtHandles;
        synchronized (list) {
            if (!this.gmwtHandles.isEmpty()) {
                return;
            }
            ManagementWorkerThread gwt = new ManagementWorkerThread(GearmanPluginConfig.get().getHost(), GearmanPluginConfig.get().getPort(), this.masterName + "_manager", this.masterName, new NoopAvailabilityMonitor());
            this.gmwtHandles.add(gwt);
            gwt.start();
        }
        logger.info("---- Num of executors running = " + this.getNumExecutors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExecutorWorkersOnNode(Computer computer) {
        List<ExecutorWorkerThread> list = this.gewtHandles;
        synchronized (list) {
            for (ExecutorWorkerThread t : this.gewtHandles) {
                if (t.getComputer() != computer) continue;
                logger.info("---- Executor thread already running for " + computer.getName());
                return;
            }
            NodeAvailabilityMonitor availability = new NodeAvailabilityMonitor(computer);
            int executors = computer.getExecutors().size();
            for (int i = 0; i < executors; ++i) {
                String nodeName = null;
                nodeName = GearmanPluginUtil.getRealName(computer);
                if (nodeName == "master") {
                    nodeName = this.masterName;
                }
                ExecutorWorkerThread ewt = new ExecutorWorkerThread(GearmanPluginConfig.get().getHost(), GearmanPluginConfig.get().getPort(), nodeName + "_exec-" + Integer.toString(i), computer, this.masterName, availability);
                ewt.start();
                this.gewtHandles.add(ewt);
            }
        }
        logger.info("---- Num of executors running = " + this.getNumExecutors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        ArrayList<AbstractWorkerThread> stopHandles;
        Object object = this.gewtHandles;
        synchronized (object) {
            stopHandles = new ArrayList<ExecutorWorkerThread>(this.gewtHandles);
            this.gewtHandles.clear();
        }
        for (AbstractWorkerThread wt : stopHandles) {
            wt.stop();
        }
        object = this.gmwtHandles;
        synchronized (object) {
            stopHandles = new ArrayList<ManagementWorkerThread>(this.gmwtHandles);
            this.gmwtHandles.clear();
        }
        for (AbstractWorkerThread wt : stopHandles) {
            wt.stop();
        }
        logger.info("---- Num of executors running = " + this.getNumExecutors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Computer computer) {
        logger.info("---- Stop computer " + computer);
        ArrayList<ExecutorWorkerThread> workers = new ArrayList<ExecutorWorkerThread>();
        List<ExecutorWorkerThread> list = this.gewtHandles;
        synchronized (list) {
            Iterator<ExecutorWorkerThread> it = this.gewtHandles.iterator();
            while (it.hasNext()) {
                ExecutorWorkerThread t = it.next();
                if (t.getComputer() != computer) continue;
                workers.add(t);
                it.remove();
            }
        }
        for (ExecutorWorkerThread t : workers) {
            t.stop();
        }
        logger.info("---- Num of executors running = " + this.getNumExecutors());
    }

    public int getNumExecutors() {
        return this.gmwtHandles.size() + this.gewtHandles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBuildFinalized(Run r) {
        Computer computer = r.getExecutor().getOwner();
        AvailabilityMonitor availability = null;
        List<ExecutorWorkerThread> list = this.gewtHandles;
        synchronized (list) {
            for (ExecutorWorkerThread t : this.gewtHandles) {
                if (t.getComputer() != computer) continue;
                availability = t.getAvailability();
            }
        }
        if (availability != null) {
            availability.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityMonitor getAvailabilityMonitor(Computer computer) {
        List<ExecutorWorkerThread> list = this.gewtHandles;
        synchronized (list) {
            for (ExecutorWorkerThread t : this.gewtHandles) {
                if (t.getComputer() != computer) continue;
                return t.getAvailability();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        AbstractWorkerThread workerThread = null;
        List<ExecutorWorkerThread> list = this.gewtHandles;
        synchronized (list) {
            Computer computer = node.toComputer();
            for (ExecutorWorkerThread t : this.gewtHandles) {
                if (t.getComputer() != computer) continue;
                workerThread = t;
                break;
            }
        }
        if (workerThread != null) {
            if (workerThread.getAvailability().canTake(item)) {
                return null;
            }
            return new CauseOfBlockage.BecauseNodeIsBusy(node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJobs() {
        List<ExecutorWorkerThread> list = this.gewtHandles;
        synchronized (list) {
            for (ExecutorWorkerThread worker : this.gewtHandles) {
                worker.registerJobs();
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");
    }
}

