/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import com.google.common.base.Objects;
import hudson.BulkChange;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.plugins.gearman.GearmanProxy;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GearmanPluginConfig
extends GlobalConfiguration {
    private static final Logger logger = LoggerFactory.getLogger((String)"hudson.plugins.gearman.logger");
    private boolean enablePlugin;
    private String host;
    private int port;

    public GearmanPluginConfig() {
        this.load();
    }

    public static GearmanPluginConfig get() {
        return (GearmanPluginConfig)((Object)GlobalConfiguration.all().get(GearmanPluginConfig.class));
    }

    public FormValidation doTestConnection(@QueryParameter(value="host") String host, @QueryParameter(value="port") int port) throws IOException, ServletException {
        if (this.connectionIsAvailable(host, port, 5000)) {
            return FormValidation.ok((String)"Success");
        }
        return FormValidation.error((String)"Failed: Unable to Connect");
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        String prevHost = this.host;
        int prevPort = this.port;
        boolean prevEnablePlugin = this.enablePlugin;
        this.enablePlugin = json.getBoolean("enablePlugin");
        this.host = json.getString("host");
        this.port = json.getInt("port");
        if (!this.enablePlugin && prevEnablePlugin) {
            GearmanProxy.getInstance().stopAll();
        } else if (this.enablePlugin && !prevEnablePlugin) {
            if (!this.connectionIsAvailable(this.host, this.port, 5000)) {
                this.enablePlugin = false;
                throw new Descriptor.FormException("Unable to connect to Gearman server. Please check the server connection settings and retry.", "host");
            }
            GearmanProxy.getInstance().initWorkers();
        } else if (this.enablePlugin && prevEnablePlugin && (!this.host.equals(prevHost) || this.port != prevPort)) {
            GearmanProxy.getInstance().stopAll();
            if (!this.connectionIsAvailable(this.host, this.port, 5000)) {
                this.enablePlugin = false;
                throw new Descriptor.FormException("Unable to connect to Gearman server. Please check the server connection settings and retry.", "host");
            }
            GearmanProxy.getInstance().initWorkers();
        }
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            req.bindJSON((Object)this, json);
            bc.commit();
        }
        catch (IOException e) {
            bc.abort();
            throw new Descriptor.FormException("Failed to apply configuration", (Throwable)e, null);
        }
        return true;
    }

    @DataBoundSetter
    public void setHost(String host) {
        this.host = host;
        this.save();
    }

    @DataBoundSetter
    public void setPort(int port) {
        this.port = port;
        this.save();
    }

    @DataBoundSetter
    public void setEnablePlugin(boolean enablePlugin) {
        this.enablePlugin = enablePlugin;
        this.save();
    }

    public boolean isEnablePlugin() {
        return (Boolean)Objects.firstNonNull((Object)this.enablePlugin, (Object)false);
    }

    public String getHost() {
        return (String)Objects.firstNonNull((Object)this.host, (Object)"127.0.0.1");
    }

    public int getPort() {
        if (this.port == 0) {
            return 4730;
        }
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionIsAvailable(String host, int port, int timeout) {
        InetSocketAddress endPoint = new InetSocketAddress(host, port);
        Socket socket = new Socket();
        if (endPoint.isUnresolved()) {
            System.out.println("Failure " + endPoint);
        } else {
            try {
                socket.connect(endPoint, timeout);
                logger.info("Connection Success:    " + endPoint);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                logger.info("Connection Failure:    " + endPoint + " message: " + e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        logger.info(e.getMessage());
                    }
                }
            }
        }
        return false;
    }
}

