/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gearman;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.gearman.GearmanProject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class GearmanAbstractProject
extends GearmanProject<AbstractProject, AbstractBuild> {
    public GearmanAbstractProject(AbstractProject project) {
        super(project);
    }

    @Override
    public QueueTaskFuture scheduleBuild2(int quietPeriod, Cause c, Action ... actions) {
        return ((AbstractProject)this.getJob()).scheduleBuild2(quietPeriod, c, actions);
    }

    @Override
    public boolean isDisabled() {
        return ((AbstractProject)this.getJob()).isDisabled();
    }

    @Override
    public Label getAssignedLabel() {
        return ((AbstractProject)this.getJob()).getAssignedLabel();
    }

    @Override
    protected Map getBuildData(AbstractBuild run) {
        HashMap buildData = Maps.newHashMap();
        Node node = run.getBuiltOn();
        if (node != null) {
            buildData.put("node_name", node.getNodeName());
            buildData.put("node_labels", node.getAssignedLabels().stream().map(labelAtom -> labelAtom.getDisplayName()).collect(Collectors.toList()));
        }
        return buildData;
    }
}

