/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gcm.im;

import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConversionException;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.config.ParameterNames;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.gcm.Messages;
import org.jenkinsci.plugins.gcm.im.GcmImConnectionProvider;
import org.jenkinsci.plugins.gcm.im.GcmMessageTarget;
import org.jenkinsci.plugins.gcm.im.GcmPublisher;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GcmPublisherDescriptor
extends BuildStepDescriptor<Publisher>
implements IMPublisherDescriptor {
    private static final String PREFIX = "gcm.";
    public static final String PARAM_PROJECT_NUMBER = "gcm.projectNumber";
    public static final String PARAM_API_KEY = "gcm.apiKey";
    public static final String PARAM_TARGETS = "gcm.targets";
    public static final String[] PARAMETERVALUE_STRATEGY_VALUES = NotificationStrategy.getDisplayNames();
    public static final String PARAMETERVALUE_STRATEGY_DEFAULT = NotificationStrategy.STATECHANGE_ONLY.getDisplayName();
    private String projectNumber;
    private String apiKey;

    public GcmPublisherDescriptor() {
        super(GcmPublisher.class);
        this.load();
        GcmImConnectionProvider.getInstance().setDescriptor((IMPublisherDescriptor)this);
    }

    public String getDisplayName() {
        return Messages.Gcm_NotifyAndroidDevices();
    }

    public String getPluginDescription() {
        return "";
    }

    public boolean isEnabled() {
        return true;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public GcmPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String t = req.getParameter(PARAM_TARGETS);
        String[] givenTargets = t == null ? new String[]{} : t.split("[\\s,]+");
        ArrayList<IMMessageTarget> targets = new ArrayList<IMMessageTarget>(givenTargets.length);
        for (String userId : givenTargets) {
            User user = User.get((String)userId.trim(), (boolean)false);
            if (user == null) continue;
            targets.add(new GcmMessageTarget(user.getId()));
        }
        String n = req.getParameter(this.getParamNames().getStrategy());
        if (n == null) {
            n = PARAMETERVALUE_STRATEGY_DEFAULT;
        } else {
            boolean foundStrategyValueMatch = false;
            for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                if (!strategyValue.equals(n)) continue;
                foundStrategyValueMatch = true;
                break;
            }
            if (!foundStrategyValueMatch) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            }
        }
        boolean notifyStart = "on".equals(req.getParameter(this.getParamNames().getNotifyStart()));
        boolean notifySuspects = "on".equals(req.getParameter(this.getParamNames().getNotifySuspects()));
        boolean notifyCulprits = "on".equals(req.getParameter(this.getParamNames().getNotifyCulprits()));
        boolean notifyFixers = "on".equals(req.getParameter(this.getParamNames().getNotifyFixers()));
        boolean notifyUpstream = "on".equals(req.getParameter(this.getParamNames().getNotifyUpstreamCommitters()));
        MatrixJobMultiplier matrixJobMultiplier = MatrixJobMultiplier.ONLY_CONFIGURATIONS;
        if (formData.has("matrixNotifier")) {
            String o = formData.getString("matrixNotifier");
            matrixJobMultiplier = MatrixJobMultiplier.valueOf((String)o);
        }
        try {
            return new GcmPublisher(targets, n, notifyStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstream, (BuildToChatNotifier)req.bindJSON(BuildToChatNotifier.class, formData.getJSONObject("buildToChatNotifier")), matrixJobMultiplier);
        }
        catch (IMMessageTargetConversionException e) {
            throw new Descriptor.FormException((Throwable)e, PARAM_TARGETS);
        }
    }

    public AutoCompletionCandidates doAutoCompleteTargets(@QueryParameter String value) {
        AutoCompletionCandidates candidates = new AutoCompletionCandidates();
        value = value.toLowerCase();
        for (User user : User.getAll()) {
            if (user == User.getUnknown() || !user.getId().toLowerCase().startsWith(value) && !user.getFullName().toLowerCase().startsWith(value)) continue;
            candidates.add(user.getId());
        }
        return candidates;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.projectNumber = req.getParameter(PARAM_PROJECT_NUMBER);
        this.apiKey = req.getParameter(PARAM_API_KEY);
        this.save();
        return super.configure(req, json);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public IMMessageTargetConverter getIMMessageTargetConverter() {
        return new IMMessageTargetConverter(){

            public String toString(IMMessageTarget target) {
                return target.toString();
            }

            public IMMessageTarget fromString(String userId) throws IMMessageTargetConversionException {
                return new GcmMessageTarget(userId);
            }
        };
    }

    public List<IMMessageTarget> getDefaultTargets() {
        return Collections.emptyList();
    }

    public ParameterNames getParamNames() {
        return new ParameterNames(){

            protected String getPrefix() {
                return GcmPublisherDescriptor.PREFIX;
            }
        };
    }

    public boolean isExposePresence() {
        return false;
    }

    public String getHost() {
        return null;
    }

    public String getHostname() {
        return null;
    }

    public int getPort() {
        return 0;
    }

    public String getHudsonUserName() {
        return null;
    }

    public String getUserName() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public String getCommandPrefix() {
        return null;
    }

    public String getDefaultIdSuffix() {
        return null;
    }
}

