/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.triggers.filecontent;

import hudson.Extension;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileTypeDescriptor;
import org.jenkinsci.plugins.fstrigger.triggers.filecontent.XMLFileContentEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLFileContent
extends FSTriggerContentFileType {
    private transient Map<String, Object> results;
    private transient Document xmlDocument;
    private List<XMLFileContentEntry> expressions = new ArrayList<XMLFileContentEntry>();
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public XMLFileContent(List<XMLFileContentEntry> element) {
        if (element != null) {
            this.expressions = element;
        }
    }

    @Override
    public Object getMemoryInfo() {
        return this.results;
    }

    @Override
    public void setMemoryInfo(Object memoryInfo) {
        if (memoryInfo != null && !(memoryInfo instanceof Map)) {
            throw new IllegalArgumentException(String.format("The memory info %s object is not a Map object.", memoryInfo));
        }
        this.results = (Map)memoryInfo;
    }

    public List<XMLFileContentEntry> getExpressions() {
        return this.expressions;
    }

    @Override
    protected void initForContent(File file) throws XTriggerException {
        this.xmlDocument = this.initXMLFile(file);
        this.results = this.readXMLPath(this.xmlDocument);
    }

    private Document initXMLFile(File file) throws XTriggerException {
        Document xmlDocument;
        try {
            xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (SAXException e) {
            throw new XTriggerException((Throwable)e);
        }
        catch (IOException e) {
            throw new XTriggerException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new XTriggerException((Throwable)e);
        }
        return xmlDocument;
    }

    private Map<String, Object> readXMLPath(Document document) throws XTriggerException {
        HashMap<String, Object> results = new HashMap<String, Object>(this.expressions.size());
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            for (XMLFileContentEntry expressionEntry : this.expressions) {
                String expression = expressionEntry.getExpression();
                XPathExpression xPathExpression = xPath.compile(expression);
                String result = xPathExpression.evaluate(document);
                results.put(expression, result);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new XTriggerException((Throwable)xpe);
        }
        return results;
    }

    @Override
    protected boolean isTriggeringBuildForContent(File file, XTriggerLog log) throws XTriggerException {
        Document newDocument = this.initXMLFile(file);
        Map<String, Object> newResults = this.readXMLPath(newDocument);
        if (this.results == null) {
            throw new NullPointerException("Initial result object must not be a null reference.");
        }
        if (newResults == null) {
            throw new NullPointerException("New computed results object must not be a null reference.");
        }
        if (this.results.size() != newResults.size()) {
            throw new XTriggerException("Regarding the trigger life cycle, the size between old results and new results have to be the same.");
        }
        if (!this.results.keySet().containsAll(newResults.keySet())) {
            throw new XTriggerException("Regarding the set up of the result objects, the keys for the old results and the new results have to the same.");
        }
        for (Map.Entry<String, Object> entry : this.results.entrySet()) {
            String expression = entry.getKey();
            Object initValue = entry.getValue();
            Object newValue = newResults.get(expression);
            if (initValue == null && newValue == null) {
                log.info(String.format("There is no matching for the expression '%s'.", expression));
                continue;
            }
            if (initValue == null) {
                log.info(String.format("There was no value and there is a new value for the expression '%s'.", expression));
                return true;
            }
            if (newValue == null) {
                log.info(String.format("There was a value and now the there is no value for the expression '%s'.", expression));
                return true;
            }
            if (initValue.equals(newValue)) continue;
            log.info(String.format("The value for the expression '%s' has changed.", expression));
            return true;
        }
        return false;
    }

    @Extension
    public static class XMLFileContentDescriptor
    extends FSTriggerContentFileTypeDescriptor<XMLFileContent> {
        @Override
        public Class<? extends FSTriggerContentFileType> getType() {
            return XMLFileContent.class;
        }

        public String getDisplayName() {
            return "Monitor the contents of an XML file";
        }

        @Override
        public String getLabel() {
            return "XML File";
        }

        public FormValidation doCheckXpath(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"You must provide an XPath.");
            }
            return FormValidation.ok();
        }
    }
}

