/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fstrigger.service;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.fstrigger.core.FSTriggerContentFileType;
import org.jenkinsci.plugins.fstrigger.triggers.FileNameTriggerInfo;

public class FSTriggerFileNameCheckedModifiedService {
    private final XTriggerLog log;
    private final FileNameTriggerInfo fileInfo;
    private final File resolvedFile;
    private final long lastModifiedDateTime;
    private final File newResolvedFile;

    public FSTriggerFileNameCheckedModifiedService(XTriggerLog log, FileNameTriggerInfo fileInfo, String resolvedFilePath, Long resolvedFileLastModified, File newResolvedFile) {
        if (log == null) {
            throw new NullPointerException("The log object must be set.");
        }
        if (fileInfo == null) {
            throw new NullPointerException("The file info object must be set.");
        }
        this.log = log;
        this.fileInfo = fileInfo;
        this.resolvedFile = resolvedFilePath == null ? null : new File(resolvedFilePath);
        this.lastModifiedDateTime = resolvedFileLastModified;
        this.newResolvedFile = newResolvedFile;
    }

    public Boolean checkFileName() throws XTriggerException {
        if (this.newResolvedFile == null) {
            this.log.info("The computed file doesn't exist.");
            return false;
        }
        if (this.resolvedFile == null) {
            this.log.info("The file didn't exist for the previous polling and now it exists.");
            return true;
        }
        if (!this.resolvedFile.equals(this.newResolvedFile)) {
            this.log.info("The current polling file has changed.");
            return true;
        }
        if (!this.fileInfo.isDoNotCheckLastModificationDate() && this.newResolvedFile.lastModified() != this.lastModifiedDateTime) {
            this.log.info("The last modification date of the file '" + this.newResolvedFile + "' has changed.\n");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
            Date lastModifiedDate = new Date(this.lastModifiedDateTime);
            Date newResolvedFileDate = new Date(this.newResolvedFile.lastModified());
            this.log.info("The last date/time was   " + simpleDateFormat.format(lastModifiedDate));
            this.log.info("The current date/time is " + simpleDateFormat.format(newResolvedFileDate));
            return true;
        }
        return false;
    }

    public Boolean checkContentType(FSTriggerContentFileType type) throws XTriggerException {
        return type.isTriggeringBuild(this.newResolvedFile, this.log);
    }
}

