/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.steps;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import java.util.Set;
import org.jenkinsci.plugins.fodupload.SharedUploadBuildStep;
import org.jenkinsci.plugins.fodupload.steps.FortifyStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"unused"})
public class FortifyStaticAssessment
extends FortifyStep {
    private static final ThreadLocal<TaskListener> taskListener = new ThreadLocal();
    private String bsiToken;
    private boolean overrideGlobalConfig;
    private String username;
    private String personalAccessToken;
    private String tenantId;
    private boolean purchaseEntitlements;
    private String entitlementPreference;
    private String srcLocation;
    private String remediationScanPreferenceType;
    private String inProgressScanActionType;
    private SharedUploadBuildStep commonBuildStep;

    @DataBoundConstructor
    public FortifyStaticAssessment(String bsiToken) {
        this.bsiToken = bsiToken != null ? bsiToken.trim() : "";
    }

    public String getBsiToken() {
        return this.bsiToken;
    }

    public boolean getOverrideGlobalConfig() {
        return this.overrideGlobalConfig;
    }

    @DataBoundSetter
    public void setOverrideGlobalConfig(boolean overrideGlobalConfig) {
        this.overrideGlobalConfig = overrideGlobalConfig;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPersonalAccessToken() {
        return this.personalAccessToken;
    }

    @DataBoundSetter
    public void setPersonalAccessToken(String personalAccessToken) {
        this.personalAccessToken = personalAccessToken;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @DataBoundSetter
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean getPurchaseEntitlements() {
        return this.purchaseEntitlements;
    }

    @DataBoundSetter
    public void setPurchaseEntitlements(boolean purchaseEntitlements) {
        this.purchaseEntitlements = purchaseEntitlements;
    }

    public String getEntitlementPreference() {
        return this.entitlementPreference;
    }

    @DataBoundSetter
    public void setEntitlementPreference(String entitlementPreference) {
        this.entitlementPreference = entitlementPreference;
    }

    public String getSrcLocation() {
        return this.srcLocation;
    }

    @DataBoundSetter
    public void setSrcLocation(String srcLocation) {
        this.srcLocation = srcLocation != null ? srcLocation.trim() : "";
    }

    public String getRemediationScanPreferenceType() {
        return this.remediationScanPreferenceType;
    }

    @DataBoundSetter
    public void setRemediationScanPreferenceType(String remediationScanPreferenceType) {
        this.remediationScanPreferenceType = remediationScanPreferenceType;
    }

    public String getInProgressScanActionType() {
        return this.inProgressScanActionType;
    }

    @DataBoundSetter
    public void setInProgressScanActionType(String inProgressScanActionType) {
        this.inProgressScanActionType = inProgressScanActionType;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        PrintStream log = listener.getLogger();
        log.println("Fortify on Demand Upload PreBuild Running...");
        this.commonBuildStep = new SharedUploadBuildStep(this.bsiToken, this.overrideGlobalConfig, this.username, this.personalAccessToken, this.tenantId, this.purchaseEntitlements, this.entitlementPreference, this.srcLocation, this.remediationScanPreferenceType, this.inProgressScanActionType);
        return true;
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        PrintStream log = listener.getLogger();
        log.println("Fortify on Demand Upload Running...");
        this.commonBuildStep = new SharedUploadBuildStep(this.bsiToken, this.overrideGlobalConfig, this.username, this.personalAccessToken, this.tenantId, this.purchaseEntitlements, this.entitlementPreference, this.srcLocation, this.remediationScanPreferenceType, this.inProgressScanActionType);
        this.commonBuildStep.perform(build, workspace, launcher, listener);
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private transient FortifyStaticAssessment upload;

        protected Execution(FortifyStaticAssessment upload, StepContext context) {
            super(context);
            this.upload = upload;
        }

        protected Void run() throws Exception {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running fodStaticAssessment step");
            this.upload.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Run Fortify on Demand Upload";
        }

        public String getFunctionName() {
            return "fodStaticAssessment";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public FormValidation doTestPersonalAccessTokenConnection(@QueryParameter(value="username") String username, @QueryParameter(value="personalAccessToken") String personalAccessToken, @QueryParameter(value="tenantId") String tenantId) {
            return SharedUploadBuildStep.doTestPersonalAccessTokenConnection(username, personalAccessToken, tenantId);
        }

        public ListBoxModel doFillEntitlementPreferenceItems() {
            return SharedUploadBuildStep.doFillEntitlementPreferenceItems();
        }

        public ListBoxModel doFillRemediationScanPreferenceTypeItems() {
            return SharedUploadBuildStep.doFillRemediationScanPreferenceTypeItems();
        }

        public ListBoxModel doFillUsernameItems() {
            return SharedUploadBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillPersonalAccessTokenItems() {
            return SharedUploadBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillTenantIdItems() {
            return SharedUploadBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillInProgressScanActionTypeItems() {
            return SharedUploadBuildStep.doFillInProgressScanActionTypeItems();
        }
    }
}

