/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.steps;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import org.jenkinsci.plugins.fodupload.SharedPollingBuildStep;
import org.jenkinsci.plugins.fodupload.steps.FortifyStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"unused"})
public class FortifyPollResults
extends FortifyStep {
    private String bsiToken;
    private int pollingInterval;
    private boolean overrideGlobalConfig;
    private int policyFailureBuildResultPreference;
    private String clientId;
    private String clientSecret;
    private String username;
    private String personalAccessToken;
    private String tenantId;
    private SharedPollingBuildStep commonBuildStep;

    @DataBoundConstructor
    public FortifyPollResults(String bsiToken, int pollingInterval) {
        this.bsiToken = bsiToken != null ? bsiToken.trim() : "";
        this.pollingInterval = pollingInterval;
    }

    public String getBsiToken() {
        return this.bsiToken;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean getOverrideGlobalConfig() {
        return this.overrideGlobalConfig;
    }

    @DataBoundSetter
    public void setOverrideGlobalConfig(boolean overrideGlobalConfig) {
        this.overrideGlobalConfig = overrideGlobalConfig;
    }

    public int getPolicyFailureBuildResultPreference() {
        return this.policyFailureBuildResultPreference;
    }

    @DataBoundSetter
    public void setPolicyFailureBuildResultPreference(int policyFailureBuildResultPreference) {
        this.policyFailureBuildResultPreference = policyFailureBuildResultPreference;
    }

    public String getClientId() {
        return this.clientId;
    }

    @DataBoundSetter
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @DataBoundSetter
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPersonalAccessToken() {
        return this.personalAccessToken;
    }

    @DataBoundSetter
    public void setPersonalAccessToken(String personalAccessToken) {
        this.personalAccessToken = personalAccessToken;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @DataBoundSetter
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        PrintStream log = listener.getLogger();
        log.println("Fortify on Demand Poll Results PreBuild Running...");
        this.commonBuildStep = new SharedPollingBuildStep(this.bsiToken, this.overrideGlobalConfig, this.pollingInterval, this.policyFailureBuildResultPreference, this.clientId, this.clientSecret, this.username, this.personalAccessToken, this.tenantId);
        return true;
    }

    @Override
    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream log = listener.getLogger();
        log.println("Fortify on Demand Poll Results Running...");
        this.commonBuildStep = new SharedPollingBuildStep(this.bsiToken, this.overrideGlobalConfig, this.pollingInterval, this.policyFailureBuildResultPreference, this.clientId, this.clientSecret, this.username, this.personalAccessToken, this.tenantId);
        this.commonBuildStep.perform(build, workspace, launcher, listener);
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private transient FortifyPollResults polling;

        protected Execution(FortifyPollResults polling, StepContext context) {
            super(context);
            this.polling = polling;
        }

        protected Void run() throws Exception {
            ((TaskListener)this.getContext().get(TaskListener.class)).getLogger().println("Running fodPollResults step");
            this.polling.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Poll Fortify on Demand for Results";
        }

        public String getFunctionName() {
            return "fodPollResults";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class);
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public FormValidation doTestPersonalAccessTokenConnection(@QueryParameter(value="username") String username, @QueryParameter(value="personalAccessToken") String personalAccessToken, @QueryParameter(value="tenantId") String tenantId) {
            return SharedPollingBuildStep.doTestPersonalAccessTokenConnection(username, personalAccessToken, tenantId);
        }

        public ListBoxModel doFillPolicyFailureBuildResultPreferenceItems() {
            return SharedPollingBuildStep.doFillPolicyFailureBuildResultPreferenceItems();
        }

        public ListBoxModel doFillUsernameItems() {
            return SharedPollingBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillPersonalAccessTokenItems() {
            return SharedPollingBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillTenantIdItems() {
            return SharedPollingBuildStep.doFillStringCredentialsItems();
        }
    }
}

