/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.polling;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.controllers.ReleaseController;
import org.jenkinsci.plugins.fodupload.controllers.StaticScanSummaryController;
import org.jenkinsci.plugins.fodupload.models.AnalysisStatusTypeEnum;
import org.jenkinsci.plugins.fodupload.models.response.LookupItemsModel;
import org.jenkinsci.plugins.fodupload.models.response.ReleaseDTO;
import org.jenkinsci.plugins.fodupload.models.response.ScanSummaryDTO;
import org.jenkinsci.plugins.fodupload.polling.PollReleaseStatusResult;

class StatusPollerThread
extends Thread {
    public Boolean fail = false;
    public Boolean finished = false;
    public String statusString;
    public PollReleaseStatusResult result = new PollReleaseStatusResult();
    public ScanSummaryDTO scanSummaryDTO = null;
    public ReleaseDTO releaseDTO = null;
    private PrintStream logger;
    private int releaseId;
    private int pollingInterval;
    private ReleaseController releaseController;
    private StaticScanSummaryController scanSummaryController;
    private List<LookupItemsModel> analysisStatusTypes;
    private List<String> completeStatusList;

    StatusPollerThread(String name, int releaseId, List<LookupItemsModel> analysisStatusTypes, FodApiConnection apiConnection, List<String> completeStatusList, PrintStream logger, int pollingInterval) {
        super(name);
        this.releaseId = releaseId;
        this.analysisStatusTypes = analysisStatusTypes;
        this.logger = logger;
        this.releaseController = new ReleaseController(apiConnection);
        this.scanSummaryController = new StaticScanSummaryController(apiConnection, logger);
        this.completeStatusList = completeStatusList;
        this.pollingInterval = pollingInterval;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(60000L * (long)this.pollingInterval);
            this.processScanRelease();
        }
        catch (InterruptedException e) {
            this.logger.println("API call to retrieve scan status was terminated. Please contact your system adminstrator if termination was not intentional");
            Thread.currentThread().interrupt();
        }
    }

    private void processScanRelease() {
        int status = -1;
        try {
            this.releaseDTO = this.releaseController.getRelease(this.releaseId, "currentAnalysisStatusTypeId,isPassed,passFailReasonTypeId,passFailReasonType,critical,high,medium,low,releaseId,rating,currentStaticScanId,releaseName");
            status = this.releaseDTO.getCurrentAnalysisStatusTypeId();
        }
        catch (IOException e) {
            this.logger.println("Unable to retreive release data");
        }
        if (this.releaseDTO == null) {
            this.fail = true;
            this.logger.println("Release data is not retrieved");
        }
        for (LookupItemsModel o : this.analysisStatusTypes) {
            if (o != null) {
                int analysisStatusInt = Integer.parseInt(o.getValue());
                if (analysisStatusInt == status) {
                    this.statusString = o.getText().replace("_", " ");
                }
                if (!this.completeStatusList.contains(Integer.toString(status))) continue;
                this.finished = true;
                continue;
            }
            this.fail = true;
        }
        if (this.statusString == null || this.statusString == "") {
            this.fail = true;
        } else {
            if (this.statusString.equals(AnalysisStatusTypeEnum.Waiting.name())) {
                try {
                    this.scanSummaryDTO = this.scanSummaryController.getReleaseScanSummary(this.releaseDTO.getReleaseId(), this.releaseDTO.getCurrentStaticScanId());
                    this.finished = true;
                }
                catch (IOException e) {
                    this.logger.println("Unable to retrieve scan summary data. Error: " + e.toString());
                    this.fail = true;
                }
            }
            if (this.finished.booleanValue()) {
                this.result.setPassing(this.releaseDTO.isPassed());
                this.result.setPollingSuccessful(true);
                if (!Utils.isNullOrEmpty(this.releaseDTO.getPassFailReasonType())) {
                    this.result.setFailReason(this.releaseDTO.getPassFailReasonType());
                }
                if (this.statusString.equals(AnalysisStatusTypeEnum.Canceled.name())) {
                    try {
                        this.scanSummaryDTO = this.scanSummaryController.getReleaseScanSummary(this.releaseDTO.getReleaseId(), this.releaseDTO.getCurrentStaticScanId());
                    }
                    catch (IOException e) {
                        this.logger.println("Unable to retrieve scan summary data. Error: " + e.toString());
                        this.fail = true;
                    }
                }
            }
        }
    }
}

