/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.polling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.controllers.LookupItemsController;
import org.jenkinsci.plugins.fodupload.models.AnalysisStatusTypeEnum;
import org.jenkinsci.plugins.fodupload.models.FodEnums;
import org.jenkinsci.plugins.fodupload.models.response.LookupItemsModel;
import org.jenkinsci.plugins.fodupload.models.response.ReleaseDTO;
import org.jenkinsci.plugins.fodupload.models.response.ScanPauseDetail;
import org.jenkinsci.plugins.fodupload.models.response.ScanSummaryDTO;
import org.jenkinsci.plugins.fodupload.polling.PollReleaseStatusResult;
import org.jenkinsci.plugins.fodupload.polling.StatusPollerThread;

public class ScanStatusPoller {
    private static final int MAX_FAILS = 3;
    private FodApiConnection apiConnection;
    private int failCount = 0;
    private int pollingInterval;
    private PrintStream logger;

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public ScanStatusPoller(FodApiConnection apiConnection, int pollingInterval, PrintStream logger) {
        this.apiConnection = apiConnection;
        this.pollingInterval = pollingInterval;
        this.logger = logger;
    }

    public PollReleaseStatusResult pollReleaseStatus(int releaseId) throws IOException, InterruptedException {
        Thread pollerThread;
        block14: {
            this.logger.println("Begin polling Fortify on Demand for results.");
            boolean finished = false;
            int counter = 1;
            LookupItemsController lookupItemsController = new LookupItemsController(this.apiConnection);
            List<LookupItemsModel> analysisStatusTypes = lookupItemsController.getLookupItems(FodEnums.APILookupItemTypes.AnalysisStatusTypes);
            pollerThread = null;
            ArrayList<String> complete = new ArrayList<String>();
            if (analysisStatusTypes != null) {
                for (LookupItemsModel item : analysisStatusTypes) {
                    if (!item.getText().equalsIgnoreCase(AnalysisStatusTypeEnum.Completed.name()) && !item.getText().equalsIgnoreCase(AnalysisStatusTypeEnum.Canceled.name())) continue;
                    complete.add(item.getValue());
                }
            }
            try {
                while (!finished) {
                    if (analysisStatusTypes == null) {
                        analysisStatusTypes = lookupItemsController.getLookupItems(FodEnums.APILookupItemTypes.AnalysisStatusTypes);
                        complete = new ArrayList();
                        for (LookupItemsModel item : analysisStatusTypes) {
                            if (!item.getText().equalsIgnoreCase(AnalysisStatusTypeEnum.Completed.name()) && !item.getText().equalsIgnoreCase(AnalysisStatusTypeEnum.Canceled.name())) continue;
                            complete.add(item.getValue());
                        }
                    }
                    pollerThread = counter == 1 ? new StatusPollerThread(String.valueOf(counter), releaseId, analysisStatusTypes, this.apiConnection, complete, this.logger, 0) : new StatusPollerThread(String.valueOf(counter), releaseId, analysisStatusTypes, this.apiConnection, complete, this.logger, this.pollingInterval);
                    pollerThread.start();
                    pollerThread.join();
                    if (((StatusPollerThread)pollerThread).fail.booleanValue()) {
                        ++this.failCount;
                        continue;
                    }
                    if (this.failCount < 3) {
                        if (((StatusPollerThread)pollerThread).fail.booleanValue()) continue;
                        this.failCount = 0;
                        this.logger.println(pollerThread.getName() + ") Poll Status: " + ((StatusPollerThread)pollerThread).statusString);
                        if (((StatusPollerThread)pollerThread).statusString.equals(AnalysisStatusTypeEnum.Waiting.name()) && ((StatusPollerThread)pollerThread).scanSummaryDTO.getPauseDetails() != null) {
                            this.printPauseMessages(((StatusPollerThread)pollerThread).scanSummaryDTO);
                        }
                        if (((StatusPollerThread)pollerThread).finished.booleanValue()) {
                            finished = ((StatusPollerThread)pollerThread).finished;
                            if (((StatusPollerThread)pollerThread).statusString.equals(AnalysisStatusTypeEnum.Canceled.name())) {
                                this.printCancelMessages(((StatusPollerThread)pollerThread).scanSummaryDTO);
                            } else if (((StatusPollerThread)pollerThread).statusString.equals(AnalysisStatusTypeEnum.Completed.name())) {
                                this.printPassFail(((StatusPollerThread)pollerThread).releaseDTO);
                            }
                        }
                        ++counter;
                        continue;
                    }
                    this.logger.println(String.format("Polling Failed %d times.  Terminating", 3));
                    finished = true;
                }
            }
            catch (InterruptedException e) {
                this.logger.println("Polling was interrupted. Please contact your administrator if the interruption was not intentional.");
                if (!pollerThread.isAlive()) break block14;
                pollerThread.interrupt();
            }
        }
        return ((StatusPollerThread)pollerThread).result;
    }

    private void printPassFail(ReleaseDTO release) {
        boolean isPassed = release.isPassed();
        this.logger.println(String.format("Critical: %d", release.getCritical()));
        this.logger.println(String.format("High:     %d", release.getHigh()));
        this.logger.println(String.format("Medium:   %d", release.getMedium()));
        this.logger.println(String.format("Low:      %d", release.getLow()));
        this.logger.println("For application status details see the customer portal: ");
        this.logger.println(String.format("%s/Redirect/Releases/%d", this.apiConnection.getBaseUrl(), release.getReleaseId()));
        this.logger.println(String.format("Scan %s established policy check", isPassed ? "passed" : "failed"));
        if (!isPassed) {
            String passFailReason = release.getPassFailReasonType() == null ? "Pass/Fail Policy requirements not met " : release.getPassFailReasonType();
            this.logger.println("Failure Reason:         " + passFailReason);
        }
    }

    private void printCancelMessages(ScanSummaryDTO scanSummary) {
        if (scanSummary == null) {
            this.logger.println("Unable to retrieve scan summary data cancel reasons");
        } else {
            this.logger.println("-------Scan Cancelled------- ");
            this.logger.println();
            this.logger.println(String.format("Cancel reason:        %s", scanSummary.getCancelReason()));
            this.logger.println(String.format("Cancel reason notes:  %s", scanSummary.getAnalysisStatusReasonNotes()));
            this.logger.println();
            this.logger.println("For application status details see the customer portal: ");
            this.logger.println(String.format("%s/Redirect/Releases/%d", this.apiConnection.getBaseUrl(), scanSummary.getReleaseId()));
            this.logger.println();
        }
    }

    private void printPauseMessages(ScanSummaryDTO scanSummary) {
        if (scanSummary == null) {
            this.logger.println("Unable to retrieve scan summary data pause reasons");
        } else {
            this.logger.println("-------Scan Paused------- ");
            this.logger.println();
            for (ScanPauseDetail spd : scanSummary.getPauseDetails()) {
                this.logger.println(String.format("Pause reason:         %s", spd.getReason()));
                this.logger.println(String.format("Pause reason notes:   %s", spd.getNotes()));
                this.logger.println();
            }
        }
    }
}

