/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.models;

import com.fortify.fod.parser.BsiToken;
import com.fortify.fod.parser.BsiTokenParser;
import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class JobModel {
    private static final BsiTokenParser tokenParser = new BsiTokenParser();
    private String bsiTokenOriginal;
    private transient BsiToken bsiTokenCache;
    private boolean purchaseEntitlements;
    private String entitlementPreference;
    private String srcLocation;
    private String remediationScanPreferenceType;
    private String inProgressScanActionType;
    private File payload;

    public JobModel(String bsiToken, boolean purchaseEntitlements, String entitlementPreference, String srcLocation, String remediationScanPreferenceType, String inProgressScanActionType) {
        this.bsiTokenOriginal = bsiToken;
        this.entitlementPreference = entitlementPreference;
        this.purchaseEntitlements = purchaseEntitlements;
        this.srcLocation = srcLocation;
        this.remediationScanPreferenceType = remediationScanPreferenceType;
        this.inProgressScanActionType = inProgressScanActionType;
    }

    public File getPayload() {
        return this.payload;
    }

    public void setPayload(File payload) {
        this.payload = payload;
    }

    public BsiToken getBsiToken() {
        return this.bsiTokenCache;
    }

    public boolean isPurchaseEntitlements() {
        return this.purchaseEntitlements;
    }

    public String getEntitlementPreference() {
        return this.entitlementPreference;
    }

    public String getBsiTokenOriginal() {
        return this.bsiTokenOriginal;
    }

    public String getSrcLocation() {
        return this.srcLocation;
    }

    public String getRemediationScanPreferenceType() {
        return this.remediationScanPreferenceType;
    }

    public String getInProgressScanActionType() {
        return this.inProgressScanActionType;
    }

    private Object readResolve() throws URISyntaxException, UnsupportedEncodingException {
        this.bsiTokenCache = tokenParser.parse(this.bsiTokenOriginal);
        return this;
    }

    public String toString() {
        return String.format("Release Id:                        %s%nAssessment Type Id:                %s%nTechnology Stack:                  %s%nLanguage Level:                    %s%nPurchase Entitlements:             %s%nEntitlement Preference:            %s%nIn Progress Scan Action:           %s%n", this.bsiTokenCache.getProjectVersionId(), this.bsiTokenCache.getAssessmentTypeId(), this.bsiTokenCache.getTechnologyStack(), this.bsiTokenCache.getLanguageLevel(), this.purchaseEntitlements, this.entitlementPreference, this.inProgressScanActionType);
    }

    public boolean initializeBuildModel() {
        try {
            this.bsiTokenCache = tokenParser.parse(this.bsiTokenOriginal);
        }
        catch (Exception ex) {
            return false;
        }
        return this.bsiTokenCache != null;
    }

    public boolean validate(PrintStream logger) {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.bsiTokenCache.getAssessmentTypeId() == 0) {
            errors.add("Assessment Type");
        }
        if (this.bsiTokenCache.getTechnologyType() == null) {
            errors.add("Technology Stack");
        }
        if (this.bsiTokenCache.getProjectVersionId() == 0) {
            errors.add("Release Id");
        }
        if (errors.size() > 0) {
            logger.println("Missing the following fields from BSI Token: ");
            for (String error : errors) {
                logger.println("    " + error);
            }
            return false;
        }
        return true;
    }
}

