/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.controllers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Type;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.controllers.ControllerBase;
import org.jenkinsci.plugins.fodupload.models.response.ScanSummaryDTO;

public class StaticScanSummaryController
extends ControllerBase {
    private PrintStream logger;

    public StaticScanSummaryController(FodApiConnection apiConnection, PrintStream logger) {
        super(apiConnection);
        this.logger = logger;
    }

    public ScanSummaryDTO getReleaseScanSummary(int releaseId, int scanId) throws IOException {
        if (this.apiConnection.getToken() == null) {
            this.apiConnection.authenticate();
        }
        HttpUrl.Builder builder = HttpUrl.parse((String)this.apiConnection.getApiUrl()).newBuilder().addPathSegments(String.format("/api/v3/releases/%d/scans/%d", releaseId, scanId));
        this.logger.println("--------------------------");
        this.logger.println("Retrieving scan summary data");
        this.logger.println(String.format("ReleaseID: %s; ScanID: %s", releaseId, scanId));
        this.logger.println("--------------------------");
        String url = builder.build().toString();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.apiConnection.getToken()).addHeader("Accept", "application/json").get().build();
        Response response = this.apiConnection.getClient().newCall(request).execute();
        if (response.code() == 403) {
            this.apiConnection.authenticate();
            response = this.apiConnection.getClient().newCall(request).execute();
        }
        String content = IOUtils.toString((InputStream)response.body().byteStream(), (String)"utf-8");
        response.body().close();
        Gson gson = new Gson();
        Type t = new TypeToken<ScanSummaryDTO>(){}.getType();
        ScanSummaryDTO results = (ScanSummaryDTO)gson.fromJson(content, t);
        if (results != null) {
            return results;
        }
        this.logger.println("Error retrieving scan summary data from API. Please log into online website to view summary information.");
        this.logger.println(String.format("API response code: %s", response.code()));
        return null;
    }
}

