/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.controllers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.controllers.ControllerBase;
import org.jenkinsci.plugins.fodupload.models.FodApiFilterList;
import org.jenkinsci.plugins.fodupload.models.JobModel;
import org.jenkinsci.plugins.fodupload.models.response.GenericListResponse;
import org.jenkinsci.plugins.fodupload.models.response.ReleaseAssessmentTypeDTO;
import org.jenkinsci.plugins.fodupload.models.response.ReleaseDTO;

public class ReleaseController
extends ControllerBase {
    public ReleaseController(FodApiConnection apiConnection) {
        super(apiConnection);
    }

    public ReleaseDTO getRelease(int releaseId, String fields) throws IOException {
        if (this.apiConnection.getToken() == null) {
            this.apiConnection.authenticate();
        }
        FodApiFilterList filters = new FodApiFilterList().addFilter("releaseId", releaseId);
        HttpUrl.Builder builder = HttpUrl.parse((String)this.apiConnection.getApiUrl()).newBuilder().addPathSegments("/api/v3/releases").addQueryParameter("limit", "1").addQueryParameter("filters", filters.toString());
        if (fields.length() > 0) {
            builder = builder.addQueryParameter("fields", fields);
        }
        String url = builder.build().toString();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.apiConnection.getToken()).addHeader("Accept", "application/json").get().build();
        Response response = this.apiConnection.getClient().newCall(request).execute();
        if (response.code() == 403) {
            this.apiConnection.authenticate();
        }
        String content = IOUtils.toString((InputStream)response.body().byteStream(), (String)"utf-8");
        response.body().close();
        Gson gson = new Gson();
        Type t = new TypeToken<GenericListResponse<ReleaseDTO>>(){}.getType();
        GenericListResponse results = (GenericListResponse)gson.fromJson(content, t);
        if (results.getItems().size() > 0) {
            return (ReleaseDTO)results.getItems().get(0);
        }
        return null;
    }

    ReleaseAssessmentTypeDTO getAssessmentType(JobModel model) throws IOException, URISyntaxException {
        FodApiFilterList filters = new FodApiFilterList().addFilter("frequencyTypeId", model.getEntitlementPreference()).addFilter("assessmentTypeId", model.getBsiToken().getAssessmentTypeId());
        String url = HttpUrl.parse((String)this.apiConnection.getApiUrl()).newBuilder().addPathSegments(String.format("/api/v3/releases/%s/assessment-types", model.getBsiToken().getProjectVersionId())).addQueryParameter("scanType", "1").addQueryParameter("filters", filters.toString()).build().toString();
        if (this.apiConnection.getToken() == null) {
            this.apiConnection.authenticate();
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.apiConnection.getToken()).addHeader("Accept", "application/json").get().build();
        Response response = this.apiConnection.getClient().newCall(request).execute();
        if (response.code() == 403) {
            this.apiConnection.authenticate();
        }
        String content = IOUtils.toString((InputStream)response.body().byteStream(), (String)"utf-8");
        response.body().close();
        if (!Utils.isNullOrEmpty(content)) {
            Gson gson = new Gson();
            Type t = new TypeToken<GenericListResponse<ReleaseAssessmentTypeDTO>>(){}.getType();
            GenericListResponse results = (GenericListResponse)gson.fromJson(content, t);
            for (ReleaseAssessmentTypeDTO assessment : results.getItems()) {
                if (!model.isPurchaseEntitlements() && assessment.getEntitlementId() <= 0) continue;
                return assessment;
            }
        }
        return null;
    }
}

