/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.controllers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.controllers.ControllerBase;
import org.jenkinsci.plugins.fodupload.models.FodEnums;
import org.jenkinsci.plugins.fodupload.models.response.GenericListResponse;
import org.jenkinsci.plugins.fodupload.models.response.LookupItemsModel;

public class LookupItemsController
extends ControllerBase {
    public LookupItemsController(FodApiConnection apiConnection) {
        super(apiConnection);
    }

    public List<LookupItemsModel> getLookupItems(FodEnums.APILookupItemTypes type) throws IOException {
        if (this.apiConnection.getToken() == null) {
            this.apiConnection.authenticate();
        }
        String url = HttpUrl.parse((String)this.apiConnection.getApiUrl()).newBuilder().addPathSegments("/api/v3/lookup-items").addQueryParameter("type", type.toString()).build().toString();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.apiConnection.getToken()).addHeader("Accept", "application/json").get().build();
        Response response = this.apiConnection.getClient().newCall(request).execute();
        String content = IOUtils.toString((InputStream)response.body().byteStream(), (String)"utf-8");
        response.body().close();
        Gson gson = new Gson();
        Type t = new TypeToken<GenericListResponse<LookupItemsModel>>(){}.getType();
        GenericListResponse results = (GenericListResponse)gson.fromJson(content, t);
        return results.getItems();
    }
}

