/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.FilePath;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.fodupload.RegexFileFilter;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class Utils {
    private static final String TS_DOT_NET_KEY = ".NET";
    private static final String TS_JAVA_KEY = "JAVA/J2EE";
    private static final String TS_RUBY_KEY = "Ruby";
    private static final String TS_PYTHON_KEY = "Python";
    private static final String TS_OBJECTIVE_C_KEY = "Objective-C";
    private static final String TS_ABAP_KEY = "ABAP";
    private static final String TS_ASP_KEY = "ASP";
    private static final String TS_CFML_KEY = "CFML";
    private static final String TS_COBOL_KEY = "COBOL";
    private static final String TS_ANDROID_KEY = "Android";
    private static final String TS_PHP_KEY = "PHP";
    private static final String TS_PLSQL_TSQL_KEY = "PL/SQL & T-SQL";
    private static final String TS_VB6_KEY = "VB6";
    private static final String TS_VB_SCRIPT_KEY = "VBScript";
    private static final String TS_XML_HTML_KEY = "XML/HTML";

    public static int tryParseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getFileExpressionPatternString(String technologyStack) {
        String constantFiles = "|.*\\.html|.*\\.htm|.*\\.js|.*\\.xml|.*\\.xsd|.*\\.xmi|.*\\.wsdd|.*\\.config|.*\\.settings|.*\\.cpx|.*\\.xcfg|.*\\.cscfg|.*\\.cscdef|.*\\.wadcfg|.*\\.appxmanifest|.*\\.wsdl|.*\\.plist|.*\\.properties|.*\\.ini|.*\\.sql|.*\\.pks|.*\\.pkh|.*\\.pkb";
        switch (technologyStack) {
            case ".NET": {
                return ".*\\.dll|.*\\.pdb|.*\\.cs|.*\\.aspx|.*\\.asp|.*\\.vb|.*\\.vbproj|.*\\.csproj|.*\\.sln|.*\\.cshtml|.*\\.vbhtml" + constantFiles;
            }
            case "JAVA/J2EE": {
                return ".*\\.java|.*\\.class|.*\\.ear|.*\\.war|.*\\.jar|.*\\.jsp|.*\\.tag|.*\\.tagx|.*\\.tld|.*\\.jspx|.*\\.xhtml|.*\\.faces|.*\\.jsff|.*\\.properties" + constantFiles;
            }
            case "Python": {
                return ".*\\.py" + constantFiles;
            }
            case "Ruby": {
                return ".*\\.rb|.*\\.erb" + constantFiles;
            }
            case "ASP": {
                return ".*\\.asp" + constantFiles;
            }
            case "PHP": {
                return ".*\\.php" + constantFiles;
            }
            case "VB6": {
                return ".*\\.vbs|.*\\.bas|.*\\.frm|.*\\.ctl|.*\\.cls" + constantFiles;
            }
            case "VBScript": {
                return ".*\\.vbscript" + constantFiles;
            }
            case "Android": {
                return ".*\\.java|.*\\.class|.*\\.ear|.*\\.war|.*\\.jar|.*\\.jsp|.*\\.tag|.*\\.tagx|.*\\.tld|.*\\.jspx|.*\\.xhtml|.*\\.faces|.*\\.jsff|.*\\.properties|.*\\.apk" + constantFiles;
            }
            case "XML/HTML": {
                return ".*\\.xml|.*\\.xsd|.*\\.xmi|.*\\.wsdd|.*\\.config|.*\\.cpx|.*\\.xcfg" + constantFiles;
            }
            case "PL/SQL & T-SQL": {
                return ".*\\.sql|.*\\.pks|.*\\.pkh|.*\\.pkb" + constantFiles;
            }
            case "ABAP": {
                return ".*\\.abap" + constantFiles;
            }
            case "CFML": {
                return ".*\\.cfm|.*\\.cfml|.*\\.cfc" + constantFiles;
            }
        }
        return ".*";
    }

    public static File createZipFile(String techStack, FilePath workspace, PrintStream logger) throws IOException {
        logger.println("Begin Create Zip.");
        logger.println("Source file directory: " + workspace);
        String tempDir = System.getProperty("java.io.tmpdir");
        File dir = new File(tempDir);
        File tempZip = File.createTempFile("fodupload", ".zip", dir);
        try (FileOutputStream fos = new FileOutputStream(tempZip);){
            Pattern pattern = Pattern.compile(Utils.getFileExpressionPatternString(techStack), 2);
            workspace.zip((OutputStream)fos, (FileFilter)new RegexFileFilter(pattern));
            logger.println("Temporary file created at: " + tempZip.getAbsolutePath());
        }
        catch (Exception e) {
            logger.println(e.getMessage());
        }
        logger.println("End Create Zip.");
        return tempZip;
    }

    public static String decrypt(String stringToDecrypt) {
        Secret decryptedSecret = Secret.decrypt((String)stringToDecrypt);
        return decryptedSecret != null ? decryptedSecret.getPlainText() : stringToDecrypt;
    }

    public static String decrypt(Secret stringToDecrypt) {
        return stringToDecrypt.getPlainText();
    }

    public static String encrypt(String stringToEncrypt) {
        String result = stringToEncrypt;
        if (Secret.decrypt((String)stringToEncrypt) == null) {
            result = Secret.fromString((String)stringToEncrypt).getEncryptedValue();
        }
        return result;
    }

    public static boolean isEncrypted(String stringToEncrypt) {
        return Secret.decrypt((String)stringToEncrypt) != null;
    }

    public static boolean isCredential(String id) {
        StringCredentials s = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null, null}), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id)}));
        return s != null;
    }

    public static String retrieveSecretDecryptedValue(String id) {
        StringCredentials s = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null, null}), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id)}));
        return s != null ? Utils.decrypt(s.getSecret()) : id;
    }
}

