/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.fodupload.SharedUploadBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class StaticAssessmentBuildStep
extends Recorder
implements SimpleBuildStep {
    SharedUploadBuildStep sharedBuildStep;

    @DataBoundConstructor
    public StaticAssessmentBuildStep(String bsiToken, boolean overrideGlobalConfig, String username, String personalAccessToken, String tenantId, boolean purchaseEntitlements, String entitlementPreference, String srcLocation, String remediationScanPreferenceType, String inProgressScanActionType) {
        this.sharedBuildStep = new SharedUploadBuildStep(bsiToken, overrideGlobalConfig, username, personalAccessToken, tenantId, purchaseEntitlements, entitlementPreference, srcLocation, remediationScanPreferenceType, inProgressScanActionType);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return this.sharedBuildStep.prebuild(build, listener);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) {
        this.sharedBuildStep.perform(build, workspace, launcher, listener);
    }

    public StaticAssessmentStepDescriptor getDescriptor() {
        return (StaticAssessmentStepDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getBsiToken() {
        return this.sharedBuildStep.getModel().getBsiTokenOriginal();
    }

    public String getUsername() {
        return this.sharedBuildStep.getAuthModel().getUsername();
    }

    public String getPersonalAccessToken() {
        return this.sharedBuildStep.getAuthModel().getPersonalAccessToken();
    }

    public String getTenantId() {
        return this.sharedBuildStep.getAuthModel().getTenantId();
    }

    public boolean getOverrideGlobalConfig() {
        return this.sharedBuildStep.getAuthModel().getOverrideGlobalConfig();
    }

    public String getEntitlementPreference() {
        return this.sharedBuildStep.getModel().getEntitlementPreference();
    }

    public boolean getPurchaseEntitlements() {
        return this.sharedBuildStep.getModel().isPurchaseEntitlements();
    }

    public String getSrcLocation() {
        return this.sharedBuildStep.getModel().getSrcLocation();
    }

    public String getRemediationScanPreferenceType() {
        return this.sharedBuildStep.getModel().getRemediationScanPreferenceType();
    }

    public String getInProgressScanActionType() {
        return this.sharedBuildStep.getModel().getInProgressScanActionType();
    }

    @Extension
    public static final class StaticAssessmentStepDescriptor
    extends BuildStepDescriptor<Publisher> {
        public StaticAssessmentStepDescriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheckBsiToken(@QueryParameter String bsiToken) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SharedUploadBuildStep.doCheckBsiToken(bsiToken);
        }

        public String getDisplayName() {
            return "Fortify on Demand Static Assessment";
        }

        @POST
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public FormValidation doTestPersonalAccessTokenConnection(@QueryParameter(value="username") String username, @QueryParameter(value="personalAccessToken") String personalAccessToken, @QueryParameter(value="tenantId") String tenantId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SharedUploadBuildStep.doTestPersonalAccessTokenConnection(username, personalAccessToken, tenantId);
        }

        public ListBoxModel doFillEntitlementPreferenceItems() {
            return SharedUploadBuildStep.doFillEntitlementPreferenceItems();
        }

        public ListBoxModel doFillRemediationScanPreferenceTypeItems() {
            return SharedUploadBuildStep.doFillRemediationScanPreferenceTypeItems();
        }

        public ListBoxModel doFillUsernameItems() {
            return SharedUploadBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillPersonalAccessTokenItems() {
            return SharedUploadBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillTenantIdItems() {
            return SharedUploadBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillInProgressScanActionTypeItems() {
            return SharedUploadBuildStep.doFillInProgressScanActionTypeItems();
        }
    }
}

