/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.fortify.fod.parser.BsiToken;
import com.fortify.fod.parser.BsiTokenParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.fodupload.ApiConnectionFactory;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.FodGlobalDescriptor;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.controllers.StaticScanController;
import org.jenkinsci.plugins.fodupload.models.AuthenticationModel;
import org.jenkinsci.plugins.fodupload.models.FodEnums;
import org.jenkinsci.plugins.fodupload.models.JobModel;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class SharedUploadBuildStep {
    public static final ThreadLocal<TaskListener> taskListener = new ThreadLocal();
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";
    public static final String USERNAME = "username";
    public static final String PERSONAL_ACCESS_TOKEN = "personalAccessToken";
    public static final String TENANT_ID = "tenantId";
    private JobModel model;
    private AuthenticationModel authModel;

    public SharedUploadBuildStep(String bsiToken, boolean overrideGlobalConfig, String username, String personalAccessToken, String tenantId, boolean purchaseEntitlements, String entitlementPreference, String srcLocation, String remediationScanPreferenceType, String inProgressScanActionType) {
        this.model = new JobModel(bsiToken, purchaseEntitlements, entitlementPreference, srcLocation, remediationScanPreferenceType, inProgressScanActionType);
        this.authModel = new AuthenticationModel(overrideGlobalConfig, username, personalAccessToken, tenantId);
    }

    public static FormValidation doCheckBsiToken(String bsiToken) {
        block4: {
            if (bsiToken != null && !bsiToken.isEmpty()) {
                BsiTokenParser tokenParser = new BsiTokenParser();
                try {
                    BsiToken testToken = tokenParser.parse(bsiToken);
                    if (testToken != null) {
                        return FormValidation.ok();
                    }
                    break block4;
                }
                catch (Exception ex) {
                    return FormValidation.error((String)"Could not parse BSI token.");
                }
            }
            return FormValidation.error((String)"Please specify BSI Token");
        }
        return FormValidation.error((String)"Please specify BSI Token");
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static FormValidation doTestPersonalAccessTokenConnection(String username, String personalAccessToken, String tenantId) {
        String baseUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getBaseUrl();
        String apiUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getApiUrl();
        String plainTextPersonalAccessToken = Utils.retrieveSecretDecryptedValue(personalAccessToken);
        if (Utils.isNullOrEmpty(baseUrl)) {
            return FormValidation.error((String)"Fortify on Demand URL is empty!");
        }
        if (Utils.isNullOrEmpty(apiUrl)) {
            return FormValidation.error((String)"Fortify on Demand API URL is empty!");
        }
        if (Utils.isNullOrEmpty(username)) {
            return FormValidation.error((String)"Username is empty!");
        }
        if (!Utils.isCredential(personalAccessToken)) {
            return FormValidation.error((String)"Personal Access Token is empty!");
        }
        if (Utils.isNullOrEmpty(tenantId)) {
            return FormValidation.error((String)"Tenant ID is null.");
        }
        FodApiConnection testApi = new FodApiConnection(tenantId + "\\" + username, plainTextPersonalAccessToken, baseUrl, apiUrl, FodEnums.GrantType.PASSWORD, "api-tenant");
        return ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).testConnection(testApi);
    }

    public static ListBoxModel doFillEntitlementPreferenceItems() {
        ListBoxModel items = new ListBoxModel();
        for (FodEnums.EntitlementPreferenceType preferenceType : FodEnums.EntitlementPreferenceType.values()) {
            items.add((Object)new ListBoxModel.Option(preferenceType.toString(), preferenceType.getValue()));
        }
        return items;
    }

    public static ListBoxModel doFillRemediationScanPreferenceTypeItems() {
        ListBoxModel items = new ListBoxModel();
        for (FodEnums.RemediationScanPreferenceType remediationType : FodEnums.RemediationScanPreferenceType.values()) {
            items.add((Object)new ListBoxModel.Option(remediationType.toString(), remediationType.getValue()));
        }
        return items;
    }

    public static ListBoxModel doFillStringCredentialsItems() {
        ListBoxModel items = CredentialsProvider.listCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, null, null);
        return items;
    }

    public static ListBoxModel doFillInProgressScanActionTypeItems() {
        ListBoxModel items = new ListBoxModel();
        for (FodEnums.InProgressScanActionType scanActionType : FodEnums.InProgressScanActionType.values()) {
            items.add((Object)new ListBoxModel.Option(scanActionType.toString(), scanActionType.getValue()));
        }
        return items;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        if (this.model == null) {
            logger.println("Unexpected Error");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (!this.model.initializeBuildModel()) {
            logger.println("Invalid BSI Token");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (!this.model.validate(logger)) {
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        File payload;
        FodApiConnection apiConnection;
        PrintStream logger;
        block38: {
            block37: {
                block34: {
                    block36: {
                        block35: {
                            logger = listener.getLogger();
                            apiConnection = null;
                            taskListener.set(listener);
                            if (this.authModel == null) break block34;
                            if (!this.authModel.getOverrideGlobalConfig()) break block35;
                            if (Utils.isCredential(this.authModel.getPersonalAccessToken())) break block34;
                            build.setResult(Result.UNSTABLE);
                            logger.println("Credentials must be re-entered for security purposes. Please update on the global configuration and/or post-build actions and then save your updates.");
                            if (apiConnection == null) return;
                            try {
                                apiConnection.retireToken();
                                return;
                            }
                            catch (IOException e) {
                                logger.println(String.format("Failed to retire oauth token. Response code is %s", e));
                            }
                            return;
                        }
                        if (!((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getAuthTypeIsApiKey()) break block36;
                        if (Utils.isCredential(((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getOriginalClientSecret())) break block34;
                        build.setResult(Result.UNSTABLE);
                        logger.println("Credentials must be re-entered for security purposes. Please update on the global configuration and/or post-build actions and then save your updates.");
                        if (apiConnection == null) return;
                        try {
                            apiConnection.retireToken();
                            return;
                        }
                        catch (IOException e) {
                            logger.println(String.format("Failed to retire oauth token. Response code is %s", e));
                        }
                        return;
                    }
                    if (Utils.isCredential(((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getOriginalPersonalAccessToken())) break block34;
                    build.setResult(Result.UNSTABLE);
                    logger.println("Credentials must be re-entered for security purposes. Please update on the global configuration and/or post-build actions and then save your updates.");
                    if (apiConnection == null) return;
                    try {
                        apiConnection.retireToken();
                        return;
                    }
                    catch (IOException e) {
                        logger.println(String.format("Failed to retire oauth token. Response code is %s", e));
                    }
                    return;
                }
                Result currentResult = build.getResult();
                if (!Result.FAILURE.equals(currentResult) && !Result.ABORTED.equals(currentResult) && !Result.UNSTABLE.equals(currentResult)) break block37;
                logger.println("Error: Build Failed or Unstable.  Halting with Fortify on Demand upload.");
                if (apiConnection == null) return;
                try {
                    apiConnection.retireToken();
                    return;
                }
                catch (IOException e) {
                    logger.println(String.format("Failed to retire oauth token. Response code is %s", e));
                }
                return;
            }
            logger.println("Starting FoD Upload.");
            if (this.model.getBsiToken() == null) {
                this.model.initializeBuildModel();
            }
            FilePath workspaceModified = new FilePath(workspace, this.model.getSrcLocation());
            payload = Utils.createZipFile(this.model.getBsiToken().getTechnologyStack(), workspaceModified, logger);
            if (payload.length() != 0L) break block38;
            boolean deleteSuccess = payload.delete();
            if (!deleteSuccess) {
                logger.println("Unable to delete empty payload.");
            }
            logger.println("Source is empty for given Technology Stack and Language Level.");
            build.setResult(Result.FAILURE);
            if (apiConnection == null) return;
            try {
                apiConnection.retireToken();
                return;
            }
            catch (IOException e) {
                logger.println(String.format("Failed to retire oauth token. Response code is %s", e));
            }
            return;
        }
        this.model.setPayload(payload);
        apiConnection = ApiConnectionFactory.createApiConnection(this.getAuthModel());
        if (apiConnection != null) {
            apiConnection.authenticate();
            StaticScanController staticScanController = new StaticScanController(apiConnection, logger);
            String notes = String.format("[%d] %s - Assessment submitted from Jenkins FoD Plugin", build.getNumber(), build.getDisplayName());
            boolean success = staticScanController.startStaticScan(this.model, notes);
            boolean deleted = payload.delete();
            if (success && deleted) {
                logger.println("Scan Uploaded Successfully.");
            }
            build.setResult(success && deleted ? Result.SUCCESS : Result.UNSTABLE);
        } else {
            logger.println("Failed to authenticate");
            build.setResult(Result.FAILURE);
        }
        if (apiConnection == null) return;
        try {
            apiConnection.retireToken();
            return;
        }
        catch (IOException e) {
            logger.println(String.format("Failed to retire oauth token. Response code is %s", e));
        }
        return;
        catch (IOException e) {
            logger.println(e.getMessage());
            build.setResult(Result.FAILURE);
            if (apiConnection == null) return;
            try {
                apiConnection.retireToken();
                return;
            }
            catch (IOException e2) {
                logger.println(String.format("Failed to retire oauth token. Response code is %s", e2));
            }
            return;
        }
        catch (IllegalArgumentException iae) {
            logger.println(iae.getMessage());
            build.setResult(Result.FAILURE);
            if (apiConnection == null) return;
            {
                catch (Throwable throwable) {
                    if (apiConnection == null) throw throwable;
                    try {
                        apiConnection.retireToken();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        logger.println(String.format("Failed to retire oauth token. Response code is %s", e2));
                    }
                    throw throwable;
                }
            }
            try {
                apiConnection.retireToken();
                return;
            }
            catch (IOException e3) {
                logger.println(String.format("Failed to retire oauth token. Response code is %s", e3));
            }
            return;
        }
    }

    public AuthenticationModel getAuthModel() {
        AuthenticationModel displayModel = new AuthenticationModel(this.authModel.getOverrideGlobalConfig(), this.authModel.getUsername(), this.authModel.getPersonalAccessToken(), this.authModel.getTenantId());
        return displayModel;
    }

    public AuthenticationModel setAuthModel(AuthenticationModel newAuthModel) {
        this.authModel = newAuthModel;
        return this.authModel;
    }

    public JobModel getModel() {
        return this.model;
    }
}

