/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.fortify.fod.parser.BsiToken;
import com.fortify.fod.parser.BsiTokenParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.fodupload.ApiConnectionFactory;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.FodGlobalDescriptor;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.models.AuthenticationModel;
import org.jenkinsci.plugins.fodupload.models.FodEnums;
import org.jenkinsci.plugins.fodupload.polling.PollReleaseStatusResult;
import org.jenkinsci.plugins.fodupload.polling.ScanStatusPoller;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class SharedPollingBuildStep {
    public static final BsiTokenParser tokenParser = new BsiTokenParser();
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";
    public static final String USERNAME = "username";
    public static final String PERSONAL_ACCESS_TOKEN = "personalAccessToken";
    public static final String TENANT_ID = "tenantId";
    private String bsiToken;
    private int pollingInterval;
    private int policyFailureBuildResultPreference;
    private AuthenticationModel authModel;

    public SharedPollingBuildStep(String bsiToken, boolean overrideGlobalConfig, int pollingInterval, int policyFailureBuildResultPreference, String clientId, String clientSecret, String username, String personalAccessToken, String tenantId) {
        this.bsiToken = bsiToken;
        this.pollingInterval = pollingInterval;
        this.policyFailureBuildResultPreference = policyFailureBuildResultPreference;
        this.authModel = new AuthenticationModel(overrideGlobalConfig, username, personalAccessToken, tenantId);
    }

    public static FormValidation doCheckBsiToken(String bsiToken) {
        block4: {
            if (bsiToken != null && !bsiToken.isEmpty()) {
                BsiTokenParser tokenParser = new BsiTokenParser();
                try {
                    BsiToken testToken = tokenParser.parse(bsiToken);
                    if (testToken != null) {
                        return FormValidation.ok();
                    }
                    break block4;
                }
                catch (Exception ex) {
                    return FormValidation.error((String)"Could not parse BSI token.");
                }
            }
            return FormValidation.error((String)"Please specify BSI Token");
        }
        return FormValidation.error((String)"Please specify BSI Token");
    }

    public static FormValidation doCheckPollingInterval(String pollingInterval) {
        if (Utils.isNullOrEmpty(pollingInterval)) {
            return FormValidation.error((String)"Polling interval is required to perform this step.");
        }
        try {
            int pollingIntervalNumeric = Integer.parseInt(pollingInterval);
            if (pollingIntervalNumeric <= 0) {
                return FormValidation.error((String)"Value must be greater than 0");
            }
        }
        catch (NumberFormatException ex) {
            return FormValidation.error((String)"Value must be integer");
        }
        return FormValidation.ok();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static FormValidation doTestPersonalAccessTokenConnection(String username, String personalAccessToken, String tenantId) {
        String baseUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getBaseUrl();
        String apiUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getApiUrl();
        String plainTextPersonalAccessToken = Utils.retrieveSecretDecryptedValue(personalAccessToken);
        if (Utils.isNullOrEmpty(baseUrl)) {
            return FormValidation.error((String)"Fortify on Demand URL is empty!");
        }
        if (Utils.isNullOrEmpty(apiUrl)) {
            return FormValidation.error((String)"Fortify on Demand API URL is empty!");
        }
        if (Utils.isNullOrEmpty(username)) {
            return FormValidation.error((String)"Username is empty!");
        }
        if (!Utils.isCredential(personalAccessToken)) {
            return FormValidation.error((String)"Personal Access Token is empty or needs to be resaved!");
        }
        if (Utils.isNullOrEmpty(tenantId)) {
            return FormValidation.error((String)"Tenant ID is null.");
        }
        FodApiConnection testApi = new FodApiConnection(tenantId + "\\" + username, plainTextPersonalAccessToken, baseUrl, apiUrl, FodEnums.GrantType.PASSWORD, "api-tenant");
        return ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).testConnection(testApi);
    }

    public static ListBoxModel doFillPolicyFailureBuildResultPreferenceItems() {
        ListBoxModel items = new ListBoxModel();
        for (PolicyFailureBuildResultPreference preferenceType : PolicyFailureBuildResultPreference.values()) {
            items.add((Object)new ListBoxModel.Option(preferenceType.toString(), String.valueOf(preferenceType.getValue())));
        }
        return items;
    }

    public static ListBoxModel doFillStringCredentialsItems() {
        ListBoxModel items = CredentialsProvider.listCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, null, null);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void perform(Run<?, ?> run, FilePath filePath, Launcher launcher, TaskListener taskListener) throws InterruptedException, IOException {
        Result currentResult;
        PrintStream logger = taskListener.getLogger();
        if (this.authModel != null) {
            if (this.authModel.getOverrideGlobalConfig()) {
                if (!Utils.isCredential(this.authModel.getPersonalAccessToken())) {
                    run.setResult(Result.UNSTABLE);
                    logger.println("Credentials must be re-entered for security purposes. Please update on the global configuration and/or post-build actions and then save your updates");
                    return;
                }
            } else if (((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getAuthTypeIsApiKey()) {
                if (!Utils.isCredential(((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getOriginalClientSecret())) {
                    run.setResult(Result.UNSTABLE);
                    logger.println("Credentials must be re-entered for security purposes. Please update on the global configuration and/or post-build actions and then save your updates");
                    return;
                }
            } else if (!Utils.isCredential(((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getOriginalPersonalAccessToken())) {
                run.setResult(Result.UNSTABLE);
                logger.println("Credentials must be re-entered for security purposes. Please update on the global configuration and/or post-build actions and then save your updates.");
                return;
            }
        }
        if (Result.FAILURE.equals(currentResult = run.getResult()) || Result.ABORTED.equals(currentResult) || Result.UNSTABLE.equals(currentResult)) {
            logger.println("Error: Build Failed or Unstable.  No reason to poll Fortify on Demand for results.");
            return;
        }
        if (this.getPollingInterval() <= 0) {
            logger.println("Error: Invalid polling interval (" + this.getPollingInterval() + " minutes)");
            run.setResult(Result.UNSTABLE);
            return;
        }
        FodApiConnection apiConnection = ApiConnectionFactory.createApiConnection(this.getAuthModel());
        try {
            BsiToken token = tokenParser.parse(this.getBsiToken());
            if (apiConnection != null) {
                apiConnection.authenticate();
                ScanStatusPoller poller = new ScanStatusPoller(apiConnection, this.getPollingInterval(), logger);
                PollReleaseStatusResult result = poller.pollReleaseStatus(token.getProjectVersionId());
                if (!result.isPollingSuccessful()) {
                    run.setResult(Result.FAILURE);
                    return;
                }
                if (!result.isPassing()) {
                    PolicyFailureBuildResultPreference pref = PolicyFailureBuildResultPreference.fromInt(this.getPolicyFailureBuildResultPreference());
                    switch (pref) {
                        case MarkFailure: {
                            run.setResult(Result.FAILURE);
                            break;
                        }
                        case MarkUnstable: {
                            run.setResult(Result.UNSTABLE);
                            break;
                        }
                    }
                }
            } else {
                logger.println("Failed to authenticate");
                run.setResult(Result.FAILURE);
            }
        }
        catch (URISyntaxException e) {
            logger.println("Failed to parse BSI.");
        }
        finally {
            if (apiConnection != null) {
                apiConnection.retireToken();
            }
        }
    }

    public String getBsiToken() {
        return this.bsiToken;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public int getPolicyFailureBuildResultPreference() {
        return this.policyFailureBuildResultPreference;
    }

    public AuthenticationModel getAuthModel() {
        AuthenticationModel displayModel = new AuthenticationModel(this.authModel.getOverrideGlobalConfig(), this.authModel.getUsername(), this.authModel.getPersonalAccessToken(), this.authModel.getTenantId());
        return displayModel;
    }

    public static enum PolicyFailureBuildResultPreference {
        None(0),
        MarkUnstable(1),
        MarkFailure(2);

        private final int _val;

        private PolicyFailureBuildResultPreference(int val) {
            this._val = val;
        }

        public static PolicyFailureBuildResultPreference fromInt(int val) {
            switch (val) {
                case 2: {
                    return MarkFailure;
                }
                case 1: {
                    return MarkUnstable;
                }
            }
            return None;
        }

        public int getValue() {
            return this._val;
        }

        public String toString() {
            switch (this._val) {
                case 2: {
                    return "Mark Failure";
                }
                case 1: {
                    return "Mark Unstable";
                }
            }
            return "Do nothing";
        }
    }
}

